/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryRuntimeClasspathScope
extends GlobalSearchScope {
    private final ProjectFileIndex myIndex;
    private final LinkedHashSet<VirtualFile> myEntries = new LinkedHashSet();
    private final List<Module> myModules;

    public LibraryRuntimeClasspathScope(Project project, List<Module> modules) {
        super(project);
        this.myModules = modules;
        this.myIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        HashSet<Module> processed = new HashSet<Module>();
        for (Module module : modules) {
            this.buildEntries(module, processed);
        }
    }

    public int hashCode() {
        return ((Object)this.myModules).hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != LibraryRuntimeClasspathScope.class) {
            return false;
        }
        LibraryRuntimeClasspathScope that = (LibraryRuntimeClasspathScope)((Object)object);
        return ((Object)that.myModules).equals(this.myModules);
    }

    private void buildEntries(@NotNull Module module, final Set<Module> processedModules) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/impl/scopes/LibraryRuntimeClasspathScope.buildEntries must not be null");
        }
        if (!processedModules.add(module)) {
            return;
        }
        THashSet myJDKProcessed = new THashSet();
        ModuleRootManager.getInstance((Module)module).processOrder((RootPolicy)new RootPolicy<LinkedHashSet<VirtualFile>>((Set)myJDKProcessed){
            final /* synthetic */ Set val$myJDKProcessed;
            {
                this.val$myJDKProcessed = set2;
            }

            public LinkedHashSet<VirtualFile> visitLibraryOrderEntry(LibraryOrderEntry libraryOrderEntry, LinkedHashSet<VirtualFile> value) {
                value.addAll(Arrays.asList(libraryOrderEntry.getFiles(OrderRootType.CLASSES)));
                return value;
            }

            public LinkedHashSet<VirtualFile> visitModuleOrderEntry(ModuleOrderEntry moduleOrderEntry, LinkedHashSet<VirtualFile> value) {
                Module depModule = moduleOrderEntry.getModule();
                if (depModule != null) {
                    LibraryRuntimeClasspathScope.this.buildEntries(depModule, processedModules);
                }
                return value;
            }

            public LinkedHashSet<VirtualFile> visitModuleSourceOrderEntry(ModuleSourceOrderEntry moduleSourceOrderEntry, LinkedHashSet<VirtualFile> value) {
                value.addAll(Arrays.asList(moduleSourceOrderEntry.getFiles(OrderRootType.SOURCES)));
                return value;
            }

            public LinkedHashSet<VirtualFile> visitJdkOrderEntry(JdkOrderEntry jdkOrderEntry, LinkedHashSet<VirtualFile> value) {
                if (!this.val$myJDKProcessed.add(jdkOrderEntry.getJdk())) {
                    return value;
                }
                value.addAll(Arrays.asList(jdkOrderEntry.getFiles(OrderRootType.CLASSES)));
                return value;
            }
        }, this.myEntries);
    }

    public boolean contains(VirtualFile file) {
        return this.myEntries.contains(this.getFileRoot(file));
    }

    @Nullable
    private VirtualFile getFileRoot(VirtualFile file) {
        if (this.myIndex.isLibraryClassFile(file)) {
            return this.myIndex.getClassRootForFile(file);
        }
        if (this.myIndex.isInContent(file)) {
            return this.myIndex.getSourceRootForFile(file);
        }
        if (this.myIndex.isInLibraryClasses(file)) {
            return this.myIndex.getClassRootForFile(file);
        }
        return null;
    }

    public int compare(VirtualFile file1, VirtualFile file2) {
        VirtualFile r1 = this.getFileRoot(file1);
        VirtualFile r2 = this.getFileRoot(file2);
        for (VirtualFile root : this.myEntries) {
            if (r1 == root) {
                return 1;
            }
            if (r2 != root) continue;
            return -1;
        }
        return 0;
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/impl/scopes/LibraryRuntimeClasspathScope.isSearchInModuleContent must not be null");
        }
        return false;
    }

    public boolean isSearchInLibraries() {
        return true;
    }
}

