/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.CommonBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.module.ConfigurationErrorDescription;
import com.intellij.openapi.module.ProjectLoadingErrorsNotifier;
import com.intellij.openapi.module.impl.RemoveInvalidElementsDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntProcedure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class ProjectLoadingErrorsNotifierImpl
extends ProjectLoadingErrorsNotifier {
    private final List<ConfigurationErrorDescription> myErrors = new ArrayList<ConfigurationErrorDescription>();
    private final Object myLock = new Object();
    private final Project myProject;

    public ProjectLoadingErrorsNotifierImpl(Project project) {
        this.myProject = project;
    }

    @Override
    public void registerError(ConfigurationErrorDescription errorDescription) {
        this.registerErrors(Collections.singletonList(errorDescription));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerErrors(Collection<? extends ConfigurationErrorDescription> errorDescriptions) {
        boolean first;
        if (this.myProject.isDisposed() || this.myProject.isDefault() || errorDescriptions.isEmpty()) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            first = this.myErrors.isEmpty();
            this.myErrors.addAll(errorDescriptions);
        }
        if (this.myProject.isInitialized()) {
            this.fireNotifications();
        } else if (first) {
            StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity(new Runnable(){

                @Override
                public void run() {
                    ProjectLoadingErrorsNotifierImpl.this.fireNotifications();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNotifications() {
        ConfigurationErrorDescription[] descriptions;
        Object object = this.myLock;
        synchronized (object) {
            if (this.myErrors.isEmpty()) {
                return;
            }
            descriptions = this.myErrors.toArray(new ConfigurationErrorDescription[this.myErrors.size()]);
            this.myErrors.clear();
        }
        final String invalidElements = ProjectLoadingErrorsNotifierImpl.getInvalidElementsString(descriptions);
        String errorText = ProjectBundle.message((String)"error.message.configuration.cannot.load", (Object[])new Object[0]) + " " + invalidElements + " <a href=\"\">Details...</a>";
        Notifications.Bus.notify((Notification)new Notification("Project Loading Error", "Error Loading Project", errorText, NotificationType.ERROR, new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/impl/ProjectLoadingErrorsNotifierImpl$2.hyperlinkUpdate must not be null");
                }
                if (event == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/module/impl/ProjectLoadingErrorsNotifierImpl$2.hyperlinkUpdate must not be null");
                }
                List validDescriptions = ContainerUtil.findAll((Object[])descriptions, (Condition)new Condition<ConfigurationErrorDescription>(){

                    public boolean value(ConfigurationErrorDescription errorDescription) {
                        return errorDescription.isValid();
                    }
                });
                RemoveInvalidElementsDialog.showDialog(ProjectLoadingErrorsNotifierImpl.this.myProject, CommonBundle.getErrorTitle(), invalidElements, validDescriptions);
                notification.expire();
            }
        }), (Project)this.myProject);
    }

    private static String getInvalidElementsString(ConfigurationErrorDescription[] descriptions) {
        if (descriptions.length == 1) {
            ConfigurationErrorDescription description = descriptions[0];
            return description.getElementKind() + " " + description.getElementName();
        }
        TObjectIntHashMap kind2count = new TObjectIntHashMap();
        for (ConfigurationErrorDescription description : descriptions) {
            String kind = description.getElementKind();
            if (!kind2count.contains((Object)kind)) {
                kind2count.put((Object)kind, 1);
                continue;
            }
            kind2count.increment((Object)kind);
        }
        final StringBuilder message = new StringBuilder();
        kind2count.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<String>(){

            public boolean execute(String a, int b) {
                if (message.length() > 0) {
                    message.append(' ').append(ProjectBundle.message((String)"text.and", (Object[])new Object[0])).append(' ');
                }
                message.append(b).append(' ').append(b > 1 ? StringUtil.pluralize((String)a) : a);
                return true;
            }
        });
        return message.toString();
    }
}

