/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.FilteredQuery;
import org.jetbrains.annotations.Nullable;

public class ResourceFileUtil {
    private ResourceFileUtil() {
    }

    @Nullable
    public static VirtualFile findResourceFile(String name, Module inModule) {
        VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)inModule).getSourceRoots();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)inModule.getProject()).getFileIndex();
        for (VirtualFile sourceRoot : sourceRoots) {
            String packagePrefix = fileIndex.getPackageNameByDirectory(sourceRoot);
            String prefix = packagePrefix == null || packagePrefix.length() == 0 ? null : packagePrefix.replace('.', '/') + "/";
            String relPath = prefix != null && name.startsWith(prefix) && name.length() > prefix.length() ? name.substring(prefix.length()) : name;
            String fullPath = sourceRoot.getPath() + "/" + relPath;
            VirtualFile fileByPath = LocalFileSystem.getInstance().findFileByPath(fullPath);
            if (fileByPath == null) continue;
            return fileByPath;
        }
        return null;
    }

    @Nullable
    public static VirtualFile findResourceFileInDependents(Module searchFromModule, String fileName) {
        return ResourceFileUtil.findResourceFileInScope(fileName, searchFromModule.getProject(), searchFromModule.getModuleWithDependenciesScope());
    }

    @Nullable
    public static VirtualFile findResourceFileInProject(Project project, String resourceName) {
        return ResourceFileUtil.findResourceFileInScope(resourceName, project, GlobalSearchScope.projectScope((Project)project));
    }

    @Nullable
    public static VirtualFile findResourceFileInScope(String resourceName, Project project, final GlobalSearchScope scope) {
        int index = resourceName.lastIndexOf(47);
        String packageName = index >= 0 ? resourceName.substring(0, index).replace('/', '.') : "";
        final String fileName = index >= 0 ? resourceName.substring(index + 1) : resourceName;
        VirtualFile dir = (VirtualFile)new FilteredQuery(DirectoryIndex.getInstance(project).getDirectoriesByPackageName(packageName, false), (Condition)new Condition<VirtualFile>(){

            public boolean value(VirtualFile file) {
                VirtualFile child = file.findChild(fileName);
                return child != null && scope.contains(child);
            }
        }).findFirst();
        return dir != null ? dir.findChild(fileName) : null;
    }
}

