/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.AppTopics;
import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DocumentContent;
import com.intellij.openapi.diff.SimpleContent;
import com.intellij.openapi.diff.SimpleDiffRequest;
import com.intellij.openapi.diff.ex.DiffPanelOptions;
import com.intellij.openapi.diff.impl.DiffPanelImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditReadOnlyListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileEditor.FileDocumentSynchronizationVetoListener;
import com.intellij.openapi.fileEditor.VetoDocumentReloadException;
import com.intellij.openapi.fileEditor.VetoDocumentSavingException;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileEditor.impl.TrailingSpacesStripper;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.SafeWriteRequestor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.ex.dummy.DummyFileSystem;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.psi.ExternalChangeAction;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.UIBundle;
import com.intellij.util.EventDispatcher;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileDocumentManagerImpl
extends FileDocumentManager
implements ApplicationComponent,
VirtualFileListener,
SafeWriteRequestor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl");
    private static final Key<String> LINE_SEPARATOR_KEY = Key.create((String)"LINE_SEPARATOR_KEY");
    public static final Key<Reference<Document>> DOCUMENT_KEY = Key.create((String)"DOCUMENT_KEY");
    private static final Key<VirtualFile> FILE_KEY = Key.create((String)"FILE_KEY");
    private final Set<Document> myUnsavedDocuments = new HashSet<Document>();
    private final EditReadOnlyListener myReadOnlyListener = new MyEditReadOnlyListener();
    private final EventDispatcher<FileDocumentSynchronizationVetoListener> myVetoDispatcher = EventDispatcher.create(FileDocumentSynchronizationVetoListener.class);
    private final VirtualFileManager myVirtualFileManager;
    private final MessageBus myBus;
    private static final Object lock = new Object();
    private final Map<FileDocumentManagerListener, MessageBusConnection> myAdapters = new HashMap<FileDocumentManagerListener, MessageBusConnection>();

    public FileDocumentManagerImpl(VirtualFileManager virtualFileManager) {
        this.myVirtualFileManager = virtualFileManager;
        this.myVirtualFileManager.addVirtualFileListener((VirtualFileListener)this);
        this.myBus = ApplicationManager.getApplication().getMessageBus();
        this.myBus.connect().subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new TrailingSpacesStripper());
    }

    @NotNull
    public String getComponentName() {
        if ("FileDocumentManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl.getComponentName must not return null");
        }
        return "FileDocumentManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getDocument(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl.getDocument must not be null");
        }
        DocumentEx document = (DocumentEx)this.getCachedDocument(file);
        if (document == null) {
            if (file.isDirectory() || FileDocumentManagerImpl.isBinaryWithoutDecompiler(file)) {
                return null;
            }
            CharSequence text = LoadTextUtil.loadText(file);
            Object object = lock;
            synchronized (object) {
                document = (DocumentEx)this.getCachedDocument(file);
                if (document != null) {
                    return document;
                }
                document = (DocumentEx)FileDocumentManagerImpl.createDocument(text);
                document.setModificationStamp(file.getModificationStamp());
                FileType fileType = file.getFileType();
                document.setReadOnly(!file.isWritable() || fileType.isBinary());
                file.putUserData(DOCUMENT_KEY, new WeakReference<DocumentEx>(document));
                document.putUserData(FILE_KEY, file);
                if (!(file instanceof LightVirtualFile) && !(file.getFileSystem() instanceof DummyFileSystem)) {
                    document.addDocumentListener((DocumentListener)new DocumentAdapter(){

                        public void documentChanged(DocumentEvent e) {
                            Document document = e.getDocument();
                            FileDocumentManagerImpl.this.myUnsavedDocuments.add(document);
                            Runnable currentCommand = CommandProcessor.getInstance().getCurrentCommand();
                            Project project = currentCommand == null ? null : CommandProcessor.getInstance().getCurrentCommandProject();
                            String lineSeparator = CodeStyleFacade.getInstance((Project)project).getLineSeparator();
                            document.putUserData(LINE_SEPARATOR_KEY, (Object)lineSeparator);
                        }
                    });
                    document.addEditReadOnlyListener(this.myReadOnlyListener);
                }
            }
            this.fireFileContentLoaded(file, document);
        }
        return document;
    }

    private static Document createDocument(CharSequence text) {
        return EditorFactory.getInstance().createDocument(text);
    }

    @Nullable
    public Document getCachedDocument(@NotNull VirtualFile file) {
        Document document;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl.getCachedDocument must not be null");
        }
        Reference reference = (Reference)file.getUserData(DOCUMENT_KEY);
        Document document2 = document = reference != null ? (Document)reference.get() : null;
        if (document != null && FileDocumentManagerImpl.isBinaryWithoutDecompiler(file)) {
            file.putUserData(DOCUMENT_KEY, null);
            document.putUserData(FILE_KEY, null);
            return null;
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerDocument(final Document document, VirtualFile virtualFile) {
        Object object = lock;
        synchronized (object) {
            virtualFile.putUserData(DOCUMENT_KEY, (Object)new SoftReference<Document>(document){

                @Override
                public Document get() {
                    return document;
                }
            });
            document.putUserData(FILE_KEY, (Object)virtualFile);
        }
    }

    public VirtualFile getFile(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl.getFile must not be null");
        }
        return (VirtualFile)document.getUserData(FILE_KEY);
    }

    public void dropAllUnsavedDocuments() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RuntimeException("This method is only for test mode!");
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.myUnsavedDocuments.size() > 0) {
            this.myUnsavedDocuments.clear();
            this.fireUnsavedDocumensDropped();
        }
    }

    public void saveAllDocuments() {
        int count;
        ((FileDocumentManagerListener)this.myBus.syncPublisher(AppTopics.FILE_DOCUMENT_SYNC)).beforeAllDocumentsSaving();
        if (this.myUnsavedDocuments.isEmpty()) {
            return;
        }
        HashSet<Document> failedToSave = new HashSet<Document>();
        do {
            Document[] unsavedDocuments = this.getUnsavedDocuments();
            count = 0;
            for (Document document : unsavedDocuments) {
                if (failedToSave.contains(document)) continue;
                this.saveDocument(document);
                ++count;
                if (!this.myUnsavedDocuments.contains(document)) continue;
                failedToSave.add(document);
            }
        } while (count != 0);
    }

    public void saveDocument(final @NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl.saveDocument must not be null");
        }
        if (!this.myUnsavedDocuments.contains(document)) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                FileDocumentManagerImpl.this._saveDocument(document);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _saveDocument(Document document) {
        block28: {
            VirtualFile file;
            boolean committed;
            block23: {
                block26: {
                    block24: {
                        block25: {
                            block21: {
                                block22: {
                                    block19: {
                                        block20: {
                                            committed = false;
                                            file = this.getFile(document);
                                            if (file != null && file.isValid() && !(file instanceof LightVirtualFile)) break block19;
                                            this.myUnsavedDocuments.remove(document);
                                            LOG.assertTrue(!this.myUnsavedDocuments.contains(document));
                                            if (!committed) break block20;
                                            this.myUnsavedDocuments.remove(document);
                                            LOG.assertTrue(!this.myUnsavedDocuments.contains(document));
                                            ((DocumentEx)document).clearLineModificationFlags();
                                        }
                                        return;
                                    }
                                    if (this.isFileModified(file)) break block21;
                                    this.myUnsavedDocuments.remove(document);
                                    LOG.assertTrue(!this.myUnsavedDocuments.contains(document));
                                    if (!committed) break block22;
                                    this.myUnsavedDocuments.remove(document);
                                    LOG.assertTrue(!this.myUnsavedDocuments.contains(document));
                                    ((DocumentEx)document).clearLineModificationFlags();
                                }
                                return;
                            }
                            if (!FileDocumentManagerImpl.needsRefresh(file)) break block23;
                            file.refresh(false, false);
                            if (this.myUnsavedDocuments.contains(document)) break block24;
                            if (!committed) break block25;
                            this.myUnsavedDocuments.remove(document);
                            LOG.assertTrue(!this.myUnsavedDocuments.contains(document));
                            ((DocumentEx)document).clearLineModificationFlags();
                        }
                        return;
                    }
                    if (file.isValid()) break block23;
                    if (!committed) break block26;
                    this.myUnsavedDocuments.remove(document);
                    LOG.assertTrue(!this.myUnsavedDocuments.contains(document));
                    ((DocumentEx)document).clearLineModificationFlags();
                }
                return;
            }
            try {
                for (FileDocumentSynchronizationVetoListener listener : this.myVetoDispatcher.getListeners()) {
                    listener.beforeDocumentSaving(document);
                }
            }
            catch (VetoDocumentSavingException e) {
                if (committed) {
                    this.myUnsavedDocuments.remove(document);
                    LOG.assertTrue(!this.myUnsavedDocuments.contains(document));
                    ((DocumentEx)document).clearLineModificationFlags();
                }
                return;
            }
            try {
                ((FileDocumentManagerListener)this.myBus.syncPublisher(AppTopics.FILE_DOCUMENT_SYNC)).beforeDocumentSaving(document);
                LOG.assertTrue(file.isValid());
                String text = document.getText();
                String lineSeparator = FileDocumentManagerImpl.getLineSeparator(document, file);
                if (!lineSeparator.equals("\n")) {
                    text = StringUtil.convertLineSeparators((String)text, (String)lineSeparator);
                }
                Project project = ProjectLocator.getInstance().guessProjectForFile(file);
                Writer writer = null;
                try {
                    writer = LoadTextUtil.getWriter(project, file, (Object)this, text, document.getModificationStamp());
                    writer.write(text);
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                }
                committed = true;
                if (!committed) break block28;
                this.myUnsavedDocuments.remove(document);
            }
            catch (IOException e) {
                try {
                    this.reportErrorOnSave(e);
                    committed = false;
                    if (!committed) break block28;
                    this.myUnsavedDocuments.remove(document);
                }
                catch (Throwable throwable) {
                    if (committed) {
                        this.myUnsavedDocuments.remove(document);
                        LOG.assertTrue(!this.myUnsavedDocuments.contains(document));
                        ((DocumentEx)document).clearLineModificationFlags();
                    }
                    throw throwable;
                }
                LOG.assertTrue(!this.myUnsavedDocuments.contains(document));
                ((DocumentEx)document).clearLineModificationFlags();
            }
            LOG.assertTrue(!this.myUnsavedDocuments.contains(document));
            ((DocumentEx)document).clearLineModificationFlags();
        }
    }

    private static boolean needsRefresh(VirtualFile file) {
        VirtualFileSystem fs = file.getFileSystem();
        return fs instanceof NewVirtualFileSystem && file.getTimeStamp() != ((NewVirtualFileSystem)fs).getTimeStamp(file);
    }

    private static String getLineSeparator(Document document, VirtualFile file) {
        String lineSeparator = (String)file.getUserData(LoadTextUtil.DETECTED_LINE_SEPARATOR_KEY);
        if (lineSeparator == null) {
            lineSeparator = (String)document.getUserData(LINE_SEPARATOR_KEY);
        }
        return lineSeparator;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getLineSeparator(@Nullable VirtualFile file, @Nullable Project project) {
        String string;
        String lineSeparator;
        String string2 = lineSeparator = file != null ? (String)file.getUserData(LoadTextUtil.DETECTED_LINE_SEPARATOR_KEY) : null;
        if (lineSeparator == null) {
            CodeStyleFacade settingsManager = project == null ? CodeStyleFacade.getInstance() : CodeStyleFacade.getInstance((Project)project);
            string = settingsManager.getLineSeparator();
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl.getLineSeparator must not return null");
            return string;
        }
        string = lineSeparator;
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl.getLineSeparator must not return null");
    }

    public boolean requestWriting(@NotNull Document document, Project project) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl.requestWriting must not be null");
        }
        VirtualFile file = FileDocumentManagerImpl.getInstance().getFile(document);
        if (project != null && file != null && file.isValid()) {
            return ReadonlyStatusHandler.ensureFilesWritable((Project)project, (VirtualFile[])new VirtualFile[]{file});
        }
        if (document.isWritable()) {
            return true;
        }
        document.fireReadOnlyModificationAttempt();
        return false;
    }

    public void reloadFiles(VirtualFile ... files) {
        for (VirtualFile file : files) {
            Document doc;
            if (!file.exists() || (doc = this.getCachedDocument(file)) == null) continue;
            this.reloadFromDisk(doc);
        }
    }

    @NotNull
    public Document[] getUnsavedDocuments() {
        Document[] documentArray = this.myUnsavedDocuments.toArray(new Document[this.myUnsavedDocuments.size()]);
        if (documentArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl.getUnsavedDocuments must not return null");
        }
        return documentArray;
    }

    public boolean isDocumentUnsaved(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl.isDocumentUnsaved must not be null");
        }
        return this.myUnsavedDocuments.contains(document);
    }

    public boolean isFileModifiedAndDocumentUnsaved(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl.isFileModifiedAndDocumentUnsaved must not be null");
        }
        Document doc = this.getCachedDocument(file);
        return doc != null && doc.getModificationStamp() != file.getModificationStamp() && this.isDocumentUnsaved(doc);
    }

    public boolean isFileModified(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl.isFileModified must not be null");
        }
        Document doc = this.getCachedDocument(file);
        return doc != null && doc.getModificationStamp() != file.getModificationStamp();
    }

    public void addFileDocumentSynchronizationVetoer(@NotNull FileDocumentSynchronizationVetoListener vetoer) {
        if (vetoer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl.addFileDocumentSynchronizationVetoer must not be null");
        }
        this.myVetoDispatcher.addListener((EventListener)vetoer);
    }

    public void removeFileDocumentSynchronizationVetoer(@NotNull FileDocumentSynchronizationVetoListener vetoer) {
        if (vetoer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl.removeFileDocumentSynchronizationVetoer must not be null");
        }
        this.myVetoDispatcher.removeListener((EventListener)vetoer);
    }

    public void addFileDocumentManagerListener(@NotNull FileDocumentManagerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl.addFileDocumentManagerListener must not be null");
        }
        MessageBusConnection connection = this.myBus.connect();
        this.myAdapters.put(listener, connection);
        connection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)listener);
    }

    public void removeFileDocumentManagerListener(@NotNull FileDocumentManagerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl.removeFileDocumentManagerListener must not be null");
        }
        MessageBusConnection connection = this.myAdapters.remove(listener);
        if (connection != null) {
            connection.disconnect();
        }
    }

    public void propertyChanged(final VirtualFilePropertyEvent event) {
        if ("writable".equals(event.getPropertyName())) {
            VirtualFile file = event.getFile();
            final Document document = this.getCachedDocument(file);
            if (document == null) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction((Runnable)new ExternalChangeAction(){

                @Override
                public void run() {
                    document.setReadOnly(!event.getFile().isWritable());
                }
            });
        }
    }

    private static boolean isBinaryWithDecompiler(VirtualFile file) {
        FileType ft = file.getFileType();
        return ft.isBinary() && BinaryFileTypeDecompilers.INSTANCE.forFileType(ft) != null;
    }

    private static boolean isBinaryWithoutDecompiler(VirtualFile file) {
        FileType ft = file.getFileType();
        return ft.isBinary() && BinaryFileTypeDecompilers.INSTANCE.forFileType(ft) == null;
    }

    public void contentsChanged(VirtualFileEvent event) {
        long oldFileStamp;
        long documentStamp;
        if (event.isFromSave()) {
            return;
        }
        final VirtualFile file = event.getFile();
        final Document document = this.getCachedDocument(file);
        if (document == null) {
            this.fireFileWithNoDocumentChanged(file);
            return;
        }
        if (FileDocumentManagerImpl.isBinaryWithDecompiler(file)) {
            this.fireFileWithNoDocumentChanged(file);
        }
        if ((documentStamp = document.getModificationStamp()) != (oldFileStamp = event.getOldModificationStamp())) {
            LOG.info("reaload from disk?");
            LOG.info("  documentStamp:" + documentStamp);
            LOG.info("  oldFileStamp:" + oldFileStamp);
            Runnable askReloadRunnable = new Runnable(){

                @Override
                public void run() {
                    if (!file.isValid()) {
                        return;
                    }
                    if (FileDocumentManagerImpl.this.askReloadFromDisk(file, document)) {
                        FileDocumentManagerImpl.this.reloadFromDisk(document);
                    }
                }
            };
            askReloadRunnable.run();
        } else {
            this.reloadFromDisk(document);
        }
    }

    private void fireFileWithNoDocumentChanged(VirtualFile file) {
        ((FileDocumentManagerListener)this.myBus.syncPublisher(AppTopics.FILE_DOCUMENT_SYNC)).fileWithNoDocumentChanged(file);
    }

    public void reloadFromDisk(final @NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl.reloadFromDisk must not be null");
        }
        final VirtualFile file = this.getFile(document);
        try {
            this.fireBeforeFileContentReload(file, document);
        }
        catch (VetoDocumentReloadException e) {
            return;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        Project project = ProjectLocator.getInstance().guessProjectForFile(file);
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction((Runnable)new ExternalChangeAction(){

                    @Override
                    public void run() {
                        boolean wasWritable = document.isWritable();
                        DocumentEx documentEx = (DocumentEx)document;
                        documentEx.setReadOnly(false);
                        documentEx.replaceText(LoadTextUtil.loadText(file), file.getModificationStamp());
                        documentEx.setReadOnly(!wasWritable);
                    }
                });
            }
        }, UIBundle.message((String)"file.cache.conflict.action", (Object[])new Object[0]), null);
        this.myUnsavedDocuments.remove(document);
        try {
            this.fireFileContentReloaded(file, document);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    protected boolean askReloadFromDisk(final VirtualFile file, final Document document) {
        if (!this.isDocumentUnsaved(document)) {
            return true;
        }
        String message = UIBundle.message((String)"file.cache.conflict.message.text", (Object[])new Object[]{file.getPresentableUrl()});
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RuntimeException(message);
        }
        final DialogBuilder builder = new DialogBuilder((Project)null);
        builder.setCenterPanel((JComponent)new JLabel(message, Messages.getQuestionIcon(), 0));
        builder.addOkAction().setText(UIBundle.message((String)"file.cache.conflict.load.fs.changes.button", (Object[])new Object[0]));
        builder.addCancelAction().setText(UIBundle.message((String)"file.cache.conflict.keep.memory.changes.button", (Object[])new Object[0]));
        builder.addAction((Action)new AbstractAction(UIBundle.message((String)"file.cache.conflict.show.difference.button", (Object[])new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                String windowtitle = UIBundle.message((String)"file.cache.conflict.for.file.dialog.title", (Object[])new Object[]{file.getPresentableUrl()});
                ProjectEx project = (ProjectEx)ProjectLocator.getInstance().guessProjectForFile(file);
                SimpleDiffRequest request = new SimpleDiffRequest((Project)project, windowtitle);
                FileType fileType = file.getFileType();
                String fsContent = ((Object)LoadTextUtil.loadText(file)).toString();
                request.setContents((DiffContent)new SimpleContent(fsContent, fileType), (DiffContent)new DocumentContent((Project)project, document, fileType));
                request.setContentTitles(UIBundle.message((String)"file.cache.conflict.diff.content.file.system.content", (Object[])new Object[0]), UIBundle.message((String)"file.cache.conflict.diff.content.memory.content", (Object[])new Object[0]));
                DialogBuilder diffBuilder = new DialogBuilder((Project)project);
                DiffPanelImpl diffPanel = (DiffPanelImpl)DiffManager.getInstance().createDiffPanel(diffBuilder.getWindow(), (Project)project);
                diffPanel.getOptions().setShowSourcePolicy(DiffPanelOptions.ShowSourcePolicy.DONT_SHOW);
                diffBuilder.setCenterPanel(diffPanel.getComponent());
                diffPanel.setDiffRequest((DiffRequest)request);
                diffBuilder.addOkAction().setText(UIBundle.message((String)"file.cache.conflict.save.changes.button", (Object[])new Object[0]));
                diffBuilder.addCancelAction();
                diffBuilder.setTitle(windowtitle);
                diffBuilder.addDisposable((Disposable)diffPanel);
                if (diffBuilder.show() == 0) {
                    builder.getDialogWrapper().close(1);
                }
            }
        });
        builder.setTitle(UIBundle.message((String)"file.cache.conflict.dialog.title", (Object[])new Object[0]));
        builder.setButtonsAlignment(0);
        builder.setHelpId("reference.dialogs.fileCacheConflict");
        return builder.show() == 0;
    }

    protected void reportErrorOnSave(final IOException e) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                Messages.showMessageDialog((String)UIBundle.message((String)"cannot.save.file.with.error.error.message", (Object[])new Object[]{e.getMessage()}), (String)UIBundle.message((String)"cannot.save.file.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            }
        });
    }

    public void fileCreated(VirtualFileEvent event) {
    }

    public void fileDeleted(VirtualFileEvent event) {
    }

    public void fileMoved(VirtualFileMoveEvent event) {
    }

    public void fileCopied(VirtualFileCopyEvent event) {
        this.fileCreated((VirtualFileEvent)event);
    }

    public void beforePropertyChange(VirtualFilePropertyEvent event) {
    }

    public void beforeContentsChange(VirtualFileEvent event) {
    }

    public void beforeFileDeletion(VirtualFileEvent event) {
    }

    public void beforeFileMovement(VirtualFileMoveEvent event) {
    }

    private void fireFileContentReloaded(VirtualFile file, Document document) {
        ((FileDocumentManagerListener)this.myBus.syncPublisher(AppTopics.FILE_DOCUMENT_SYNC)).fileContentReloaded(file, document);
    }

    private void fireUnsavedDocumensDropped() {
        ((FileDocumentManagerListener)this.myBus.syncPublisher(AppTopics.FILE_DOCUMENT_SYNC)).unsavedDocumentsDropped();
    }

    private void fireBeforeFileContentReload(VirtualFile file, Document document) throws VetoDocumentReloadException {
        List listeners = this.myVetoDispatcher.getListeners();
        for (FileDocumentSynchronizationVetoListener listener : listeners) {
            try {
                listener.beforeFileContentReload(file, document);
            }
            catch (AbstractMethodError e) {}
        }
        ((FileDocumentManagerListener)this.myBus.syncPublisher(AppTopics.FILE_DOCUMENT_SYNC)).beforeFileContentReload(file, document);
    }

    private void fireFileContentLoaded(VirtualFile file, DocumentEx document) {
    }

    private final class MyEditReadOnlyListener
    implements EditReadOnlyListener {
        private MyEditReadOnlyListener() {
        }

        @Override
        public void readOnlyModificationAttempt(Document document) {
            VirtualFile file = FileDocumentManagerImpl.this.getFile(document);
            if (file == null) {
                return;
            }
            FileDocumentManagerImpl.this.myVirtualFileManager.fireReadOnlyModificationAttempt(new VirtualFile[]{file});
        }
    }
}

