/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.EditorPopupHandler;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class EditorActionUtil {
    protected static final Object EDIT_COMMAND_GROUP = Key.create((String)"EditGroup");
    protected static final Object DELETE_COMMAND_GROUP = Key.create((String)"DeleteGroup");

    public static void scrollRelatively(Editor editor, int lineShift) {
        if (lineShift != 0) {
            editor.getScrollingModel().scrollVertically(editor.getScrollingModel().getVerticalScrollOffset() + lineShift * editor.getLineHeight());
        }
        Rectangle viewRectangle = editor.getScrollingModel().getVisibleArea();
        int lineNumber = editor.getCaretModel().getVisualPosition().line;
        if (viewRectangle != null) {
            VisualPosition startPos = editor.xyToVisualPosition(new Point(0, viewRectangle.y));
            int start = startPos.line + 1;
            VisualPosition endPos = editor.xyToVisualPosition(new Point(0, viewRectangle.y + viewRectangle.height));
            int end = endPos.line - 2;
            if (lineNumber < start) {
                editor.getCaretModel().moveCaretRelatively(0, start - lineNumber, false, false, true);
            } else if (lineNumber > end) {
                editor.getCaretModel().moveCaretRelatively(0, end - lineNumber, false, false, true);
            }
        }
    }

    public static void moveCaretRelativelyAndScroll(Editor editor, int columnShift, int lineShift, boolean withSelection) {
        Rectangle viewRect = editor.getScrollingModel().getVisibleArea();
        VisualPosition pos = editor.getCaretModel().getVisualPosition();
        Point caretLocation = editor.visualPositionToXY(pos);
        int caretVShift = caretLocation.y - viewRect.y;
        editor.getCaretModel().moveCaretRelatively(columnShift, lineShift, withSelection, false, false);
        VisualPosition caretPos = editor.getCaretModel().getVisualPosition();
        Point caretLocation2 = editor.visualPositionToXY(caretPos);
        editor.getScrollingModel().scrollVertically(caretLocation2.y - caretVShift);
    }

    public static void indentLine(Project project, Editor editor, int lineNumber, int indent) {
        int oldLength;
        int newLength;
        EditorSettings editorSettings = editor.getSettings();
        Document document = editor.getDocument();
        int spacesEnd = 0;
        int lineStart = 0;
        if (lineNumber < document.getLineCount()) {
            char c;
            lineStart = document.getLineStartOffset(lineNumber);
            int lineEnd = document.getLineEndOffset(lineNumber);
            CharSequence text = document.getCharsSequence();
            for (spacesEnd = lineStart; spacesEnd <= lineEnd && spacesEnd != lineEnd && ((c = text.charAt(spacesEnd)) == '\t' || c == ' '); ++spacesEnd) {
            }
        }
        if ((newLength = (oldLength = editor.offsetToLogicalPosition((int)spacesEnd).column) + indent) < 0) {
            newLength = 0;
        }
        StringBuffer buf = new StringBuffer(newLength);
        int tabSize = editorSettings.getTabSize(project);
        int i = 0;
        while (i < newLength) {
            if (tabSize > 0 && editorSettings.isUseTabCharacter(project) && i + tabSize <= newLength) {
                buf.append('\t');
                i += tabSize;
                continue;
            }
            buf.append(' ');
            ++i;
        }
        int newCaretOffset = editor.getCaretModel().getOffset();
        if (newCaretOffset >= spacesEnd) {
            newCaretOffset += buf.length() - (spacesEnd - lineStart);
        }
        if (buf.length() > 0) {
            if (spacesEnd > lineStart) {
                document.replaceString(lineStart, spacesEnd, (CharSequence)buf.toString());
            } else {
                document.insertString(lineStart, (CharSequence)buf.toString());
            }
        } else if (spacesEnd > lineStart) {
            document.deleteString(lineStart, spacesEnd);
        }
        editor.getCaretModel().moveToOffset(newCaretOffset);
    }

    public static boolean isWordStart(CharSequence text, int offset, boolean isCamel) {
        char prev = offset > 0 ? text.charAt(offset - 1) : (char)'\u0000';
        char current = text.charAt(offset);
        char next = offset + 1 < text.length() ? text.charAt(offset + 1) : (char)'\u0000';
        boolean firstIsIdentifierPart = Character.isJavaIdentifierPart(prev);
        boolean secondIsIdentifierPart = Character.isJavaIdentifierPart(current);
        if (!firstIsIdentifierPart && secondIsIdentifierPart) {
            return true;
        }
        if (isCamel && firstIsIdentifierPart && secondIsIdentifierPart && (Character.isLowerCase(prev) && Character.isUpperCase(current) || prev == '_' && current != '_' || Character.isUpperCase(prev) && Character.isUpperCase(current) && Character.isLowerCase(next))) {
            return true;
        }
        return (Character.isWhitespace(prev) || firstIsIdentifierPart) && !Character.isWhitespace(current) && !secondIsIdentifierPart;
    }

    public static boolean isWordEnd(CharSequence text, int offset, boolean isCamel) {
        char prev = offset > 0 ? text.charAt(offset - 1) : (char)'\u0000';
        char current = text.charAt(offset);
        char next = offset + 1 < text.length() ? text.charAt(offset + 1) : (char)'\u0000';
        boolean firstIsIdentifiePart = Character.isJavaIdentifierPart(prev);
        boolean secondIsIdentifierPart = Character.isJavaIdentifierPart(current);
        if (firstIsIdentifiePart && !secondIsIdentifierPart) {
            return true;
        }
        if (isCamel && firstIsIdentifiePart && secondIsIdentifierPart && (Character.isLowerCase(prev) && Character.isUpperCase(current) || prev != '_' && current == '_' || Character.isUpperCase(prev) && Character.isUpperCase(current) && Character.isLowerCase(next))) {
            return true;
        }
        return !Character.isWhitespace(prev) && !firstIsIdentifiePart && (Character.isWhitespace(current) || secondIsIdentifierPart);
    }

    public static void moveCaretToLineStart(Editor editor, boolean isWithSelection) {
        int lineStart;
        int lineNumber;
        Document document = editor.getDocument();
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getLeadSelectionOffset();
        CaretModel caretModel = editor.getCaretModel();
        LogicalPosition blockSelectionStart = selectionModel.hasBlockSelection() ? selectionModel.getBlockStart() : caretModel.getLogicalPosition();
        int columnNumber = editor.getCaretModel().getLogicalPosition().column;
        VisualPosition visCaret = editor.getCaretModel().getVisualPosition();
        for (lineNumber = editor.getCaretModel().getLogicalPosition().line; lineNumber >= 0 && editor.logicalToVisualPosition((LogicalPosition)new LogicalPosition((int)lineNumber, (int)0)).line == visCaret.line; --lineNumber) {
        }
        ++lineNumber;
        EditorSettings editorSettings = editor.getSettings();
        if (!editorSettings.isSmartHome()) {
            LogicalPosition pos = new LogicalPosition(lineNumber, 0);
            editor.getCaretModel().moveToLogicalPosition(pos);
            EditorActionUtil.setupSelection(editor, isWithSelection, selectionStart, blockSelectionStart);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            return;
        }
        int offset = editor.getCaretModel().getOffset();
        if (lineNumber >= document.getLineCount() || offset >= document.getTextLength()) {
            int newColNumber = 0;
            if (columnNumber == 0) {
                newColNumber = EditorActionUtil.findSmartIndent(editor, offset);
            }
            LogicalPosition pos = new LogicalPosition(lineNumber, newColNumber);
            editor.getCaretModel().moveToLogicalPosition(pos);
            EditorActionUtil.setupSelection(editor, isWithSelection, selectionStart, blockSelectionStart);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            return;
        }
        int start = EditorActionUtil.findFirstNonspaceOffsetOnTheLine(document, lineNumber);
        int lineEnd = document.getLineEndOffset(lineNumber);
        if (lineNumber > 0 && lineEnd == start && columnNumber == 0) {
            int newColNumber = EditorActionUtil.findSmartIndent(editor, offset);
            LogicalPosition pos = new LogicalPosition(lineNumber, newColNumber);
            editor.getCaretModel().moveToLogicalPosition(pos);
            EditorActionUtil.setupSelection(editor, isWithSelection, selectionStart, blockSelectionStart);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            return;
        }
        int newOffset = lineStart = document.getLineStartOffset(lineNumber);
        if (start < offset || columnNumber == 0) {
            newOffset = start;
        }
        editor.getCaretModel().moveToOffset(newOffset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        EditorActionUtil.setupSelection(editor, isWithSelection, selectionStart, blockSelectionStart);
    }

    private static int findSmartIndent(Editor editor, int offset) {
        int nonSpaceLineNumber = EditorActionUtil.findFirstNonspaceLineBack(editor.getDocument(), offset);
        if (nonSpaceLineNumber >= 0) {
            int newOffset = EditorActionUtil.findFirstNonspaceOffsetOnTheLine(editor.getDocument(), nonSpaceLineNumber);
            return editor.offsetToLogicalPosition((int)newOffset).column;
        }
        return 0;
    }

    private static int findFirstNonspaceLineBack(Document document, int offset) {
        char c;
        int foundOffset;
        CharSequence text = document.getCharsSequence();
        for (foundOffset = offset - 1; foundOffset > 0 && ((c = text.charAt(foundOffset)) == ' ' || c == '\t' || c == '\r' || c == '\n'); --foundOffset) {
        }
        if (foundOffset == -1) {
            return -1;
        }
        return document.getLineNumber(foundOffset);
    }

    public static int findFirstNonspaceOffsetOnTheLine(Document document, int lineNumber) {
        int lineStart = document.getLineStartOffset(lineNumber);
        int lineEnd = document.getLineEndOffset(lineNumber);
        CharSequence text = document.getCharsSequence();
        for (int start = lineStart; start < lineEnd; ++start) {
            char c = text.charAt(start);
            if (c == ' ' || c == '\t') continue;
            return start;
        }
        return lineEnd;
    }

    public static void moveCaretToLineEnd(Editor editor, boolean isWithSelection) {
        Document document = editor.getDocument();
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getLeadSelectionOffset();
        CaretModel caretModel = editor.getCaretModel();
        LogicalPosition blockSelectionStart = selectionModel.hasBlockSelection() ? selectionModel.getBlockStart() : caretModel.getLogicalPosition();
        int lineNumber = editor.getCaretModel().getLogicalPosition().line;
        if (lineNumber >= document.getLineCount()) {
            LogicalPosition pos = new LogicalPosition(lineNumber, 0);
            editor.getCaretModel().moveToLogicalPosition(pos);
            EditorActionUtil.setupSelection(editor, isWithSelection, selectionStart, blockSelectionStart);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            return;
        }
        VisualPosition visCaret = editor.getCaretModel().getVisualPosition();
        visCaret = new VisualPosition(visCaret.line, EditorUtil.getLastVisualLineColumnNumber(editor, visCaret.line));
        LogicalPosition logLineEnd = editor.visualToLogicalPosition(visCaret);
        int offset = editor.logicalPositionToOffset(logLineEnd);
        lineNumber = logLineEnd.line;
        int newOffset = offset;
        CharSequence text = document.getCharsSequence();
        int i = newOffset - 1;
        while (i >= document.getLineStartOffset(lineNumber) && (text.charAt(i) == ' ' || text.charAt(i) == '\t')) {
            newOffset = i--;
        }
        if (newOffset == editor.getCaretModel().getOffset()) {
            newOffset = offset;
        }
        editor.getCaretModel().moveToOffset(newOffset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        EditorActionUtil.setupSelection(editor, isWithSelection, selectionStart, blockSelectionStart);
    }

    public static void moveCaretToNextWord(Editor editor, boolean isWithSelection) {
        Document document = editor.getDocument();
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getLeadSelectionOffset();
        CaretModel caretModel = editor.getCaretModel();
        LogicalPosition blockSelectionStart = selectionModel.hasBlockSelection() ? selectionModel.getBlockStart() : caretModel.getLogicalPosition();
        int offset = caretModel.getOffset();
        CharSequence text = document.getCharsSequence();
        if (offset == document.getTextLength() - 1) {
            return;
        }
        int newOffset = offset + 1;
        int lineNumber = caretModel.getLogicalPosition().line;
        if (lineNumber >= document.getLineCount()) {
            return;
        }
        int maxOffset = document.getLineEndOffset(lineNumber);
        if (newOffset > maxOffset) {
            if (lineNumber + 1 >= document.getLineCount()) {
                return;
            }
            maxOffset = document.getLineEndOffset(lineNumber + 1);
        }
        boolean camel = editor.getSettings().isCamelWords();
        while (newOffset < maxOffset && !EditorActionUtil.isWordStart(text, newOffset, camel)) {
            ++newOffset;
        }
        caretModel.moveToOffset(newOffset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        EditorActionUtil.setupSelection(editor, isWithSelection, selectionStart, blockSelectionStart);
    }

    private static void setupSelection(Editor editor, boolean isWithSelection, int selectionStart, LogicalPosition blockSelectionStart) {
        if (isWithSelection) {
            if (editor.isColumnMode()) {
                editor.getSelectionModel().setBlockSelection(blockSelectionStart, editor.getCaretModel().getLogicalPosition());
            } else {
                editor.getSelectionModel().setSelection(selectionStart, editor.getCaretModel().getOffset());
            }
        } else {
            editor.getSelectionModel().removeSelection();
        }
    }

    public static void moveCaretToPreviousWord(Editor editor, boolean isWithSelection) {
        int newOffset;
        Document document = editor.getDocument();
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getLeadSelectionOffset();
        CaretModel caretModel = editor.getCaretModel();
        LogicalPosition blockSelectionStart = selectionModel.hasBlockSelection() ? selectionModel.getBlockStart() : caretModel.getLogicalPosition();
        int offset = editor.getCaretModel().getOffset();
        if (offset == 0) {
            return;
        }
        int lineNumber = editor.getCaretModel().getLogicalPosition().line;
        CharSequence text = document.getCharsSequence();
        int minOffset = lineNumber > 0 ? document.getLineEndOffset(lineNumber - 1) : 0;
        boolean camel = editor.getSettings().isCamelWords();
        for (newOffset = offset - 1; newOffset > minOffset && !EditorActionUtil.isWordStart(text, newOffset, camel); --newOffset) {
        }
        editor.getCaretModel().moveToOffset(newOffset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        EditorActionUtil.setupSelection(editor, isWithSelection, selectionStart, blockSelectionStart);
    }

    public static void moveCaretPageUp(Editor editor, boolean isWithSelection) {
        ((EditorEx)editor).stopOptimizedScrolling();
        int lineHeight = editor.getLineHeight();
        Rectangle viewRect = editor.getScrollingModel().getVisibleArea();
        int linesIncrement = viewRect.height / lineHeight;
        editor.getScrollingModel().scrollVertically(viewRect.y - viewRect.y % lineHeight - linesIncrement * lineHeight);
        int lineShift = -linesIncrement;
        editor.getCaretModel().moveCaretRelatively(0, lineShift, isWithSelection, editor.isColumnMode(), true);
    }

    public static void moveCaretPageDown(Editor editor, boolean isWithSelection) {
        ((EditorEx)editor).stopOptimizedScrolling();
        int lineHeight = editor.getLineHeight();
        Rectangle viewRect = editor.getScrollingModel().getVisibleArea();
        int linesIncrement = viewRect.height / lineHeight;
        int allowedBottom = ((EditorEx)editor).getContentSize().height - viewRect.height;
        editor.getScrollingModel().scrollVertically(Math.min(allowedBottom, viewRect.y - viewRect.y % lineHeight + linesIncrement * lineHeight));
        editor.getCaretModel().moveCaretRelatively(0, linesIncrement, isWithSelection, editor.isColumnMode(), true);
    }

    public static void moveCaretPageTop(Editor editor, boolean isWithSelection) {
        int lineHeight = editor.getLineHeight();
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getLeadSelectionOffset();
        CaretModel caretModel = editor.getCaretModel();
        LogicalPosition blockSelectionStart = selectionModel.hasBlockSelection() ? selectionModel.getBlockStart() : caretModel.getLogicalPosition();
        Rectangle viewRect = editor.getScrollingModel().getVisibleArea();
        int lineNumber = viewRect.y / lineHeight;
        if (viewRect.y % lineHeight > 0) {
            ++lineNumber;
        }
        VisualPosition pos = new VisualPosition(lineNumber, editor.getCaretModel().getVisualPosition().column);
        editor.getCaretModel().moveToVisualPosition(pos);
        EditorActionUtil.setupSelection(editor, isWithSelection, selectionStart, blockSelectionStart);
    }

    public static void moveCaretPageBottom(Editor editor, boolean isWithSelection) {
        int lineHeight = editor.getLineHeight();
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getLeadSelectionOffset();
        CaretModel caretModel = editor.getCaretModel();
        LogicalPosition blockSelectionStart = selectionModel.hasBlockSelection() ? selectionModel.getBlockStart() : caretModel.getLogicalPosition();
        Rectangle viewRect = editor.getScrollingModel().getVisibleArea();
        int lineNumber = (viewRect.y + viewRect.height) / lineHeight - 1;
        VisualPosition pos = new VisualPosition(lineNumber, editor.getCaretModel().getVisualPosition().column);
        editor.getCaretModel().moveToVisualPosition(pos);
        EditorActionUtil.setupSelection(editor, isWithSelection, selectionStart, blockSelectionStart);
    }

    public static EditorPopupHandler createEditorPopupHandler(final String groupId) {
        return new EditorPopupHandler(){

            @Override
            public void invokePopup(EditorMouseEvent event) {
                if (!event.isConsumed() && event.getArea() == EditorMouseEventArea.EDITING_AREA) {
                    ActionGroup group = (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction(groupId);
                    ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("EditorPopup", group);
                    MouseEvent e = event.getMouseEvent();
                    Component c = e.getComponent();
                    if (c != null && c.isShowing()) {
                        popupMenu.getComponent().show(c, e.getX(), e.getY());
                    }
                    e.consume();
                }
            }
        };
    }
}

