/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;

public class DuplicateAction
extends EditorAction {
    public DuplicateAction() {
        super((EditorActionHandler)new Handler());
    }

    private static void duplicateLineOrSelectedBlockAtCaret(Editor editor) {
        Document document = editor.getDocument();
        if (editor.getSelectionModel().hasSelection()) {
            int start = editor.getSelectionModel().getSelectionStart();
            int end = editor.getSelectionModel().getSelectionEnd();
            String s = ((Object)document.getCharsSequence().subSequence(start, end)).toString();
            document.insertString(end, (CharSequence)s);
            editor.getCaretModel().moveToOffset(end + s.length());
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            editor.getSelectionModel().removeSelection();
            editor.getSelectionModel().setSelection(end, end + s.length());
        } else {
            VisualPosition caret = editor.getCaretModel().getVisualPosition();
            LogicalPosition lineStart = editor.visualToLogicalPosition(new VisualPosition(caret.line, 0));
            LogicalPosition nextLineStart = editor.visualToLogicalPosition(new VisualPosition(caret.line + 1, 0));
            int start = editor.logicalPositionToOffset(lineStart);
            int end = editor.logicalPositionToOffset(nextLineStart);
            String s = ((Object)document.getCharsSequence().subSequence(start, end)).toString();
            int lineToCheck = nextLineStart.line - 1;
            if (lineToCheck == document.getLineCount() || document.getLineSeparatorLength(lineToCheck) == 0) {
                s = "\n" + s;
            }
            document.insertString(end, (CharSequence)s);
            editor.getCaretModel().moveCaretRelatively(0, 1, false, false, true);
        }
    }

    public void update(Editor editor, Presentation presentation, DataContext dataContext) {
        super.update(editor, presentation, dataContext);
        if (editor.getSelectionModel().hasSelection()) {
            presentation.setText(EditorBundle.message((String)"action.duplicate.block", (Object[])new Object[0]), true);
        } else {
            presentation.setText(EditorBundle.message((String)"action.duplicate.line", (Object[])new Object[0]), true);
        }
    }

    private static class Handler
    extends EditorWriteActionHandler {
        private Handler() {
        }

        public void executeWriteAction(Editor editor, DataContext dataContext) {
            DuplicateAction.duplicateLineOrSelectedBlockAtCaret(editor);
        }

        public boolean isEnabled(Editor editor, DataContext dataContext) {
            return !editor.isOneLineMode() || editor.getSelectionModel().hasSelection();
        }
    }
}

