/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;

public class DeleteToWordEndAction
extends TextComponentEditorAction {
    public DeleteToWordEndAction() {
        super((EditorActionHandler)new Handler());
    }

    private static void deleteToWordEnd(Editor editor) {
        int startOffset = editor.getCaretModel().getOffset();
        int endOffset = DeleteToWordEndAction.getWordEndOffset(editor, startOffset);
        if (endOffset > startOffset) {
            Document document = editor.getDocument();
            document.deleteString(startOffset, endOffset);
        }
    }

    private static int getWordEndOffset(Editor editor, int offset) {
        Document document = editor.getDocument();
        CharSequence text = document.getCharsSequence();
        if (offset >= document.getTextLength() - 1) {
            return offset;
        }
        int newOffset = offset + 1;
        int lineNumber = editor.getCaretModel().getLogicalPosition().line;
        int maxOffset = document.getLineEndOffset(lineNumber);
        if (newOffset > maxOffset) {
            if (lineNumber + 1 >= document.getLineCount()) {
                return offset;
            }
            maxOffset = document.getLineEndOffset(lineNumber + 1);
        }
        boolean camel = editor.getSettings().isCamelWords();
        while (newOffset < maxOffset && !EditorActionUtil.isWordEnd(text, newOffset, camel) && !EditorActionUtil.isWordStart(text, newOffset, camel)) {
            ++newOffset;
        }
        return newOffset;
    }

    private static class Handler
    extends EditorWriteActionHandler {
        private Handler() {
        }

        public void executeWriteAction(Editor editor, DataContext dataContext) {
            CommandProcessor.getInstance().setCurrentCommandGroupId(EditorActionUtil.DELETE_COMMAND_GROUP);
            DeleteToWordEndAction.deleteToWordEnd(editor);
        }
    }
}

