/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.util;

import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffToolbar;
import com.intellij.openapi.diff.ex.DiffStatusBar;
import com.intellij.openapi.diff.impl.DiffToolbarComponent;
import com.intellij.openapi.diff.impl.util.FocusDiffSide;
import com.intellij.openapi.diff.impl.util.TextDiffType;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DiffPanelOutterComponent
extends JPanel
implements DataProvider {
    private final DiffStatusBar myStatusBar;
    private final DiffToolbarComponent myToolbar;
    private final DiffRequest.ToolbarAddons myDefaultActions;
    private DataProvider myDataProvider = null;
    private DeferScrollToFirstDiff myScrollState = NO_SCROLL_NEEDED;
    private ScrollingPanel myScrollingPanel = null;
    private final JPanel myBottomContainer;
    private JComponent myBottomComponent;
    private static final DeferScrollToFirstDiff NO_SCROLL_NEEDED = new DeferScrollToFirstDiff(){

        @Override
        public DeferScrollToFirstDiff scrollNow(ScrollingPanel panel, JComponent component) {
            return NO_SCROLL_NEEDED;
        }

        @Override
        public void deferScroll(DiffPanelOutterComponent outter) {
        }
    };
    private static final DeferScrollToFirstDiff SCROLL_WHEN_POSSIBLE = new DeferScrollToFirstDiff(){

        @Override
        public DeferScrollToFirstDiff scrollNow(ScrollingPanel panel, JComponent component) {
            if (!component.isDisplayable()) {
                return null;
            }
            panel.scrollEditors();
            return NO_SCROLL_NEEDED;
        }

        @Override
        public void deferScroll(final DiffPanelOutterComponent outter) {
            if (!outter.isDisplayable()) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    outter.performScroll();
                }
            });
        }
    };

    public DiffPanelOutterComponent(List<TextDiffType> diffTypes, DiffRequest.ToolbarAddons defaultActions) {
        super(new BorderLayout());
        this.myStatusBar = new DiffStatusBar(diffTypes);
        this.myBottomContainer = new JPanel(new BorderLayout());
        this.myBottomContainer.add((Component)this.myStatusBar, "South");
        this.add((Component)this.myBottomContainer, "South");
        this.myDefaultActions = defaultActions;
        this.myToolbar = new DiffToolbarComponent(this);
        this.disableToolbar(false);
    }

    public DiffToolbar resetToolbar() {
        this.myToolbar.resetToolbar(this.myDefaultActions);
        return this.myToolbar.getToolbar();
    }

    public void insertDiffComponent(JComponent component, ScrollingPanel scrollingPanel) {
        this.add((Component)component, "Center");
        this.setScrollingPanel(scrollingPanel);
    }

    public JComponent getBottomComponent() {
        return this.myBottomComponent;
    }

    public void setBottomComponent(JComponent component) {
        if (this.myBottomComponent != null) {
            this.myBottomContainer.remove(this.myBottomComponent);
        }
        this.myBottomComponent = component;
        if (this.myBottomComponent != null) {
            this.myBottomContainer.add("Center", component);
        }
    }

    public void setDataProvider(DataProvider dataProvider) {
        this.myDataProvider = dataProvider;
    }

    public void setStatusBarText(String text) {
        this.myStatusBar.setText(text);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(600, 400);
    }

    public Object getData(String dataId) {
        if (PlatformDataKeys.SOURCE_NAVIGATION_LOCKED.is(dataId)) {
            return Boolean.TRUE;
        }
        if (this.myDataProvider == null) {
            return null;
        }
        if (PlatformDataKeys.EDITOR.is(dataId)) {
            Component focusOwner;
            if (this.myBottomComponent != null && this.myBottomComponent.isAncestorOf(focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner())) {
                return null;
            }
            FocusDiffSide side = (FocusDiffSide)this.myDataProvider.getData(FocusDiffSide.DATA_KEY.getName());
            if (side != null) {
                return side.getEditor();
            }
        }
        return this.myDataProvider.getData(dataId);
    }

    public void setScrollingPanel(ScrollingPanel scrollingPanel) {
        this.myScrollingPanel = scrollingPanel;
    }

    public void requestScrollEditors() {
        this.myScrollState = SCROLL_WHEN_POSSIBLE;
        this.tryScrollNow();
    }

    private void tryScrollNow() {
        if (this.myScrollingPanel == null) {
            return;
        }
        this.myScrollState.deferScroll(this);
    }

    private void performScroll() {
        DeferScrollToFirstDiff newState = this.myScrollState.scrollNow(this.myScrollingPanel, this);
        if (newState != null) {
            this.myScrollState = newState;
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.tryScrollNow();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.tryScrollNow();
    }

    @Override
    protected void validateTree() {
        super.validateTree();
        this.tryScrollNow();
    }

    public void cancelScrollEditors() {
        this.myScrollState = NO_SCROLL_NEEDED;
    }

    public void disableToolbar(boolean disable) {
        if (disable && this.isToolbarEnabled()) {
            this.remove(this.myToolbar);
        } else if (this.myToolbar.getParent() == null) {
            this.add((Component)this.myToolbar, "North");
        }
    }

    public boolean isToolbarEnabled() {
        return this.myToolbar.getParent() != null;
    }

    public void registerToolbarActions() {
        this.myToolbar.getToolbar().registerKeyboardActions(this);
    }

    public void setColorScheme(EditorColorsScheme scheme) {
        this.myStatusBar.setColorScheme(scheme);
    }

    public static interface ScrollingPanel {
        public void scrollEditors();
    }

    private static interface DeferScrollToFirstDiff {
        public DeferScrollToFirstDiff scrollNow(ScrollingPanel var1, JComponent var2);

        public void deferScroll(DiffPanelOutterComponent var1);
    }
}

