/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.mergeTool;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.ActionButtonPresentation;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffViewer;
import com.intellij.openapi.diff.MergeRequest;
import com.intellij.openapi.diff.SimpleContent;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeCounter;
import com.intellij.openapi.diff.impl.incrementalMerge.ui.MergePanel2;
import com.intellij.openapi.diff.impl.mergeTool.MergeVersion;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class MergeRequestImpl
extends MergeRequest {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.mergeTool.MergeRequestImpl");
    private final DiffContent[] myDiffContents = new DiffContent[3];
    private String myWindowTitle = null;
    private String[] myVersionTitles = null;
    private int myResult = 1;
    private String myHelpId;
    @Nullable
    private final ActionButtonPresentation myActionButtonPresentation;

    public MergeRequestImpl(String left, MergeVersion base, String right, Project project, @Nullable ActionButtonPresentation actionButtonPresentation) {
        super(project);
        this.myActionButtonPresentation = actionButtonPresentation;
        this.myDiffContents[0] = new SimpleContent(left);
        this.myDiffContents[1] = new MergeContent(base);
        this.myDiffContents[2] = new SimpleContent(right);
    }

    public MergeRequestImpl(String left, String base, String right, Project project, @Nullable ActionButtonPresentation actionButtonPresentation) {
        super(project);
        this.myActionButtonPresentation = actionButtonPresentation;
        this.myDiffContents[0] = new SimpleContent(left);
        this.myDiffContents[1] = new SimpleContent(base);
        this.myDiffContents[2] = new SimpleContent(right);
    }

    public DiffContent[] getContents() {
        return this.myDiffContents;
    }

    public String[] getContentTitles() {
        return this.myVersionTitles;
    }

    public void setVersionTitles(String[] versionTitles) {
        this.myVersionTitles = versionTitles;
    }

    public String getWindowTitle() {
        return this.myWindowTitle;
    }

    public void setWindowTitle(String windowTitle) {
        this.myWindowTitle = windowTitle;
    }

    public void setResult(int result) {
        if (result == 0) {
            this.applyChanges();
        }
        this.myResult = result;
    }

    public void applyChanges() {
        MergeContent mergeContent = this.getMergeContent();
        if (mergeContent != null) {
            mergeContent.applyChanges();
        }
    }

    public int getResult() {
        return this.myResult;
    }

    @Nullable
    private MergeContent getMergeContent() {
        if (this.myDiffContents[1] instanceof MergeContent) {
            return (MergeContent)this.myDiffContents[1];
        }
        return null;
    }

    @Nullable
    public DiffContent getResultContent() {
        return this.getMergeContent();
    }

    public void restoreOriginalContent() {
        final MergeContent mergeContent = this.getMergeContent();
        if (mergeContent == null) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(this.getProject(), new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        FileDocumentManager.getInstance().getDocument(mergeContent.getFile()).setText((CharSequence)mergeContent.getOriginalText());
                    }
                });
            }
        }, "", null);
    }

    public void setActions(final DialogBuilder builder, MergePanel2 mergePanel) {
        if (builder.getOkAction() == null && this.myActionButtonPresentation != null) {
            builder.addOkAction();
        }
        if (builder.getCancelAction() == null) {
            builder.addCancelAction();
        }
        if (this.myActionButtonPresentation != null) {
            int mnemonic;
            builder.getOkAction().setText(this.myActionButtonPresentation.getName());
            builder.setOkActionEnabled(this.myActionButtonPresentation.isEnabled());
            Action action = ((DialogBuilder.ActionDescriptor)builder.getOkAction()).getAction(builder.getDialogWrapper());
            String actionName = this.myActionButtonPresentation.getName();
            int index = actionName.indexOf(38);
            if (index >= 0 && index < actionName.length() - 1) {
                mnemonic = actionName.charAt(index + 1);
                actionName = actionName.substring(0, index) + actionName.substring(index + 1);
            } else {
                mnemonic = 0;
            }
            action.putValue("Name", actionName);
            if (mnemonic > 0) {
                action.putValue("MnemonicKey", mnemonic);
            }
            builder.setOkOperation(new Runnable(){

                @Override
                public void run() {
                    DataContext dataContext = DataManager.getInstance().getDataContext(builder.getCenterPanel());
                    MergeRequestImpl.this.myActionButtonPresentation.run((DiffViewer)PlatformDataKeys.DIFF_VIEWER.getData(dataContext));
                    if (MergeRequestImpl.this.myActionButtonPresentation.closeDialog()) {
                        builder.getDialogWrapper().close(0);
                    }
                }
            });
        }
        if (this.getMergeContent() != null) {
            builder.setCancelOperation(new Runnable(){

                @Override
                public void run() {
                    if (Messages.showYesNoDialog((Project)MergeRequestImpl.this.getProject(), (String)DiffBundle.message((String)"merge.dialog.exit.without.applying.changes.confirmation.message", (Object[])new Object[0]), (String)DiffBundle.message((String)"cancel.visual.merge.dialog.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) {
                        builder.getDialogWrapper().close(1);
                    }
                }
            });
            new AllResolvedListener(mergePanel, builder.getDialogWrapper());
        }
    }

    public String getHelpId() {
        return this.myHelpId;
    }

    public void setHelpId(@Nullable @NonNls String helpId) {
        this.myHelpId = helpId;
    }

    private class AllResolvedListener
    implements ChangeCounter.Listener,
    Runnable {
        private final MergePanel2 myMergePanel;
        private final DialogWrapper myDialogWrapper;
        private boolean myWasInvoked = false;

        private AllResolvedListener(MergePanel2 mergePanel, DialogWrapper dialogWrapper) {
            this.myMergePanel = mergePanel;
            this.myDialogWrapper = dialogWrapper;
            ChangeCounter changeCounter = ChangeCounter.getOrCreate(this.myMergePanel.getMergeList());
            changeCounter.removeListener(this);
            changeCounter.addListener(this);
        }

        @Override
        public void run() {
            if (!MergeRequestImpl.this.myActionButtonPresentation.closeDialog()) {
                return;
            }
            if (this.myWasInvoked) {
                return;
            }
            if (!this.getWholePanel().isDisplayable()) {
                return;
            }
            this.myWasInvoked = true;
            ChangeCounter.getOrCreate(this.myMergePanel.getMergeList()).removeListener(this);
            int doApply = Messages.showDialog((Project)MergeRequestImpl.this.getProject(), (String)DiffBundle.message((String)"merge.all.changes.have.processed.save.and.finish.confirmation.text", (Object[])new Object[0]), (String)DiffBundle.message((String)"all.changes.processed.dialog.title", (Object[])new Object[0]), (String[])new String[]{DiffBundle.message((String)"merge.save.and.finish.button", (Object[])new Object[0]), DiffBundle.message((String)"merge.continue.button", (Object[])new Object[0])}, (int)0, (Icon)Messages.getQuestionIcon());
            if (doApply != 0) {
                return;
            }
            this.myDialogWrapper.close(0);
        }

        private JComponent getWholePanel() {
            return this.myMergePanel.getComponent();
        }

        @Override
        public void onCountersChanged(ChangeCounter counter) {
            if (this.myWasInvoked) {
                return;
            }
            if (counter.getChangeCounter() != 0 || counter.getConflictCounter() != 0) {
                return;
            }
            ApplicationManager.getApplication().invokeLater((Runnable)this);
        }
    }

    private class MergeContent
    extends DiffContent {
        private final MergeVersion myTarget;
        private final Document myWorkingDocument;

        private MergeContent(MergeVersion target) {
            this.myTarget = target;
            this.myWorkingDocument = this.myTarget.createWorkingDocument(MergeRequestImpl.this.getProject());
            LOG.assertTrue(this.myWorkingDocument.isWritable());
        }

        public void applyChanges() {
            this.myTarget.applyText(this.myWorkingDocument.getText(), MergeRequestImpl.this.getProject());
        }

        public Document getDocument() {
            return this.myWorkingDocument;
        }

        public OpenFileDescriptor getOpenFileDescriptor(int offset) {
            VirtualFile file = this.getFile();
            if (file == null) {
                return null;
            }
            return new OpenFileDescriptor(MergeRequestImpl.this.getProject(), file, offset);
        }

        public VirtualFile getFile() {
            return this.myTarget.getFile();
        }

        public FileType getContentType() {
            return this.myTarget.getContentType();
        }

        public byte[] getBytes() throws IOException {
            return this.myTarget.getBytes();
        }

        public String getOriginalText() {
            return this.myTarget.getTextBeforeMerge();
        }
    }
}

