/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.fragments;

import com.intellij.openapi.diff.DiffColors;
import com.intellij.openapi.diff.actions.MergeOperations;
import com.intellij.openapi.diff.impl.fragments.Fragment;
import com.intellij.openapi.diff.impl.fragments.FragmentHighlighter;
import com.intellij.openapi.diff.impl.fragments.InlineFragment;
import com.intellij.openapi.diff.impl.fragments.LineFragment;
import com.intellij.openapi.diff.impl.highlighting.DiffMarkup;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import java.util.Iterator;

public class FragmentHighlighterImpl
implements FragmentHighlighter {
    private final DiffMarkup myAppender1;
    private final DiffMarkup myAppender2;
    private final boolean myIsLast;

    public FragmentHighlighterImpl(DiffMarkup appender1, DiffMarkup appender2, boolean isLast) {
        this.myAppender1 = appender1;
        this.myAppender2 = appender2;
        this.myIsLast = isLast;
    }

    public void highlightInline(InlineFragment fragment) {
        this.myAppender1.highlightText((Fragment)fragment, true);
        this.myAppender2.highlightText((Fragment)fragment, true);
    }

    public void highlightLine(LineFragment fragment) {
        this.addModifyActions(fragment, this.myAppender1, this.myAppender2);
        Iterator iterator = fragment.getChildrenIterator();
        if (iterator == null) {
            this.myAppender1.highlightText((Fragment)fragment, false);
            this.myAppender2.highlightText((Fragment)fragment, false);
        } else {
            while (iterator.hasNext()) {
                Fragment childFragment = (Fragment)iterator.next();
                childFragment.highlight((FragmentHighlighter)this);
            }
        }
        if (fragment.isEqual() && this.myIsLast) {
            return;
        }
        this.addBottomLine((Fragment)fragment, this.myAppender1, fragment.getEndLine1());
        this.addBottomLine((Fragment)fragment, this.myAppender2, fragment.getEndLine2());
    }

    private void addModifyActions(LineFragment fragment, DiffMarkup wrapper, DiffMarkup otherWrapper) {
        if (fragment.isEqual()) {
            return;
        }
        if (fragment.isHasLineChildren()) {
            return;
        }
        TextRange range = fragment.getRange(wrapper.getSide());
        TextRange otherRange = fragment.getRange(wrapper.getSide().otherSide());
        Document document = wrapper.getDocument();
        Document otherDocument = otherWrapper.getDocument();
        wrapper.addAction(MergeOperations.mostSensible(document, otherDocument, range, otherRange), range.getStartOffset());
        otherWrapper.addAction(MergeOperations.mostSensible(otherDocument, document, otherRange, range), otherRange.getStartOffset());
    }

    private void addBottomLine(Fragment fragment, DiffMarkup appender, int endLine) {
        if (endLine <= 0) {
            return;
        }
        TextRange range = fragment.getRange(appender.getSide());
        appender.addLineMarker(endLine - 1, this.getRangeType(fragment, range));
    }

    private TextAttributesKey getRangeType(Fragment fragment, TextRange range) {
        if (range.getLength() == 0) {
            return DiffColors.DIFF_DELETED;
        }
        return fragment.getType() == null ? null : DiffColors.DIFF_MODIFIED;
    }
}

