/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.external;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffTool;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.Icon;

class BinaryDiffTool
implements DiffTool {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.external.BinaryDiffTool");
    public static final DiffTool INSTANCE = new BinaryDiffTool();

    BinaryDiffTool() {
    }

    public void show(DiffRequest data) {
        DiffContent[] contents = data.getContents();
        try {
            BinaryDiffTool.compareBinaryFiles(contents[0].getBytes(), contents[1].getBytes());
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void compareBinaryFiles(byte[] currentContent, byte[] upToDateContent) {
        if (Arrays.equals(currentContent, upToDateContent)) {
            Messages.showMessageDialog((String)DiffBundle.message((String)"binary.files.are.identical.message", (Object[])new Object[0]), (String)DiffBundle.message((String)"files.are.identical.dialog.title", (Object[])new Object[0]), (Icon)Messages.getInformationIcon());
        } else {
            Messages.showMessageDialog((String)DiffBundle.message((String)"binary.files.are.different.message", (Object[])new Object[0]), (String)DiffBundle.message((String)"files.are.different.dialog.title", (Object[])new Object[0]), (Icon)Messages.getInformationIcon());
        }
    }

    public boolean canShow(DiffRequest data) {
        DiffContent[] contents = data.getContents();
        if (contents.length != 2) {
            return false;
        }
        for (int i = 0; i < contents.length; ++i) {
            DiffContent content = contents[i];
            VirtualFile file = content.getFile();
            if (file == null || !file.isDirectory()) continue;
            return false;
        }
        return true;
    }
}

