/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.ex;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.DiffPanelImpl;
import com.intellij.openapi.diff.impl.DiffSideView;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapperDialog;
import java.awt.Frame;
import java.awt.Window;

public class DiffPanelOptions {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.ex.DiffPanelOptions");
    private final DiffPanelImpl myDiffPanel;
    private boolean myRequestFocusOnNewContent = true;
    private ShowSourcePolicy myShowSourcePolicy = ShowSourcePolicy.DEFAULT;

    public DiffPanelOptions(DiffPanelImpl diffPanel) {
        this.myDiffPanel = diffPanel;
    }

    public void onNewContent(DiffSideView currentSide) {
        if (this.myRequestFocusOnNewContent) {
            currentSide.getFocusableComponent().requestFocus();
        }
    }

    public void setRequestFocusOnNewContent(boolean requestFocusOnNewContent) {
        this.myRequestFocusOnNewContent = requestFocusOnNewContent;
    }

    public void setShowSourcePolicy(ShowSourcePolicy showSourcePolicy) {
        if (showSourcePolicy == null) {
            LOG.error("");
            return;
        }
        this.myShowSourcePolicy = showSourcePolicy;
    }

    public void showSource(OpenFileDescriptor descriptor) {
        this.myShowSourcePolicy.showSource(descriptor, this.myDiffPanel);
    }

    public static interface ShowSourcePolicy {
        public static final ShowSourcePolicy DONT_SHOW = new ShowSourcePolicy(){

            @Override
            public void showSource(OpenFileDescriptor descriptor, DiffPanelImpl diffPanel) {
            }
        };
        public static final ShowSourcePolicy OPEN_EDITOR = new ShowSourcePolicy(){

            @Override
            public void showSource(OpenFileDescriptor descriptor, DiffPanelImpl diffPanel) {
                FileEditorManager.getInstance((Project)diffPanel.getProject()).openTextEditor(descriptor, true);
            }
        };
        public static final ShowSourcePolicy OPEN_EDITOR_AND_CLOSE_DIFF = new ShowSourcePolicy(){

            @Override
            public void showSource(OpenFileDescriptor descriptor, DiffPanelImpl diffPanel) {
                OPEN_EDITOR.showSource(descriptor, diffPanel);
                if (diffPanel.getOwnerWindow() == null) {
                    return;
                }
                diffPanel.dispose();
                if (!this.dialogWrapperClose(diffPanel.getOwnerWindow())) {
                    diffPanel.getOwnerWindow().setVisible(false);
                    diffPanel.getOwnerWindow().dispose();
                }
            }

            private boolean dialogWrapperClose(Window window) {
                if (!(window instanceof DialogWrapperDialog)) {
                    return false;
                }
                DialogWrapperDialog dlg = (DialogWrapperDialog)window;
                dlg.getDialogWrapper().close(0);
                return true;
            }
        };
        public static final ShowSourcePolicy DEFAULT = new ShowSourcePolicy(){

            @Override
            public void showSource(OpenFileDescriptor descriptor, DiffPanelImpl diffPanel) {
                Window window = diffPanel.getOwnerWindow();
                if (window == null) {
                    return;
                }
                if (window instanceof Frame) {
                    OPEN_EDITOR.showSource(descriptor, diffPanel);
                } else {
                    OPEN_EDITOR_AND_CLOSE_DIFF.showSource(descriptor, diffPanel);
                }
            }
        };

        public void showSource(OpenFileDescriptor var1, DiffPanelImpl var2);
    }
}

