/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diff.ActionButtonPresentation;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffRequestFactory;
import com.intellij.openapi.diff.MergeRequest;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;

public class MergeFilesAction
extends AnAction
implements DumbAware {
    public void update(AnActionEvent e) {
        DataContext context = e.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(context);
        if (project == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        VirtualFile[] files = (VirtualFile[])PlatformDataKeys.VIRTUAL_FILE_ARRAY.getData(context);
        if (files == null || files.length != 3) {
            e.getPresentation().setEnabled(false);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext context = e.getDataContext();
        VirtualFile[] files = (VirtualFile[])PlatformDataKeys.VIRTUAL_FILE_ARRAY.getData(context);
        if (files == null || files.length != 3) {
            return;
        }
        DiffRequestFactory diffRequestFactory = DiffRequestFactory.getInstance();
        VirtualFile file = files[1];
        try {
            String originalText = this.createValidContent(VfsUtil.loadText((VirtualFile)file));
            String leftText = VfsUtil.loadText((VirtualFile)files[0]);
            String rightText = VfsUtil.loadText((VirtualFile)files[2]);
            Project project = (Project)PlatformDataKeys.PROJECT.getData(context);
            MergeRequest diffData = diffRequestFactory.createMergeRequest(leftText, rightText, originalText, file, project, ActionButtonPresentation.createApplyButton());
            diffData.setVersionTitles(new String[]{files[0].getPresentableUrl(), files[1].getPresentableUrl(), files[2].getPresentableUrl()});
            diffData.setWindowTitle(DiffBundle.message((String)"merge.files.dialog.title", (Object[])new Object[0]));
            diffData.setHelpId("cvs.merge");
            DiffManager.getInstance().getDiffTool().show((DiffRequest)diffData);
        }
        catch (IOException e1) {
            Messages.showErrorDialog((String)DiffBundle.message((String)"merge.dialog.cannot.load.file.error.message", (Object[])new Object[]{e1.getLocalizedMessage()}), (String)DiffBundle.message((String)"merge.files.dialog.title", (Object[])new Object[0]));
        }
    }

    private String createValidContent(String str) {
        String[] strings = LineTokenizer.tokenize((char[])str.toCharArray(), (boolean)false, (boolean)false);
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < strings.length; ++i) {
            String string = strings[i];
            if (i != 0) {
                result.append('\n');
            }
            result.append(string);
        }
        return result.toString();
    }
}

