/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.CommonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandAdapter;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.impl.CommandMerger;
import com.intellij.openapi.command.impl.CurrentEditorProvider;
import com.intellij.openapi.command.impl.DocumentUndoProvider;
import com.intellij.openapi.command.impl.DummyProject;
import com.intellij.openapi.command.impl.EditorAndState;
import com.intellij.openapi.command.impl.FocusBasedCurrentEditorProvider;
import com.intellij.openapi.command.impl.NonUndoableAction;
import com.intellij.openapi.command.impl.UndoProvider;
import com.intellij.openapi.command.impl.UndoRedoStacksHolder;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.FragmentContent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UndoManagerImpl
extends UndoManager
implements ProjectComponent,
ApplicationComponent,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.command.impl.UndoManagerImpl");
    public static final int GLOBAL_UNDO_LIMIT = 10;
    public static final int LOCAL_UNDO_LIMIT = 100;
    private static final int COMMANDS_TO_KEEP_LIVE_QUEUES = 100;
    private static final int COMMAND_TO_RUN_COMPACT = 20;
    private static final int FREE_QUEUES_LIMIT = 30;
    private final ProjectEx myProject;
    private int myCommandLevel = 0;
    private static final int NONE = 0;
    private static final int UNDO = 1;
    private static final int REDO = 2;
    private int myCurrentOperationState = 0;
    private final CommandMerger myMerger;
    private final UndoRedoStacksHolder myUndoStacksHolder = new UndoRedoStacksHolder(true);
    private final UndoRedoStacksHolder myRedoStacksHolder = new UndoRedoStacksHolder(false);
    private CommandMerger myCurrentMerger;
    private CurrentEditorProvider myCurrentEditorProvider;
    private Project myCurrentActionProject = DummyProject.getInstance();
    private int myCommandTimestamp = 1;
    private final CommandProcessor myCommandProcessor;
    private final StartupManager myStartupManager;
    private UndoProvider[] myUndoProviders;

    public UndoManagerImpl(Application application, CommandProcessor commandProcessor) {
        this(application, null, commandProcessor, null);
    }

    public UndoManagerImpl(Application application, ProjectEx project, CommandProcessor commandProcessor, StartupManager startupManager) {
        this.myProject = project;
        this.myCommandProcessor = commandProcessor;
        this.myStartupManager = startupManager;
        this.init(application);
        this.myMerger = new CommandMerger(this);
    }

    private void init(Application application) {
        if (this.myProject == null || application.isUnitTestMode() && !this.myProject.isDefault()) {
            this.initialize();
        }
    }

    @NotNull
    public String getComponentName() {
        if ("UndoManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/command/impl/UndoManagerImpl.getComponentName must not return null");
        }
        return "UndoManager";
    }

    public Project getProject() {
        return this.myProject;
    }

    public void initComponent() {
    }

    private void initialize() {
        if (this.myProject == null) {
            this.runStartupActivity();
        } else {
            this.myStartupManager.registerStartupActivity(new Runnable(){

                @Override
                public void run() {
                    UndoManagerImpl.this.runStartupActivity();
                }
            });
        }
    }

    private void runStartupActivity() {
        this.myCurrentEditorProvider = new FocusBasedCurrentEditorProvider();
        CommandAdapter commandListener = new CommandAdapter(){
            private boolean myFakeCommandStarted = false;

            public void commandStarted(CommandEvent event) {
                UndoManagerImpl.this.onCommandStarted(event.getProject(), event.getUndoConfirmationPolicy());
            }

            public void commandFinished(CommandEvent event) {
                UndoManagerImpl.this.onCommandFinished(event.getProject(), event.getCommandName(), event.getCommandGroupId());
            }

            public void undoTransparentActionStarted() {
                if (!UndoManagerImpl.this.isInsideCommand()) {
                    this.myFakeCommandStarted = true;
                    UndoManagerImpl.this.onCommandStarted(UndoManagerImpl.this.myProject, UndoConfirmationPolicy.DEFAULT);
                }
            }

            public void undoTransparentActionFinished() {
                if (this.myFakeCommandStarted) {
                    this.myFakeCommandStarted = false;
                    UndoManagerImpl.this.onCommandFinished(UndoManagerImpl.this.myProject, "", null);
                }
            }
        };
        this.myCommandProcessor.addCommandListener((CommandListener)commandListener, (Disposable)this);
        Disposer.register((Disposable)this, (Disposable)new DocumentUndoProvider(this.myProject));
        for (UndoProvider undoProvider : this.myUndoProviders = this.myProject == null ? (UndoProvider[])Extensions.getExtensions(UndoProvider.EP_NAME) : (UndoProvider[])Extensions.getExtensions(UndoProvider.PROJECT_EP_NAME, (AreaInstance)this.myProject)) {
            if (!(undoProvider instanceof Disposable)) continue;
            Disposer.register((Disposable)this, (Disposable)((Disposable)undoProvider));
        }
    }

    private void onCommandFinished(Project project, String commandName, Object commandGroupId) {
        this.commandFinished(commandName, commandGroupId);
        if (this.myCommandLevel == 0) {
            for (UndoProvider undoProvider : this.myUndoProviders) {
                undoProvider.commandFinished(project);
            }
            this.myCurrentActionProject = DummyProject.getInstance();
        }
        LOG.assertTrue(this.myCommandLevel == 0 || !(this.myCurrentActionProject instanceof DummyProject));
    }

    private void onCommandStarted(Project project, UndoConfirmationPolicy undoConfirmationPolicy) {
        if (this.myCommandLevel == 0) {
            for (UndoProvider undoProvider : this.myUndoProviders) {
                undoProvider.commandStarted(project);
            }
            this.myCurrentActionProject = project;
        }
        this.commandStarted(undoConfirmationPolicy);
        LOG.assertTrue(this.myCommandLevel == 0 || !(this.myCurrentActionProject instanceof DummyProject));
    }

    public void dropHistoryInTests() {
        this.flushMergers();
        LOG.assertTrue(this.myCommandLevel == 0);
        this.myUndoStacksHolder.clearAllStacksInTests();
        this.myRedoStacksHolder.clearAllStacksInTests();
    }

    public void markCurrentCommandAsGlobal() {
        this.myCurrentMerger.markAsGlobal();
    }

    public void invalidateAllGlobalActions() {
        this.flushMergers();
        this.myUndoStacksHolder.invalidateAllGlobalActions();
        this.myRedoStacksHolder.invalidateAllGlobalActions();
    }

    private void flushMergers() {
        CommandProcessor.getInstance().executeCommand((Project)this.myProject, EmptyRunnable.getInstance(), CommonBundle.message((String)"drop.undo.history.command.name", (Object[])new Object[0]), null);
    }

    public void dispose() {
    }

    public void disposeComponent() {
    }

    public void setCurrentEditorProvider(CurrentEditorProvider p) {
        this.myCurrentEditorProvider = p;
    }

    public CurrentEditorProvider getCurrentEditorProvider() {
        return this.myCurrentEditorProvider;
    }

    public void projectOpened() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.initialize();
        }
    }

    public void projectClosed() {
    }

    public void flushCurrentCommandMerger() {
        this.myMerger.flushCurrentCommand();
    }

    private void clearUndoRedoQueue(DocumentReference docRef) {
        this.myMerger.flushCurrentCommand();
        this.disposeCurrentMerger();
        this.myUndoStacksHolder.clearStacks(false, Collections.singleton(docRef));
        this.myRedoStacksHolder.clearStacks(false, Collections.singleton(docRef));
    }

    public void clearUndoRedoQueueInTests(VirtualFile file) {
        this.clearUndoRedoQueue(DocumentReferenceManager.getInstance().create(file));
    }

    protected void compact() {
        if (this.myCurrentOperationState == 0 && this.myCommandTimestamp % 20 == 0) {
            this.doCompact();
        }
    }

    private void doCompact() {
        DocumentReference each;
        Collection<DocumentReference> refs = this.collectReferencesWithoutMergers();
        HashSet openDocs = new HashSet();
        for (DocumentReference each2 : refs) {
            VirtualFile file = each2.getFile();
            if (file == null) {
                Document document = each2.getDocument();
                if (document == null || EditorFactory.getInstance().getEditors(document, (Project)this.myProject).length <= 0) continue;
                openDocs.add(each2);
                continue;
            }
            if (this.myProject == null || !FileEditorManager.getInstance((Project)this.myProject).isFileOpen(file)) continue;
            openDocs.add(each2);
        }
        refs.removeAll((Collection<?>)openDocs);
        if (refs.size() <= 30) {
            return;
        }
        DocumentReference[] backSorted = refs.toArray(new DocumentReference[refs.size()]);
        Arrays.sort(backSorted, new Comparator<DocumentReference>(){

            @Override
            public int compare(DocumentReference a, DocumentReference b) {
                return UndoManagerImpl.this.getLastCommandTimestamp(a) - UndoManagerImpl.this.getLastCommandTimestamp(b);
            }
        });
        for (int i = 0; i < backSorted.length - 30 && this.getLastCommandTimestamp(each = backSorted[i]) + 100 <= this.myCommandTimestamp; ++i) {
            this.clearUndoRedoQueue(each);
        }
    }

    private Collection<DocumentReference> collectReferencesWithoutMergers() {
        THashSet result = new THashSet();
        this.myUndoStacksHolder.collectAllAffectedDocuments((Collection<DocumentReference>)result);
        this.myRedoStacksHolder.collectAllAffectedDocuments((Collection<DocumentReference>)result);
        return result;
    }

    private int getLastCommandTimestamp(DocumentReference ref) {
        return Math.max(this.myUndoStacksHolder.getLastCommandTimestamp(ref), this.myRedoStacksHolder.getLastCommandTimestamp(ref));
    }

    public void undoableActionPerformed(UndoableAction action) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myCurrentOperationState != 0) {
            return;
        }
        if (this.myCommandLevel == 0) {
            LOG.assertTrue(action instanceof NonUndoableAction, (Object)"Undoable actions allowed inside commands only (see com.intellij.openapi.command.CommandProcessor.executeCommand())");
            this.commandStarted(UndoConfirmationPolicy.DEFAULT);
            this.myCurrentMerger.addAction(action, false);
            this.commandFinished("", null);
            return;
        }
        this.myCurrentMerger.addAction(action, CommandProcessor.getInstance().isUndoTransparentActionInProgress());
    }

    public void nonundoableActionPerformed(DocumentReference ref, boolean isGlobal) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.undoableActionPerformed(new NonUndoableAction(ref, isGlobal));
    }

    public boolean isUndoInProgress() {
        return this.myCurrentOperationState == 1;
    }

    public boolean isRedoInProgress() {
        return this.myCurrentOperationState == 2;
    }

    public void undo(@Nullable FileEditor editor) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        LOG.assertTrue(this.isUndoAvailable(editor));
        this.myCurrentOperationState = 1;
        this.undoOrRedo(editor);
    }

    public void redo(@Nullable FileEditor editor) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        LOG.assertTrue(this.isRedoAvailable(editor));
        this.myCurrentOperationState = 2;
        this.undoOrRedo(editor);
    }

    private void undoOrRedo(final FileEditor editor) {
        final RuntimeException[] exception = new RuntimeException[1];
        Runnable executeUndoOrRedoAction = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (UndoManagerImpl.this.isUndoInProgress()) {
                        UndoManagerImpl.this.myMerger.undoOrRedo(editor, true);
                    } else {
                        UndoManagerImpl.this.myMerger.undoOrRedo(editor, false);
                    }
                }
                catch (RuntimeException ex) {
                    exception[0] = ex;
                }
                finally {
                    UndoManagerImpl.this.myCurrentOperationState = 0;
                }
            }
        };
        CommandProcessor.getInstance().executeCommand((Project)this.myProject, executeUndoOrRedoAction, this.isUndoInProgress() ? CommonBundle.message((String)"undo.command.name", (Object[])new Object[0]) : CommonBundle.message((String)"redo.command.name", (Object[])new Object[0]), null, this.myMerger.getUndoConfirmationPolicy());
        if (exception[0] != null) {
            throw exception[0];
        }
    }

    public boolean isUndoAvailable(@Nullable FileEditor editor) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Collection<DocumentReference> refs = UndoManagerImpl.getDocRefs(editor);
        if (refs == null) {
            return false;
        }
        return this.isUndoOrRedoAvailable(refs, true);
    }

    public boolean isRedoAvailable(@Nullable FileEditor editor) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Collection<DocumentReference> refs = UndoManagerImpl.getDocRefs(editor);
        if (refs == null) {
            return false;
        }
        return this.isUndoOrRedoAvailable(refs, false);
    }

    private static Collection<DocumentReference> getDocRefs(FileEditor editor) {
        if (editor instanceof TextEditor && ((TextEditor)editor).getEditor().isViewer()) {
            return null;
        }
        return UndoManagerImpl.getDocumentReferences(editor);
    }

    public boolean isUndoOrRedoAvailable(DocumentReference ref) {
        Set<DocumentReference> refs = Collections.singleton(ref);
        return this.isUndoOrRedoAvailable(refs, true) || this.isUndoOrRedoAvailable(refs, false);
    }

    private boolean isUndoOrRedoAvailable(Collection<DocumentReference> refs, boolean isUndo) {
        if (isUndo && this.myMerger.isUndoAvailable(refs)) {
            return true;
        }
        UndoRedoStacksHolder stackHolder = this.getStackHolder(isUndo);
        return stackHolder.hasActions(refs);
    }

    private UndoRedoStacksHolder getStackHolder(boolean isUndo) {
        return isUndo ? this.myUndoStacksHolder : this.myRedoStacksHolder;
    }

    @Nullable
    public String formatAvailableUndoAction(FileEditor editor) {
        return this.doFormatAvailableUndoRedoAction(editor, true);
    }

    @Nullable
    public String formatAvailableRedoAction(FileEditor editor) {
        return this.doFormatAvailableUndoRedoAction(editor, false);
    }

    private String doFormatAvailableUndoRedoAction(FileEditor editor, boolean isUndo) {
        Collection<DocumentReference> refs = UndoManagerImpl.getDocRefs(editor);
        if (refs == null) {
            return null;
        }
        if (isUndo && this.myMerger.isUndoAvailable(refs)) {
            return this.myMerger.getCommandName();
        }
        return this.getStackHolder(isUndo).getLastAction(refs).getCommandName();
    }

    static Set<DocumentReference> getDocumentReferences(FileEditor editor) {
        Document[] documents;
        THashSet result = new THashSet();
        Document[] documentArray = documents = editor == null ? null : TextEditorProvider.getDocuments(editor);
        if (documents != null) {
            for (Document each : documents) {
                Document original = UndoManagerImpl.getOriginal(each);
                VirtualFile f = FileDocumentManager.getInstance().getFile(each);
                if (f != null && !f.isValid()) continue;
                result.add(DocumentReferenceManager.getInstance().create(original));
            }
        }
        return result;
    }

    public boolean isActive() {
        return Comparing.equal((Object)this.myProject, (Object)this.myCurrentActionProject);
    }

    private void commandStarted(UndoConfirmationPolicy undoConfirmationPolicy) {
        if (this.myCommandLevel == 0) {
            this.myCurrentMerger = new CommandMerger(this);
        }
        LOG.assertTrue(this.myCurrentMerger != null, (Object)String.valueOf(this.myCommandLevel));
        this.myCurrentMerger.setBeforeState(this.getCurrentState());
        this.myCurrentMerger.mergeUndoConfirmationPolicy(undoConfirmationPolicy);
        ++this.myCommandLevel;
    }

    private EditorAndState getCurrentState() {
        FileEditor editor = this.myCurrentEditorProvider.getCurrentEditor();
        if (editor == null) {
            return null;
        }
        return new EditorAndState(editor, editor.getState(FileEditorStateLevel.UNDO));
    }

    private void commandFinished(String commandName, Object groupId) {
        if (this.myCommandLevel == 0) {
            return;
        }
        --this.myCommandLevel;
        if (this.myCommandLevel > 0) {
            return;
        }
        this.myCurrentMerger.setAfterState(this.getCurrentState());
        this.myMerger.commandFinished(commandName, groupId, this.myCurrentMerger);
        this.disposeCurrentMerger();
    }

    private void disposeCurrentMerger() {
        LOG.assertTrue(this.myCommandLevel == 0);
        if (this.myCurrentMerger != null) {
            this.myCurrentMerger = null;
        }
    }

    public UndoRedoStacksHolder getUndoStacksHolder() {
        return this.myUndoStacksHolder;
    }

    public UndoRedoStacksHolder getRedoStacksHolder() {
        return this.myRedoStacksHolder;
    }

    public boolean isInsideCommand() {
        return this.myCommandLevel > 0;
    }

    public int nextCommandTimestamp() {
        return ++this.myCommandTimestamp;
    }

    static Document getOriginal(Document document) {
        Document result = (Document)document.getUserData(FragmentContent.ORIGINAL_DOCUMENT);
        return result == null ? document : result;
    }

    public static boolean isCopy(Document d) {
        return d.getUserData(FragmentContent.ORIGINAL_DOCUMENT) != null;
    }
}

