/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.impl.EditorChangeAction;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ExternalChangeAction;

class DocumentUndoProvider
implements Disposable {
    private final Project myProject;

    DocumentUndoProvider(Project project) {
        MyEditorDocumentListener documentListener = new MyEditorDocumentListener();
        this.myProject = project;
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)documentListener, (Disposable)this);
    }

    public void dispose() {
    }

    private UndoManagerImpl getUndoManager() {
        return (UndoManagerImpl)(this.myProject == null ? UndoManager.getGlobalInstance() : UndoManager.getInstance((Project)this.myProject));
    }

    private class MyEditorDocumentListener
    extends DocumentAdapter {
        private MyEditorDocumentListener() {
        }

        public void documentChanged(DocumentEvent e) {
            Document document = e.getDocument();
            if (UndoManagerImpl.isCopy(document)) {
                return;
            }
            if (this.allEditorsAreViewersFor(document)) {
                return;
            }
            if (!this.shouldRecordActions(document)) {
                return;
            }
            UndoManagerImpl undoManager = DocumentUndoProvider.this.getUndoManager();
            if (!undoManager.isActive() || !this.isUndoable(document)) {
                this.registerNonUndoableAction(document);
                return;
            }
            this.registerUndoableAction(e);
        }

        private boolean shouldRecordActions(Document document) {
            if (document.getUserData(UndoManager.DONT_RECORD_UNDO) == Boolean.TRUE) {
                return false;
            }
            VirtualFile vFile = FileDocumentManager.getInstance().getFile(document);
            return vFile == null || vFile.getUserData(UndoManager.DONT_RECORD_UNDO) != Boolean.TRUE;
        }

        private boolean allEditorsAreViewersFor(Document document) {
            Editor[] editors = EditorFactory.getInstance().getEditors(document);
            if (editors.length == 0) {
                return false;
            }
            for (Editor editor : editors) {
                if (editor.isViewer()) continue;
                return false;
            }
            return true;
        }

        private void registerUndoableAction(DocumentEvent e) {
            DocumentUndoProvider.this.getUndoManager().undoableActionPerformed(new EditorChangeAction((DocumentEx)e.getDocument(), e.getOffset(), e.getOldFragment(), e.getNewFragment(), e.getOldTimeStamp()));
        }

        private void registerNonUndoableAction(Document document) {
            DocumentReference ref = DocumentReferenceManager.getInstance().create(document);
            DocumentUndoProvider.this.getUndoManager().nonundoableActionPerformed(ref, false);
        }

        private boolean isUndoable(Document document) {
            boolean isFromRefresh;
            boolean bl = isFromRefresh = ApplicationManager.getApplication().getCurrentWriteAction(ExternalChangeAction.class) != null;
            if (!isFromRefresh) {
                return true;
            }
            return DocumentUndoProvider.this.getUndoManager().isUndoOrRedoAvailable(DocumentReferenceManager.getInstance().create(document));
        }
    }
}

