/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.ex;

import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.URLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class DecodeDefaultsUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.application.ex.DecodeDefaultsUtil");
    private static final Map<String, URL> myResourceCache = Collections.synchronizedMap(new HashMap());
    @NonNls
    private static final String XML_EXTENSION = ".xml";

    public static URL getDefaults(Object requestor, String componentResourcePath) {
        if (myResourceCache.containsKey(componentResourcePath)) {
            return myResourceCache.get(componentResourcePath);
        }
        URL url = DecodeDefaultsUtil.getDefaultsImpl(requestor, componentResourcePath);
        myResourceCache.put(componentResourcePath, url);
        return url;
    }

    private static URL getDefaultsImpl(Object requestor, String componentResourcePath) {
        boolean isPathAbsoulte = StringUtil.startsWithChar((CharSequence)componentResourcePath, (char)'/');
        if (isPathAbsoulte) {
            return requestor.getClass().getResource(componentResourcePath + XML_EXTENSION);
        }
        return DecodeDefaultsUtil.getResourceByRelativePath(requestor, componentResourcePath, XML_EXTENSION);
    }

    @Nullable
    public static InputStream getDefaultsInputStream(Object requestor, String componentResourcePath) {
        try {
            URL defaults = DecodeDefaultsUtil.getDefaults(requestor, componentResourcePath);
            return defaults != null ? URLUtil.openStream((URL)defaults) : null;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static URL getResourceByRelativePath(Object requestor, String componentResourcePath, String resourceExtension) {
        String appName = ApplicationManagerEx.getApplicationEx().getName();
        URL result = requestor.getClass().getResource("/" + appName + "/" + componentResourcePath + resourceExtension);
        if (result == null) {
            result = requestor.getClass().getResource("/" + componentResourcePath + resourceExtension);
        }
        return result;
    }
}

