/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.NotificationModelListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.PairFunction;
import com.intellij.util.concurrency.ReentrantLock2;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotificationModel {
    private final Map<Notification, Pair<Project, Boolean>> myNotifications = new LinkedHashMap<Notification, Pair<Project, Boolean>>();
    private final List<NotificationModelListener> myListeners = ContainerUtil.createEmptyCOWList();
    private final ReentrantLock2 myLock = new ReentrantLock2();

    public void addListener(@NotNull NotificationModelListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/NotificationModel.addListener must not be null");
        }
        this.myListeners.add(listener);
    }

    public void removeListener(@NotNull NotificationModelListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/NotificationModel.removeListener must not be null");
        }
        this.myListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@NotNull Notification notification, @Nullable Project project) {
        if (notification == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/NotificationModel.add must not be null");
        }
        try {
            this.myLock.acquire();
            this.myNotifications.put(notification, (Pair<Project, Boolean>)Pair.create((Object)project, (Object)false));
        }
        finally {
            this.myLock.release();
        }
        for (NotificationModelListener listener : this.myListeners) {
            listener.notificationsAdded(notification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markRead() {
        ArrayList<Notification> changed = null;
        try {
            this.myLock.acquire();
            if (this.myNotifications.isEmpty()) {
                return;
            }
            changed = new ArrayList<Notification>();
            for (Map.Entry<Notification, Pair<Project, Boolean>> entry : this.myNotifications.entrySet()) {
                entry.setValue((Pair<Project, Boolean>)new Pair(entry.getValue().first, (Object)true));
                changed.add(entry.getKey());
            }
        }
        finally {
            this.myLock.release();
        }
        if (!changed.isEmpty()) {
            Notification[] read = changed.toArray(new Notification[changed.size()]);
            for (NotificationModelListener listener : this.myListeners) {
                listener.notificationsRead(read);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Notification remove(@NotNull Notification notification) {
        if (notification == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/NotificationModel.remove must not be null");
        }
        try {
            this.myLock.acquire();
            Pair<Project, Boolean> pair = this.myNotifications.remove(notification);
            if (pair == null) {
                Notification notification2 = notification;
                return notification2;
            }
        }
        finally {
            this.myLock.release();
        }
        for (NotificationModelListener listener : this.myListeners) {
            listener.notificationsRemoved(notification);
        }
        return notification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Notification ... notifications) {
        if (notifications == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/NotificationModel.remove must not be null");
        }
        ArrayList<Notification> tbr = new ArrayList<Notification>();
        try {
            this.myLock.acquire();
            for (Notification notification : notifications) {
                Pair<Project, Boolean> pair = this.myNotifications.remove(notification);
                if (pair == null) continue;
                tbr.add(notification);
            }
        }
        finally {
            this.myLock.release();
        }
        if (!tbr.isEmpty()) {
            Notification[] removed = tbr.toArray(new Notification[tbr.size()]);
            for (NotificationModelListener listener : this.myListeners) {
                listener.notificationsRemoved(removed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Notification get(int index, @NotNull PairFunction<Notification, Project, Boolean> filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/notification/impl/NotificationModel.get must not be null");
        }
        try {
            this.myLock.acquire();
            List<Notification> filtered = this.filterNotifications(filter);
            if (index >= 0 && filtered.size() > index) {
                Notification notification = filtered.get(index);
                return notification;
            }
        }
        finally {
            this.myLock.release();
        }
        return null;
    }

    private List<Notification> filterNotifications(@NotNull PairFunction<Notification, Project, Boolean> filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/NotificationModel.filterNotifications must not be null");
        }
        if (this.myNotifications.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<Notification> result = new LinkedList<Notification>();
        for (Map.Entry<Notification, Pair<Project, Boolean>> entry : this.myNotifications.entrySet()) {
            if (!((Boolean)filter.fun((Object)entry.getKey(), entry.getValue().first)).booleanValue()) continue;
            result.addFirst(entry.getKey());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount(@NotNull PairFunction<Notification, Project, Boolean> filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/NotificationModel.getCount must not be null");
        }
        try {
            this.myLock.acquire();
            int n = this.filterNotifications(filter).size();
            return n;
        }
        finally {
            this.myLock.release();
        }
    }

    public boolean isEmpty(@NotNull PairFunction<Notification, Project, Boolean> filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/NotificationModel.isEmpty must not be null");
        }
        return this.getCount(filter) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Notification getFirst(@NotNull PairFunction<Notification, Project, Boolean> filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/NotificationModel.getFirst must not be null");
        }
        try {
            this.myLock.acquire();
            List<Notification> result = this.filterNotifications(filter);
            Notification notification = result.isEmpty() ? null : result.get(0);
            return notification;
        }
        finally {
            this.myLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(@NotNull PairFunction<Notification, Project, Boolean> filter) {
        List<Notification> result;
        if (filter == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/NotificationModel.clear must not be null");
        }
        try {
            this.myLock.acquire();
            result = this.filterNotifications(filter);
            this.myNotifications.keySet().removeAll(result);
        }
        finally {
            this.myLock.release();
        }
        if (!result.isEmpty()) {
            Notification[] removed = result.toArray(new Notification[result.size()]);
            for (NotificationModelListener listener : this.myListeners) {
                listener.notificationsRemoved(removed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Notification> getByType(@Nullable NotificationType type, @NotNull PairFunction<Notification, Project, Boolean> filter) {
        List<Notification> filtered;
        if (filter == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/notification/impl/NotificationModel.getByType must not be null");
        }
        if (type == null) {
            try {
                this.myLock.acquire();
                List<Notification> list = Collections.unmodifiableList(this.filterNotifications(filter));
                return list;
            }
            finally {
                this.myLock.release();
            }
        }
        try {
            this.myLock.acquire();
            filtered = this.filterNotifications(filter);
        }
        finally {
            this.myLock.release();
        }
        ArrayList<Notification> result = new ArrayList<Notification>();
        for (Notification notification : filtered) {
            if (type != notification.getType()) continue;
            result.add(notification);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasRead(Notification notification) {
        try {
            this.myLock.acquire();
            Pair<Project, Boolean> pair = this.myNotifications.get(notification);
            boolean bl = pair != null && (Boolean)pair.second != false;
            return bl;
        }
        finally {
            this.myLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasUnread(PairFunction<Notification, Project, Boolean> filter) {
        try {
            this.myLock.acquire();
            boolean bl = this.getUnreadCount(filter) > 0;
            return bl;
        }
        finally {
            this.myLock.release();
        }
    }

    private int getUnreadCount(final PairFunction<Notification, Project, Boolean> filter) {
        return this.filterNotifications(new PairFunction<Notification, Project, Boolean>(){

            public Boolean fun(Notification notification, Project project) {
                return (Boolean)filter.fun((Object)notification, (Object)project) != false && !NotificationModel.this.wasRead(notification);
            }
        }).size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRead(PairFunction<Notification, Project, Boolean> filter) {
        try {
            this.myLock.acquire();
            boolean bl = this.getUnreadCount(filter) < this.myNotifications.size();
            return bl;
        }
        finally {
            this.myLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public NotificationType getMaximumType(PairFunction<Notification, Project, Boolean> filter) {
        List<Notification> notifications;
        try {
            this.myLock.acquire();
            notifications = this.filterNotifications(filter);
        }
        finally {
            this.myLock.release();
        }
        NotificationType result = null;
        for (Notification notification : notifications) {
            if (NotificationType.ERROR == notification.getType()) {
                return NotificationType.ERROR;
            }
            if (NotificationType.WARNING == notification.getType()) {
                result = NotificationType.WARNING;
                continue;
            }
            if (result != null || NotificationType.INFORMATION != notification.getType()) continue;
            result = NotificationType.INFORMATION;
        }
        return result;
    }
}

