/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.mock.MockVirtualFileSystem;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileOperationsHandler;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.io.fs.IFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockLocalFileSystem
extends LocalFileSystem {
    private final MockVirtualFileSystem myDelegate = new MockVirtualFileSystem();

    @Nullable
    public VirtualFile findFileByIoFile(File file) {
        return this.myDelegate.findFileByPath(FileUtil.toSystemIndependentName((String)file.getPath()));
    }

    @Nullable
    public VirtualFile findFileByIoFile(IFile file) {
        return this.myDelegate.findFileByPath(FileUtil.toSystemIndependentName((String)file.getPath()));
    }

    @Nullable
    public VirtualFile refreshAndFindFileByIoFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockLocalFileSystem.refreshAndFindFileByIoFile must not be null");
        }
        return this.findFileByIoFile(file);
    }

    @Nullable
    public VirtualFile refreshAndFindFileByIoFile(IFile ioFile) {
        return this.findFileByIoFile(ioFile);
    }

    public void refreshIoFiles(Iterable<File> files) {
    }

    public void refreshFiles(Iterable<VirtualFile> files) {
    }

    public byte[] physicalContentsToByteArray(VirtualFile virtualFile) throws IOException {
        throw new UnsupportedOperationException("'physicalContentsToByteArray' not implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    public long physicalLength(VirtualFile virtualFile) throws IOException {
        throw new UnsupportedOperationException("'physicalLength' not implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    @Nullable
    public LocalFileSystem.WatchRequest addRootToWatch(@NotNull String rootPath, boolean toWatchRecursively) {
        if (rootPath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockLocalFileSystem.addRootToWatch must not be null");
        }
        throw new UnsupportedOperationException("'addRootToWatch' not implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    @NotNull
    public Set<LocalFileSystem.WatchRequest> addRootsToWatch(@NotNull Collection<String> rootPaths, boolean toWatchRecursively) {
        if (rootPaths == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockLocalFileSystem.addRootsToWatch must not be null");
        }
        throw new UnsupportedOperationException("'addRootsToWatch' not implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    public void removeWatchedRoots(@NotNull Collection<LocalFileSystem.WatchRequest> rootsToWatch) {
        if (rootsToWatch == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockLocalFileSystem.removeWatchedRoots must not be null");
        }
    }

    public void removeWatchedRoot(@NotNull LocalFileSystem.WatchRequest watchRequest) {
        if (watchRequest == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockLocalFileSystem.removeWatchedRoot must not be null");
        }
    }

    public void registerAuxiliaryFileOperationsHandler(LocalFileOperationsHandler handler) {
    }

    public void unregisterAuxiliaryFileOperationsHandler(LocalFileOperationsHandler handler) {
    }

    public boolean processCachedFilesInSubtree(VirtualFile file, Processor<VirtualFile> processor) {
        throw new UnsupportedOperationException("'processCachedFilesInSubtree' not implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    @NotNull
    public String getProtocol() {
        if ("file" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/mock/MockLocalFileSystem.getProtocol must not return null");
        }
        return "file";
    }

    @Nullable
    public VirtualFile findFileByPath(@NotNull @NonNls String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockLocalFileSystem.findFileByPath must not be null");
        }
        return this.myDelegate.findFileByPath(path);
    }

    public void refresh(boolean asynchronous) {
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockLocalFileSystem.refreshAndFindFileByPath must not be null");
        }
        return this.findFileByPath(path);
    }

    public void deleteFile(Object requestor, @NotNull VirtualFile vFile) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/mock/MockLocalFileSystem.deleteFile must not be null");
        }
    }

    public void moveFile(Object requestor, @NotNull VirtualFile vFile, @NotNull VirtualFile newParent) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/mock/MockLocalFileSystem.moveFile must not be null");
        }
        if (newParent == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/mock/MockLocalFileSystem.moveFile must not be null");
        }
    }

    public void renameFile(Object requestor, @NotNull VirtualFile vFile, @NotNull String newName) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/mock/MockLocalFileSystem.renameFile must not be null");
        }
        if (newName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/mock/MockLocalFileSystem.renameFile must not be null");
        }
    }

    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile vDir, @NotNull String fileName) throws IOException {
        if (vDir == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/mock/MockLocalFileSystem.createChildFile must not be null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/mock/MockLocalFileSystem.createChildFile must not be null");
        }
        return this.myDelegate.createChildFile(requestor, vDir, fileName);
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile vDir, @NotNull String dirName) throws IOException {
        if (vDir == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/mock/MockLocalFileSystem.createChildDirectory must not be null");
        }
        if (dirName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/mock/MockLocalFileSystem.createChildDirectory must not be null");
        }
        VirtualFile virtualFile = this.myDelegate.createChildDirectory(requestor, vDir, dirName);
        if (virtualFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/mock/MockLocalFileSystem.createChildDirectory must not return null");
        }
        return virtualFile;
    }

    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile virtualFile, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/mock/MockLocalFileSystem.copyFile must not be null");
        }
        if (newParent == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/mock/MockLocalFileSystem.copyFile must not be null");
        }
        if (copyName == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/mock/MockLocalFileSystem.copyFile must not be null");
        }
        return this.myDelegate.copyFile(requestor, virtualFile, newParent, copyName);
    }

    public String extractRootPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockLocalFileSystem.extractRootPath must not be null");
        }
        return path;
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public boolean exists(VirtualFile fileOrDirectory) {
        return false;
    }

    @NotNull
    public InputStream getInputStream(VirtualFile file) throws IOException {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public byte[] contentsToByteArray(VirtualFile file) throws IOException {
        if (ArrayUtil.EMPTY_BYTE_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/mock/MockLocalFileSystem.contentsToByteArray must not return null");
        }
        return ArrayUtil.EMPTY_BYTE_ARRAY;
    }

    public long getLength(VirtualFile file) {
        return 0L;
    }

    @NotNull
    public OutputStream getOutputStream(VirtualFile file, Object requestor, long modStamp, long timeStamp) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long getTimeStamp(VirtualFile file) {
        return 0L;
    }

    public boolean isDirectory(VirtualFile file) {
        return false;
    }

    public boolean isWritable(VirtualFile file) {
        return false;
    }

    public String[] list(VirtualFile file) {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public VirtualFile[] listFiles(VirtualFile file) {
        return new VirtualFile[0];
    }

    public void setTimeStamp(VirtualFile file, long modstamp) throws IOException {
    }

    public void setWritable(VirtualFile file, boolean writableFlag) throws IOException {
    }

    public int getRank() {
        return 1;
    }
}

