/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xml.XmlBundle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class EditLocationDialog
extends DialogWrapper {
    private JTextField myTfUrl;
    private JTextField myTfPath;
    private FixedSizeButton myBtnBrowseLocalPath;
    private final Project myProject;
    private final boolean myShowPath;
    private final String myTitle;
    private final String myName;
    private final String myLocation;
    private boolean myTfShared = true;

    public EditLocationDialog(Project project, boolean showPath) {
        super(project, true);
        this.myProject = project;
        this.myShowPath = showPath;
        this.myTitle = XmlBundle.message((String)"dialog.title.external.resource", (Object[])new Object[0]);
        this.myName = XmlBundle.message((String)"label.edit.external.resource.uri", (Object[])new Object[0]);
        this.myLocation = XmlBundle.message((String)"label.edit.external.resource.path", (Object[])new Object[0]);
        this.init();
    }

    public EditLocationDialog(Project project, boolean showPath, String title, String name, String location) {
        super(project, true);
        this.myProject = project;
        this.myShowPath = showPath;
        this.myTitle = title;
        this.myName = name;
        this.myLocation = location;
        this.init();
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(this.myName), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 3, 5), 0, 0));
        panel.add((Component)this.myTfUrl, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.myTfUrl.setPreferredSize(new Dimension(350, this.myTfUrl.getPreferredSize().height));
        if (this.myShowPath) {
            panel.add((Component)new JLabel(this.myLocation), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 3, 5), 0, 0));
            panel.add((Component)this.myTfPath, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 10, 0), 0, 0));
            panel.add((Component)this.myBtnBrowseLocalPath, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 10, 5), 0, 0));
            ComponentWithBrowseButton.MyDoClickAction.addTo((FixedSizeButton)this.myBtnBrowseLocalPath, (JComponent)this.myTfPath);
            this.myBtnBrowseLocalPath.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ignored) {
                    FileChooserDescriptor descriptor = EditLocationDialog.this.getChooserDescriptor();
                    VirtualFile[] files = FileChooser.chooseFiles((Project)EditLocationDialog.this.myProject, (FileChooserDescriptor)descriptor);
                    if (files.length != 0) {
                        EditLocationDialog.this.myTfPath.setText(files[0].getPath().replace('/', File.separatorChar));
                    }
                }
            });
        }
        return panel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTfUrl;
    }

    public NameLocationPair getPair() {
        String path = this.myTfPath.getText().trim();
        String url = this.myTfUrl.getText().trim();
        return new NameLocationPair(url, path, this.myTfShared);
    }

    protected FileChooserDescriptor getChooserDescriptor() {
        return new FileChooserDescriptor(true, false, false, false, true, false);
    }

    protected void init() {
        this.setTitle(this.myTitle);
        this.myTfUrl = new JTextField();
        this.myTfPath = new JTextField();
        this.myBtnBrowseLocalPath = new FixedSizeButton((JComponent)this.myTfPath);
        super.init();
    }

    public void init(NameLocationPair origin) {
        this.myTfUrl.setText(origin.myName);
        this.myTfPath.setText(origin.myLocation);
        this.myTfShared = origin.myShared;
    }

    public static class NameLocationPair
    implements Comparable {
        String myName;
        String myLocation;
        boolean myShared;

        public NameLocationPair(String name, String location, boolean shared) {
            this.myName = name;
            this.myLocation = location;
            this.myShared = shared;
        }

        public int compareTo(Object o) {
            return this.myName.compareTo(((NameLocationPair)o).myName);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof NameLocationPair)) {
                return false;
            }
            return this.compareTo(obj) == 0;
        }

        public int hashCode() {
            return this.myName.hashCode();
        }

        public String getName() {
            return this.myName;
        }

        public String getLocation() {
            return this.myLocation;
        }
    }
}

