/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.codeInsight.completion.CompletionLookupArranger;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import java.util.Arrays;
import javax.swing.ListModel;

public class DumpLookupElementWeights
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        Editor editor = (Editor)e.getData(PlatformDataKeys.EDITOR);
        DumpLookupElementWeights.dumpLookupElementWeights((LookupImpl)LookupManager.getActiveLookup(editor));
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Editor editor = (Editor)e.getData(PlatformDataKeys.EDITOR);
        presentation.setEnabled(editor != null && LookupManager.getActiveLookup(editor) != null);
    }

    public static void dumpLookupElementWeights(LookupImpl lookup) {
        ListModel model = lookup.getList().getModel();
        int count = lookup.getPreferredItemsCount();
        for (int i = 0; i < model.getSize(); ++i) {
            LookupElement item = (LookupElement)model.getElementAt(i);
            System.out.println(item.getLookupString() + Arrays.toString((Object[])item.getUserData(CompletionLookupArranger.WEIGHT)));
            if (i != count - 1) continue;
            System.out.println("------------");
        }
    }
}

