/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.NamePathComponent;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ProjectOutputPathsStep
extends ModuleWizardStep {
    private static final Icon NEW_PROJECT_ICON = IconLoader.getIcon((String)"/newprojectwizard.png");
    private final JPanel myPanel;
    private final NamePathComponent myNamePathComponent;
    private final WizardContext myWizardContext;

    public ProjectOutputPathsStep(WizardContext wizardContext) {
        this.myWizardContext = wizardContext;
        this.myNamePathComponent = new NamePathComponent("", IdeBundle.message((String)"label.select.compiler.output.path", (Object[])new Object[0]), IdeBundle.message((String)"title.select.compiler.output.path", (Object[])new Object[0]), "", false);
        this.myNamePathComponent.setNameComponentVisible(false);
        this.myPanel = new JPanel(new GridBagLayout());
        this.myPanel.setBorder(BorderFactory.createEtchedBorder());
        this.myPanel.add((Component)this.myNamePathComponent, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 6, 0, 6), 0, 0));
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void updateDataModel() {
        this.myWizardContext.setCompilerOutputDirectory(this.myNamePathComponent.getPath());
    }

    public void updateStep() {
        String projectFilePath;
        if (!this.myNamePathComponent.isPathChangedByUser() && (projectFilePath = this.myWizardContext.getProjectFileDirectory()) != null) {
            String path = this.myWizardContext.getCompilerOutputDirectory();
            if (path == null) {
                path = StringUtil.endsWithChar((CharSequence)projectFilePath, (char)'/') ? projectFilePath + "classes" : projectFilePath + "/classes";
            }
            this.myNamePathComponent.setPath(path.replace('/', File.separatorChar));
            this.myNamePathComponent.getPathComponent().selectAll();
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNamePathComponent.getPathComponent();
    }

    public boolean isStepVisible() {
        return this.myWizardContext.getProjectFileDirectory() != null;
    }

    public Icon getIcon() {
        return NEW_PROJECT_ICON;
    }

    public String getHelpId() {
        return null;
    }

    public String getCompileOutputPath() {
        return this.myNamePathComponent.getPath();
    }
}

