/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.ide.util.projectWizard.JavaModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.NamePathComponent;
import com.intellij.ide.util.projectWizard.ProjectWizardUtil;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.FieldPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NonNls;

public class NameLocationStep
extends ModuleWizardStep {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.projectWizard.NameLocationStep");
    private final JPanel myPanel;
    private final NamePathComponent myNamePathComponent;
    private final WizardContext myWizardContext;
    private final JavaModuleBuilder myBuilder;
    private final ModulesProvider myModulesProvider;
    private final Icon myIcon;
    private final String myHelpId;
    private boolean myModuleFileDirectoryChangedByUser = false;
    private final JTextField myTfModuleFilePath;
    private boolean myFirstTimeInitializationDone = false;

    public NameLocationStep(WizardContext wizardContext, JavaModuleBuilder builder, ModulesProvider modulesProvider, Icon icon, @NonNls String helpId) {
        this.myWizardContext = wizardContext;
        this.myBuilder = builder;
        this.myModulesProvider = modulesProvider;
        this.myIcon = icon;
        this.myHelpId = helpId;
        this.myPanel = new JPanel(new GridBagLayout());
        this.myPanel.setBorder(BorderFactory.createEtchedBorder());
        String text = IdeBundle.message((String)"prompt.please.specify.module.name.and.content.root", (Object[])new Object[0]);
        JLabel textLabel = new JLabel(text);
        textLabel.setUI((LabelUI)new MultiLineLabelUI());
        this.myPanel.add((Component)textLabel, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 18, 0, new Insets(8, 10, 8, 10), 0, 0));
        this.myNamePathComponent = new NamePathComponent(IdeBundle.message((String)"label.module.name", (Object[])new Object[0]), IdeBundle.message((String)"label.module.content.root", (Object[])new Object[0]), 'M', 'r', IdeBundle.message((String)"title.select.module.content.root", (Object[])new Object[0]), "");
        this.myPanel.add((Component)this.myNamePathComponent, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 18, 2, new Insets(8, 10, 0, 10), 0, 0));
        JLabel label = new JLabel(IdeBundle.message((String)"label.module.file.will.be.saved.in", (Object[])new Object[0]));
        this.myPanel.add((Component)label, new GridBagConstraints(0, -1, 2, 1, 1.0, 1.0, 16, 2, new Insets(30, 10, 0, 10), 0, 0));
        this.myTfModuleFilePath = new JTextField();
        this.myTfModuleFilePath.setEditable(false);
        Insets borderInsets = this.myTfModuleFilePath.getBorder().getBorderInsets(this.myTfModuleFilePath);
        this.myTfModuleFilePath.setBorder(BorderFactory.createEmptyBorder(borderInsets.top, borderInsets.left, borderInsets.bottom, borderInsets.right));
        FieldPanel fieldPanel = NameLocationStep.createFieldPanel((JTextField)this.myTfModuleFilePath, null, null);
        this.myPanel.add((Component)fieldPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 10, 10, 0), 0, 0));
        JButton browseButton = new JButton(IdeBundle.message((String)"button.change.directory", (Object[])new Object[0]));
        browseButton.addActionListener((ActionListener)((Object)new BrowseModuleFileDirectoryListener(this.myTfModuleFilePath)));
        this.myPanel.add((Component)browseButton, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 10, 10), 0, 0));
        DocumentAdapter documentListener = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                NameLocationStep.this.updateModuleFilePathField();
            }
        };
        this.myNamePathComponent.getNameComponent().getDocument().addDocumentListener((DocumentListener)documentListener);
        this.myNamePathComponent.getPathComponent().getDocument().addDocumentListener((DocumentListener)documentListener);
        this.myNamePathComponent.getPathComponent().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(DocumentEvent event) {
                NameLocationStep.this.myWizardContext.requestWizardButtonsUpdate();
            }
        });
    }

    private String suggestModuleName(ModuleType moduleType) {
        return "untitled";
    }

    public void updateStep() {
        super.updateStep();
        if (!this.myFirstTimeInitializationDone) {
            if (this.myWizardContext.isCreatingNewProject()) {
                this.setSyncEnabled(false);
            } else {
                String projectFileDirectory;
                VirtualFile baseDir = this.myWizardContext.getProject().getBaseDir();
                String string = projectFileDirectory = baseDir != null ? VfsUtil.virtualToIoFile((VirtualFile)baseDir).getPath() : null;
                if (projectFileDirectory != null) {
                    String name = ProjectWizardUtil.findNonExistingFileName(projectFileDirectory, this.suggestModuleName(this.myBuilder.getModuleType()), "");
                    this.setModuleName(name);
                    this.setContentEntryPath(projectFileDirectory + File.separatorChar + name);
                }
            }
        }
        if (this.myWizardContext.isCreatingNewProject()) {
            if (!this.isPathChangedByUser()) {
                this.setContentEntryPath(this.myWizardContext.getProjectFileDirectory().replace('/', File.separatorChar));
            }
            if (!this.isNameChangedByUser()) {
                this.setModuleName(this.myWizardContext.getProjectName());
            }
        }
        if (!this.myFirstTimeInitializationDone) {
            this.myNamePathComponent.getNameComponent().selectAll();
        }
        this.myFirstTimeInitializationDone = true;
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public String getModuleName() {
        return this.myNamePathComponent.getNameValue();
    }

    public void setModuleName(String name) {
        this.myNamePathComponent.setNameValue(name);
    }

    public String getContentEntryPath() {
        String path = this.myNamePathComponent.getPath();
        return path.length() == 0 ? null : path;
    }

    public void setContentEntryPath(String path) {
        this.myNamePathComponent.setPath(path);
    }

    public String getModuleFilePath() {
        return this.getModuleFileDirectory() + "/" + this.myNamePathComponent.getNameValue() + ".iml";
    }

    public boolean isSyncEnabled() {
        return this.myNamePathComponent.isSyncEnabled();
    }

    public void setSyncEnabled(boolean isSyncEnabled) {
        this.myNamePathComponent.setSyncEnabled(isSyncEnabled);
    }

    public String getModuleFileDirectory() {
        return this.myTfModuleFilePath.getText().trim().replace(File.separatorChar, '/');
    }

    public boolean validate() {
        String moduleName = this.getModuleName();
        if (moduleName.length() == 0) {
            Messages.showErrorDialog((Component)this.myNamePathComponent.getNameComponent(), (String)IdeBundle.message((String)"prompt.please.specify.module.name", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.module.name.not.specified", (Object[])new Object[0]));
            return false;
        }
        if (this.isAlreadyExists(moduleName)) {
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.module.with.name.already.exists", (Object[])new Object[]{moduleName}), (String)IdeBundle.message((String)"title.module.already.exists", (Object[])new Object[0]));
            return false;
        }
        String moduleLocation = this.getModuleFileDirectory();
        if (moduleLocation.length() == 0) {
            Messages.showErrorDialog((Component)this.myNamePathComponent.getPathComponent(), (String)IdeBundle.message((String)"error.please.specify.module.file.location", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.module.file.location.not.specified", (Object[])new Object[0]));
            return false;
        }
        String contentEntryPath = this.getContentEntryPath();
        if (contentEntryPath != null) {
            Module[] modules;
            for (Module module : modules = this.myModulesProvider.getModules()) {
                ModuleRootModel rootModel = this.myModulesProvider.getRootModel(module);
                LOG.assertTrue(rootModel != null);
                VirtualFile[] moduleContentRoots = rootModel.getContentRoots();
                String moduleContentRoot = contentEntryPath.replace(File.separatorChar, '/');
                for (VirtualFile root : moduleContentRoots) {
                    if (!moduleContentRoot.equals(root.getPath())) continue;
                    Messages.showErrorDialog((Component)this.myNamePathComponent.getPathComponent(), (String)IdeBundle.message((String)"error.content.root.already.defined.for.module", (Object[])new Object[]{contentEntryPath, module.getName()}), (String)IdeBundle.message((String)"title.module.content.root.already.exists", (Object[])new Object[0]));
                    return false;
                }
            }
            if (!ProjectWizardUtil.createDirectoryIfNotExists(IdeBundle.message((String)"directory.module.content.root", (Object[])new Object[0]), contentEntryPath, this.myNamePathComponent.isPathChangedByUser())) {
                return false;
            }
        }
        String moduleFileDirectory = this.getModuleFileDirectory();
        return ProjectWizardUtil.createDirectoryIfNotExists(IdeBundle.message((String)"directory.module.file", (Object[])new Object[0]), moduleFileDirectory, this.myModuleFileDirectoryChangedByUser);
    }

    public void updateDataModel() {
        this.myBuilder.setName(this.getModuleName());
        this.myBuilder.setModuleFilePath(this.getModuleFilePath());
        this.myBuilder.setContentEntryPath(this.getContentEntryPath());
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNamePathComponent.getNameComponent();
    }

    private boolean isAlreadyExists(String moduleName) {
        Module[] modules;
        for (Module module : modules = this.myModulesProvider.getModules()) {
            if (!moduleName.equals(module.getName())) continue;
            return true;
        }
        return false;
    }

    private void updateModuleFilePathField() {
        if (!this.myModuleFileDirectoryChangedByUser) {
            String dir = this.myNamePathComponent.getPath().replace('/', File.separatorChar);
            this.myTfModuleFilePath.setText(dir);
        }
    }

    public boolean isNameChangedByUser() {
        return this.myNamePathComponent.isNameChangedByUser();
    }

    public boolean isPathChangedByUser() {
        return this.myNamePathComponent.isPathChangedByUser();
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public String getHelpId() {
        return this.myHelpId;
    }

    private class BrowseModuleFileDirectoryListener
    extends BrowseFilesListener {
        private BrowseModuleFileDirectoryListener(JTextField textField) {
            super(textField, IdeBundle.message((String)"title.select.module.file.location", (Object[])new Object[0]), IdeBundle.message((String)"description.select.module.file.location", (Object[])new Object[0]), SINGLE_DIRECTORY_DESCRIPTOR);
        }

        public void actionPerformed(ActionEvent e) {
            String pathBefore = NameLocationStep.this.myTfModuleFilePath.getText().trim();
            super.actionPerformed(e);
            String path = NameLocationStep.this.myTfModuleFilePath.getText().trim();
            if (!path.equals(pathBefore)) {
                NameLocationStep.this.myModuleFileDirectoryChangedByUser = true;
            }
        }
    }
}

