/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.newProjectWizard.StepSequence;
import com.intellij.ide.util.newProjectWizard.modes.WizardMode;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.NamePathComponent;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.ProjectWizardUtil;
import com.intellij.ide.util.projectWizard.SourcePathsBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.projectImport.ProjectFormatPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ProjectNameStep
extends ModuleWizardStep {
    private static final Icon NEW_PROJECT_ICON = IconLoader.getIcon((String)"/newprojectwizard.png");
    private final JPanel myPanel;
    protected final JPanel myAdditionalContentPanel;
    protected NamePathComponent myNamePathComponent;
    protected final WizardContext myWizardContext;
    protected final StepSequence mySequence;
    protected final WizardMode myMode;
    private ProjectFormatPanel myFormatPanel = new ProjectFormatPanel();

    public ProjectNameStep(WizardContext wizardContext, StepSequence sequence, WizardMode mode) {
        this.myWizardContext = wizardContext;
        this.mySequence = sequence;
        this.myMode = mode;
        this.myNamePathComponent = new NamePathComponent(IdeBundle.message((String)"label.project.name", (Object[])new Object[0]), IdeBundle.message((String)"label.project.files.location", (Object[])new Object[0]), IdeBundle.message((String)"title.select.project.file.directory", (Object[])new Object[]{IdeBundle.message((String)"project.new.wizard.project.identification", (Object[])new Object[0])}), IdeBundle.message((String)"description.select.project.file.directory", (Object[])new Object[]{StringUtil.capitalize((String)IdeBundle.message((String)"project.new.wizard.project.identification", (Object[])new Object[0]))}), true, false);
        String baseDir = this.myWizardContext.getProjectFileDirectory();
        String projectName = this.myWizardContext.getProjectName();
        String initialProjectName = projectName != null ? projectName : ProjectWizardUtil.findNonExistingFileName(baseDir, "untitled", "");
        this.myNamePathComponent.setPath(projectName == null ? baseDir + File.separator + initialProjectName : baseDir);
        this.myNamePathComponent.setNameValue(initialProjectName);
        this.myNamePathComponent.getNameComponent().setSelectionStart(0);
        this.myNamePathComponent.getNameComponent().setSelectionEnd(initialProjectName.length());
        this.myPanel = new JPanel(new GridBagLayout());
        this.myPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.myPanel.add((Component)this.myNamePathComponent, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 4, 0, 0), 0, 0));
        this.myPanel.add((Component)this.myFormatPanel.getPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, new Insets(2, 0, 0, 0), 0, 0));
        this.myNamePathComponent.setVisible(this.myWizardContext.getProject() == null);
        this.myFormatPanel.setVisible(this.myWizardContext.getProject() == null);
        Object selectedProjectFormat = this.myFormatPanel.getStorageFormatComboBox().getSelectedItem();
        this.myNamePathComponent.syncNameToPath(".idea (directory based)".equals(selectedProjectFormat));
        this.myFormatPanel.getStorageFormatComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object o = ProjectNameStep.this.myFormatPanel.getStorageFormatComboBox().getSelectedItem();
                ProjectNameStep.this.myNamePathComponent.syncNameToPath(".idea (directory based)".equals(o));
            }
        });
        this.myAdditionalContentPanel = new JPanel(new GridBagLayout());
        this.myPanel.add((Component)this.myAdditionalContentPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void updateDataModel() {
        this.myWizardContext.setProjectName(this.getProjectName());
        String projectFileDirectory = this.getProjectFileDirectory();
        this.myWizardContext.setProjectFileDirectory(projectFileDirectory);
        ProjectBuilder moduleBuilder = this.myMode.getModuleBuilder();
        this.myWizardContext.setProjectBuilder(moduleBuilder);
        this.myFormatPanel.updateData(this.myWizardContext);
        if (moduleBuilder instanceof SourcePathsBuilder) {
            ((SourcePathsBuilder)moduleBuilder).setContentEntryPath(projectFileDirectory);
        }
    }

    public Icon getIcon() {
        return this.myWizardContext.getProject() == null ? NEW_PROJECT_ICON : ICON;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNamePathComponent.getNameComponent();
    }

    public String getHelpId() {
        return "reference.dialogs.new.project.fromCode.name";
    }

    public String getProjectFilePath() {
        if (this.myWizardContext.getProject() == null) {
            if (this.myFormatPanel.isDefault()) {
                return this.getProjectFileDirectory() + "/" + this.myNamePathComponent.getNameValue() + ".ipr";
            }
            return this.getProjectFileDirectory() + "/" + ".idea";
        }
        return this.getProjectFileDirectory() + "/" + this.myNamePathComponent.getNameValue() + ".iml";
    }

    public String getProjectFileDirectory() {
        return this.myNamePathComponent.getPath();
    }

    public String getProjectName() {
        return this.myNamePathComponent.getNameValue();
    }

    public boolean validate() throws ConfigurationException {
        String name = this.myNamePathComponent.getNameValue();
        if (name.length() == 0) {
            ApplicationInfo info = (ApplicationInfo)ApplicationManager.getApplication().getComponent(ApplicationInfo.class);
            throw new ConfigurationException(IdeBundle.message((String)"prompt.new.project.file.name", (Object[])new Object[]{info.getVersionName(), this.myWizardContext.getPresentationName()}));
        }
        String projectFileDirectory = this.getProjectFileDirectory();
        if (projectFileDirectory.length() == 0) {
            throw new ConfigurationException(IdeBundle.message((String)"prompt.enter.project.file.location", (Object[])new Object[]{this.myWizardContext.getPresentationName()}));
        }
        boolean shouldPromptCreation = this.myNamePathComponent.isPathChangedByUser();
        if (!ProjectWizardUtil.createDirectoryIfNotExists(IdeBundle.message((String)"directory.project.file.directory", (Object[])new Object[]{this.myWizardContext.getPresentationName()}), projectFileDirectory, shouldPromptCreation)) {
            return false;
        }
        File file = new File(projectFileDirectory);
        if (!file.canWrite()) {
            throw new ConfigurationException(String.format("Directory '%s' is not writable!\nPlease choose another project location.", projectFileDirectory));
        }
        boolean shouldContinue = true;
        File projectFile = new File(this.getProjectFilePath());
        if (projectFile.exists()) {
            int answer = Messages.showYesNoDialog((String)IdeBundle.message((String)"prompt.overwrite.project.file", (Object[])new Object[]{projectFile.getAbsolutePath(), this.myWizardContext.getPresentationName()}), (String)IdeBundle.message((String)"title.file.already.exists", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
            shouldContinue = answer == 0;
        }
        return shouldContinue;
    }
}

