/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.importProject.LibraryDescriptor;
import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.ide.util.importProject.ModuleInsight;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.SourcePathsBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;

public class ProjectFromSourcesBuilder
extends ProjectBuilder
implements SourcePathsBuilder {
    private List<Pair<String, String>> mySourcePaths = Collections.emptyList();
    private String myContentRootPath;
    private List<LibraryDescriptor> myChosenLibraries = Collections.emptyList();
    private Set<LibraryDescriptor> myChosenLibrariesSet;
    private List<ModuleDescriptor> myChosenModules = Collections.emptyList();
    private final List<ProjectConfigurationUpdater> myUpdaters = new ArrayList<ProjectConfigurationUpdater>();
    private final ModuleInsight myModuleInsight;

    public ProjectFromSourcesBuilder(ModuleInsight moduleInsight) {
        this.myModuleInsight = moduleInsight;
    }

    public void setContentEntryPath(String contentRootPath) {
        this.myContentRootPath = contentRootPath;
    }

    public String getContentEntryPath() {
        return this.myContentRootPath;
    }

    public void addSourcePath(Pair<String, String> sourcePathInfo) {
        this.mySourcePaths.add(sourcePathInfo);
    }

    public void setSourcePaths(List<Pair<String, String>> paths) {
        this.mySourcePaths = paths;
    }

    public List<Pair<String, String>> getSourcePaths() {
        return this.mySourcePaths;
    }

    public List<Module> commit(final Project project, final ModifiableModuleModel model, ModulesProvider modulesProvider) {
        final LibraryTable projectLibraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(project);
        final HashMap projectLibs = new HashMap();
        final ArrayList<Module> result = new ArrayList<Module>();
        Exception e = (Exception)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<Exception>(){

            public Exception compute() {
                try {
                    for (LibraryDescriptor lib : ProjectFromSourcesBuilder.this.myChosenLibraries) {
                        if (lib.getLevel() != LibraryDescriptor.Level.PROJECT) continue;
                        Collection<File> files = lib.getJars();
                        Library projectLib = projectLibraryTable.createLibrary(lib.getName());
                        Library.ModifiableModel model = projectLib.getModifiableModel();
                        for (File file : files) {
                            model.addRoot(VfsUtil.getUrlForLibraryRoot((File)file), OrderRootType.CLASSES);
                        }
                        model.commit();
                        projectLibs.put(lib, projectLib);
                    }
                    return null;
                }
                catch (Exception e) {
                    return e;
                }
            }
        });
        if (e != null) {
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.adding.module.to.project", (Object[])new Object[]{e.getMessage()}), (String)IdeBundle.message((String)"title.add.module", (Object[])new Object[0]));
        }
        final HashMap<String, Object> sourceRootToPrefixMap = new HashMap<String, Object>();
        for (Pair<String, String> pair : this.getSourcePaths()) {
            sourceRootToPrefixMap.put(FileUtil.toSystemIndependentName((String)((String)pair.getFirst())), pair.getSecond());
        }
        final HashMap descriptorToModuleMap = new HashMap();
        Exception ex = (Exception)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<Exception>(){

            public Exception compute() {
                try {
                    ModifiableModuleModel moduleModel = model != null ? model : ModuleManager.getInstance((Project)project).getModifiableModel();
                    for (ModuleDescriptor moduleDescriptor : ProjectFromSourcesBuilder.this.myChosenModules) {
                        Module module = ProjectFromSourcesBuilder.this.createModule(project, moduleDescriptor, sourceRootToPrefixMap, projectLibs, moduleModel);
                        result.add(module);
                        descriptorToModuleMap.put(moduleDescriptor, module);
                    }
                    moduleModel.commit();
                }
                catch (Exception e) {
                    return e;
                }
                return null;
            }
        });
        if (ex != null) {
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.adding.module.to.project", (Object[])new Object[]{ex.getMessage()}), (String)IdeBundle.message((String)"title.add.module", (Object[])new Object[0]));
        }
        if ((ex = (Exception)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<Exception>(){

            public Exception compute() {
                try {
                    for (ModuleDescriptor descriptor : ProjectFromSourcesBuilder.this.myChosenModules) {
                        Set<ModuleDescriptor> deps;
                        Module module = (Module)descriptorToModuleMap.get(descriptor);
                        if (module == null || (deps = descriptor.getDependencies()).size() == 0) continue;
                        ModifiableRootModel rootModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                        for (ModuleDescriptor dependentDescriptor : deps) {
                            Module dependentModule = (Module)descriptorToModuleMap.get(dependentDescriptor);
                            if (dependentModule == null) continue;
                            rootModel.addModuleOrderEntry(dependentModule);
                        }
                        rootModel.commit();
                    }
                }
                catch (Exception e) {
                    return e;
                }
                return null;
            }
        })) != null) {
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.adding.module.to.project", (Object[])new Object[]{ex.getMessage()}), (String)IdeBundle.message((String)"title.add.module", (Object[])new Object[0]));
        }
        return result;
    }

    public void addConfigurationUpdater(ProjectConfigurationUpdater updater) {
        this.myUpdaters.add(updater);
    }

    @NotNull
    public Module createModule(Project project, ModuleDescriptor descriptor, Map<String, String> sourceRootToPrefixMap, Map<LibraryDescriptor, Library> projectLibs, ModifiableModuleModel moduleModel) throws InvalidDataException, IOException, ModuleWithNameAlreadyExists, JDOMException, ConfigurationException {
        String moduleFilePath = descriptor.computeModuleFilePath();
        ModuleBuilder.deleteModuleFile((String)moduleFilePath);
        Module module = moduleModel.newModule(moduleFilePath, StdModuleTypes.JAVA);
        ModifiableRootModel modifiableModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
        this.setupRootModel(descriptor, modifiableModel, sourceRootToPrefixMap, projectLibs);
        for (ProjectConfigurationUpdater updater : this.myUpdaters) {
            updater.updateModule(descriptor, module, modifiableModel);
        }
        modifiableModel.commit();
        Module module2 = module;
        if (module2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/util/newProjectWizard/ProjectFromSourcesBuilder.createModule must not return null");
        }
        return module2;
    }

    private void setupRootModel(ModuleDescriptor descriptor, ModifiableRootModel rootModel, Map<String, String> sourceRootToPrefixMap, Map<LibraryDescriptor, Library> projectLibs) {
        CompilerModuleExtension compilerModuleExtension = (CompilerModuleExtension)rootModel.getModuleExtension(CompilerModuleExtension.class);
        compilerModuleExtension.setExcludeOutput(true);
        rootModel.inheritSdk();
        Set<File> contentRoots = descriptor.getContentRoots();
        for (File contentRoot : contentRoots) {
            LocalFileSystem lfs = LocalFileSystem.getInstance();
            VirtualFile moduleContentRoot = lfs.refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)contentRoot.getPath()));
            if (moduleContentRoot == null) continue;
            ContentEntry contentEntry = rootModel.addContentEntry(moduleContentRoot);
            Set<File> sourceRoots = descriptor.getSourceRoots(contentRoot);
            for (File srcRoot : sourceRoots) {
                String srcpath = FileUtil.toSystemIndependentName((String)srcRoot.getPath());
                VirtualFile sourceRoot = lfs.refreshAndFindFileByPath(srcpath);
                if (sourceRoot == null) continue;
                String packagePrefix = sourceRootToPrefixMap.get(srcpath);
                if (packagePrefix == null || "".equals(packagePrefix)) {
                    contentEntry.addSourceFolder(sourceRoot, ProjectFromSourcesBuilder.shouldBeTestRoot(srcRoot));
                    continue;
                }
                contentEntry.addSourceFolder(sourceRoot, ProjectFromSourcesBuilder.shouldBeTestRoot(srcRoot), packagePrefix);
            }
        }
        compilerModuleExtension.inheritCompilerOutputPath(true);
        LibraryTable moduleLibraryTable = rootModel.getModuleLibraryTable();
        for (LibraryDescriptor libDescriptor : this.myModuleInsight.getLibraryDependencies(descriptor)) {
            if (!this.isLibraryChosen(libDescriptor)) continue;
            Library projectLib = projectLibs.get(libDescriptor);
            if (projectLib != null) {
                rootModel.addLibraryEntry(projectLib);
                continue;
            }
            Collection<File> jars = libDescriptor.getJars();
            for (File file : jars) {
                Library library = moduleLibraryTable.createLibrary();
                Library.ModifiableModel modifiableModel = library.getModifiableModel();
                modifiableModel.addRoot(VfsUtil.getUrlForLibraryRoot((File)file), OrderRootType.CLASSES);
                modifiableModel.commit();
            }
        }
    }

    private static boolean shouldBeTestRoot(File srcRoot) {
        if (ProjectFromSourcesBuilder.isTestRootName(srcRoot.getName())) {
            return true;
        }
        File parentFile = srcRoot.getParentFile();
        return parentFile != null && ProjectFromSourcesBuilder.isTestRootName(parentFile.getName());
    }

    private static boolean isTestRootName(String name) {
        return "test".equalsIgnoreCase(name) || "tests".equalsIgnoreCase(name) || "testSource".equalsIgnoreCase(name) || "testSources".equalsIgnoreCase(name) || "testSrc".equalsIgnoreCase(name);
    }

    public void setLibraries(List<LibraryDescriptor> libraries) {
        this.myChosenLibraries = libraries == null ? Collections.emptyList() : libraries;
        this.myChosenLibrariesSet = null;
    }

    public List<LibraryDescriptor> getLibraries() {
        return this.myChosenLibraries;
    }

    public void setModules(List<ModuleDescriptor> modules) {
        this.myChosenModules = modules == null ? Collections.emptyList() : modules;
    }

    public List<ModuleDescriptor> getModules() {
        return this.myChosenModules;
    }

    public boolean isLibraryChosen(LibraryDescriptor lib) {
        Set<LibraryDescriptor> available = this.myChosenLibrariesSet;
        if (available == null) {
            this.myChosenLibrariesSet = available = new HashSet<LibraryDescriptor>(this.myChosenLibraries);
        }
        return available.contains(lib);
    }

    public boolean isSuitableSdk(Sdk sdk) {
        return sdk.getSdkType() == JavaSdk.getInstance();
    }

    public static interface ProjectConfigurationUpdater {
        public void updateModule(ModuleDescriptor var1, Module var2, ModifiableRootModel var3);
    }
}

