/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard;

import com.intellij.facet.impl.ui.libraries.LibraryCompositionOptionsPanel;
import com.intellij.facet.impl.ui.libraries.LibraryCompositionSettings;
import com.intellij.facet.impl.ui.libraries.LibraryDownloadingMirrorsMap;
import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurable;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportProvider;
import com.intellij.ide.util.frameworkSupport.FrameworkVersion;
import com.intellij.ide.util.newProjectWizard.impl.FrameworkSupportModelImpl;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.GuiUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.tree.MutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameworkSupportNode
extends CheckedTreeNode {
    private final FrameworkSupportProvider myProvider;
    private final FrameworkSupportNode myParentNode;
    private final FrameworkSupportConfigurable myConfigurable;
    private final List<FrameworkSupportNode> myChildren = new ArrayList<FrameworkSupportNode>();
    private LibraryCompositionSettings myLibraryCompositionSettings;
    private final Computable<String> myBaseDirForLibrariesGetter;
    private LibraryCompositionOptionsPanel myLibraryCompositionOptionsPanel;

    FrameworkSupportNode(FrameworkSupportProvider provider, FrameworkSupportNode parentNode, FrameworkSupportModelImpl model, Computable<String> baseDirForLibrariesGetter) {
        super((Object)provider);
        this.myBaseDirForLibrariesGetter = baseDirForLibrariesGetter;
        this.setChecked(false);
        this.myProvider = provider;
        this.myParentNode = parentNode;
        model.registerComponent(provider, this);
        this.myConfigurable = provider.createConfigurable((FrameworkSupportModel)model);
        if (parentNode != null) {
            parentNode.add((MutableTreeNode)((Object)this));
            parentNode.myChildren.add(this);
        }
        this.setConfigurableComponentEnabled(false);
    }

    public List<FrameworkSupportNode> getChildren() {
        return this.myChildren;
    }

    @Nullable
    public LibraryCompositionOptionsPanel getLibraryCompositionOptionsPanel(LibrariesContainer librariesContainer, LibraryDownloadingMirrorsMap mirrorsMap) {
        LibraryCompositionSettings libraryCompositionSettings = this.getLibraryCompositionSettings();
        if (this.myLibraryCompositionOptionsPanel == null || !this.myLibraryCompositionOptionsPanel.getLibraryCompositionSettings().equals(libraryCompositionSettings)) {
            this.myLibraryCompositionOptionsPanel = libraryCompositionSettings != null ? new LibraryCompositionOptionsPanel(librariesContainer, libraryCompositionSettings, mirrorsMap) : null;
        }
        return this.myLibraryCompositionOptionsPanel;
    }

    public void setConfigurableComponentEnabled(boolean enable) {
        JComponent component = this.getConfigurable().getComponent();
        if (component != null) {
            UIUtil.setEnabled((Component)component, (boolean)enable, (boolean)true);
        }
    }

    public FrameworkSupportProvider getProvider() {
        return this.myProvider;
    }

    public FrameworkSupportNode getParentNode() {
        return this.myParentNode;
    }

    public FrameworkSupportConfigurable getConfigurable() {
        return this.myConfigurable;
    }

    private boolean isObsolete(@NotNull LibraryCompositionSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/newProjectWizard/FrameworkSupportNode.isObsolete must not be null");
        }
        Object[] libraries = this.getLibraries();
        return !settings.getBaseDirectoryForDownloadedFiles().equals(this.myBaseDirForLibrariesGetter.compute()) || !Comparing.equal((Object[])settings.getLibraryInfos(), (Object[])libraries);
    }

    public LibraryInfo[] getLibraries() {
        FrameworkVersion version = this.myConfigurable.getSelectedVersion();
        return version != null ? version.getLibraries() : LibraryInfo.EMPTY_ARRAY;
    }

    @Nullable
    public LibraryCompositionSettings getLibraryCompositionSettings() {
        if (this.myLibraryCompositionSettings == null || this.isObsolete(this.myLibraryCompositionSettings)) {
            LibraryInfo[] libraries = this.getLibraries();
            this.myLibraryCompositionSettings = libraries.length != 0 ? new LibraryCompositionSettings(libraries, this.myConfigurable.getSelectedVersion().getLibraryName(), (String)this.myBaseDirForLibrariesGetter.compute(), "Libraries", this.myProvider.getIcon()) : null;
        }
        return this.myLibraryCompositionSettings;
    }

    public static void sortByTitle(List<FrameworkSupportNode> nodes) {
        if (nodes.isEmpty()) {
            return;
        }
        Collections.sort(nodes, new Comparator<FrameworkSupportNode>(){

            @Override
            public int compare(FrameworkSupportNode o1, FrameworkSupportNode o2) {
                return FrameworkSupportNode.getTitleWithoutMnemonic(o1.getProvider()).compareTo(FrameworkSupportNode.getTitleWithoutMnemonic(o2.getProvider()));
            }
        });
        for (FrameworkSupportNode node : nodes) {
            node.sortChildren();
        }
    }

    public String getTitle() {
        return FrameworkSupportNode.getTitleWithoutMnemonic(this.myProvider);
    }

    private static String getTitleWithoutMnemonic(FrameworkSupportProvider provider) {
        return GuiUtils.getTextWithoutMnemonicEscaping((String)provider.getTitle());
    }

    private void sortChildren() {
        FrameworkSupportNode.sortByTitle(this.myChildren);
    }
}

