/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserDialog;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.ide.util.TreeFileChooser;
import com.intellij.ide.util.TreeFileChooserDialog;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeClassChooserFactoryImpl
extends TreeClassChooserFactory {
    private final Project myProject;

    public TreeClassChooserFactoryImpl(Project project) {
        this.myProject = project;
    }

    @NotNull
    public TreeClassChooser createWithInnerClassesScopeChooser(String title, GlobalSearchScope scope, TreeClassChooser.ClassFilter classFilter, PsiClass initialClass) {
        TreeClassChooserDialog treeClassChooserDialog = TreeClassChooserDialog.withInnerClasses(title, this.myProject, scope, classFilter, initialClass);
        if (treeClassChooserDialog == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/util/TreeClassChooserFactoryImpl.createWithInnerClassesScopeChooser must not return null");
        }
        return treeClassChooserDialog;
    }

    @NotNull
    public TreeClassChooser createNoInnerClassesScopeChooser(String title, GlobalSearchScope scope, TreeClassChooser.ClassFilter classFilter, PsiClass initialClass) {
        TreeClassChooserDialog treeClassChooserDialog = new TreeClassChooserDialog(title, this.myProject, scope, classFilter, initialClass);
        if (treeClassChooserDialog == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/util/TreeClassChooserFactoryImpl.createNoInnerClassesScopeChooser must not return null");
        }
        return treeClassChooserDialog;
    }

    @NotNull
    public TreeClassChooser createProjectScopeChooser(String title, PsiClass initialClass) {
        TreeClassChooserDialog treeClassChooserDialog = new TreeClassChooserDialog(title, this.myProject, initialClass);
        if (treeClassChooserDialog == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/util/TreeClassChooserFactoryImpl.createProjectScopeChooser must not return null");
        }
        return treeClassChooserDialog;
    }

    @NotNull
    public TreeClassChooser createProjectScopeChooser(String title) {
        TreeClassChooserDialog treeClassChooserDialog = new TreeClassChooserDialog(title, this.myProject);
        if (treeClassChooserDialog == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/util/TreeClassChooserFactoryImpl.createProjectScopeChooser must not return null");
        }
        return treeClassChooserDialog;
    }

    @NotNull
    public TreeClassChooser createAllProjectScopeChooser(String title) {
        TreeClassChooserDialog treeClassChooserDialog = new TreeClassChooserDialog(title, this.myProject, GlobalSearchScope.allScope((Project)this.myProject), null, null);
        if (treeClassChooserDialog == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/util/TreeClassChooserFactoryImpl.createAllProjectScopeChooser must not return null");
        }
        return treeClassChooserDialog;
    }

    @NotNull
    public TreeClassChooser createInheritanceClassChooser(String title, GlobalSearchScope scope, PsiClass base, boolean acceptsSelf, boolean acceptInner, Condition<? super PsiClass> additionalCondition) {
        TreeClassChooserDialog.InheritanceClassFilterImpl classFilter = new TreeClassChooserDialog.InheritanceClassFilterImpl(base, acceptsSelf, acceptInner, additionalCondition);
        TreeClassChooserDialog treeClassChooserDialog = new TreeClassChooserDialog(title, this.myProject, scope, (TreeClassChooser.ClassFilter)classFilter, base, null, null);
        if (treeClassChooserDialog == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/util/TreeClassChooserFactoryImpl.createInheritanceClassChooser must not return null");
        }
        return treeClassChooserDialog;
    }

    @NotNull
    public TreeClassChooser createInheritanceClassChooser(String title, GlobalSearchScope scope, PsiClass base, PsiClass initialClass) {
        TreeClassChooser treeClassChooser = this.createInheritanceClassChooser(title, scope, base, initialClass, null);
        if (treeClassChooser == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/util/TreeClassChooserFactoryImpl.createInheritanceClassChooser must not return null");
        }
        return treeClassChooser;
    }

    @NotNull
    public TreeClassChooser createInheritanceClassChooser(String title, GlobalSearchScope scope, PsiClass base, PsiClass initialClass, TreeClassChooser.ClassFilter classFilter) {
        TreeClassChooserDialog treeClassChooserDialog = new TreeClassChooserDialog(title, this.myProject, scope, classFilter, base, initialClass, null);
        if (treeClassChooserDialog == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/util/TreeClassChooserFactoryImpl.createInheritanceClassChooser must not return null");
        }
        return treeClassChooserDialog;
    }

    @NotNull
    public TreeFileChooser createFileChooser(@NotNull String title, PsiFile initialFile, FileType fileType, TreeFileChooser.PsiFileFilter filter) {
        if (title == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/TreeClassChooserFactoryImpl.createFileChooser must not be null");
        }
        TreeFileChooserDialog treeFileChooserDialog = new TreeFileChooserDialog(this.myProject, title, initialFile, fileType, filter, false, false);
        if (treeFileChooserDialog == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/util/TreeClassChooserFactoryImpl.createFileChooser must not return null");
        }
        return treeFileChooserDialog;
    }

    @NotNull
    public TreeFileChooser createFileChooser(@NotNull String title, @Nullable PsiFile initialFile, @Nullable FileType fileType, @Nullable TreeFileChooser.PsiFileFilter filter, boolean disableStructureProviders) {
        if (title == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/TreeClassChooserFactoryImpl.createFileChooser must not be null");
        }
        TreeFileChooserDialog treeFileChooserDialog = new TreeFileChooserDialog(this.myProject, title, initialFile, fileType, filter, disableStructureProviders, false);
        if (treeFileChooserDialog == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/util/TreeClassChooserFactoryImpl.createFileChooser must not return null");
        }
        return treeFileChooserDialog;
    }

    @NotNull
    public TreeFileChooser createFileChooser(@NotNull String title, @Nullable PsiFile initialFile, @Nullable FileType fileType, @Nullable TreeFileChooser.PsiFileFilter filter, boolean disableStructureProviders, boolean showLibraryContents) {
        if (title == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/TreeClassChooserFactoryImpl.createFileChooser must not be null");
        }
        TreeFileChooserDialog treeFileChooserDialog = new TreeFileChooserDialog(this.myProject, title, initialFile, fileType, filter, disableStructureProviders, showLibraryContents);
        if (treeFileChooserDialog == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/util/TreeClassChooserFactoryImpl.createFileChooser must not return null");
        }
        return treeFileChooserDialog;
    }
}

