/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;

public class PsiElementModuleRenderer
extends DefaultListCellRenderer {
    private static final Icon TEST_ICON = IconLoader.getIcon((String)"/nodes/testSourceFolder.png");
    private static final Icon LIB_ICON = IconLoader.getIcon((String)"/nodes/ppLibClosed.png");
    private String myText;

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component listCellRendererComponent = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        this.customizeCellRenderer(value, index, isSelected, cellHasFocus);
        return listCellRendererComponent;
    }

    @Override
    public String getText() {
        return this.myText;
    }

    protected void customizeCellRenderer(Object value, int index, boolean selected, boolean hasFocus) {
        if (value instanceof PsiElement) {
            PsiElement element = (PsiElement)value;
            if (element.isValid()) {
                VirtualFile vFile;
                PsiFile psiFile = element.getContainingFile();
                Module module = ModuleUtil.findModuleForPsiElement((PsiElement)element);
                ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex();
                if (module != null) {
                    VirtualFile vFile2;
                    boolean inTestSource = false;
                    if (psiFile != null && (vFile2 = psiFile.getVirtualFile()) != null) {
                        inTestSource = fileIndex.isInTestSourceContent(vFile2);
                    }
                    this.myText = module.getName();
                    if (inTestSource) {
                        this.setIcon(TEST_ICON);
                    } else {
                        this.setIcon(module.getModuleType().getNodeIcon(false));
                    }
                } else if (psiFile != null && (vFile = psiFile.getVirtualFile()) != null) {
                    boolean isInLibraries;
                    boolean bl = isInLibraries = fileIndex.isInLibrarySource(vFile) || fileIndex.isInLibraryClasses(vFile);
                    if (isInLibraries) {
                        this.setIcon(LIB_ICON);
                        for (OrderEntry order : fileIndex.getOrderEntriesForFile(vFile)) {
                            if (!(order instanceof LibraryOrderEntry) && !(order instanceof JdkOrderEntry)) continue;
                            this.myText = order.getPresentableName();
                            break;
                        }
                    }
                }
            } else {
                this.myText = "";
            }
        }
        this.setText(this.myText);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
        this.setHorizontalTextPosition(2);
        this.setBackground(selected ? UIUtil.getListSelectionBackground() : UIUtil.getListBackground());
        this.setForeground(selected ? UIUtil.getListSelectionForeground() : UIUtil.getInactiveTextColor());
    }
}

