/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.ModuleRendererFactory;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nullable;

public abstract class PsiElementListCellRenderer<T extends PsiElement>
extends JPanel
implements ListCellRenderer {
    protected PsiElementListCellRenderer() {
        super(new BorderLayout());
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.removeAll();
        String moduleName = null;
        DefaultListCellRenderer rightRenderer = this.getRightCellRenderer();
        Component leftCellRendererComponent = new LeftRenderer(moduleName).getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        if (rightRenderer != null) {
            Component rightCellRendererComponent = rightRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            rightCellRendererComponent.setBackground(isSelected ? UIUtil.getListSelectionBackground() : leftCellRendererComponent.getBackground());
            this.add(rightCellRendererComponent, "East");
            moduleName = rightRenderer.getText();
            JPanel spacer = new JPanel();
            spacer.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            spacer.setBackground(isSelected ? UIUtil.getListSelectionBackground() : leftCellRendererComponent.getBackground());
            this.add((Component)spacer, "Center");
        }
        this.add(leftCellRendererComponent, "West");
        this.setBackground(isSelected ? UIUtil.getListSelectionBackground() : leftCellRendererComponent.getBackground());
        return this;
    }

    @Nullable
    protected DefaultListCellRenderer getRightCellRenderer() {
        if (UISettings.getInstance().SHOW_ICONS_IN_QUICK_NAVIGATION) {
            return ModuleRendererFactory.getInstance().getModuleRenderer();
        }
        return null;
    }

    public abstract String getElementText(T var1);

    @Nullable
    protected abstract String getContainerText(T var1, String var2);

    protected abstract int getIconFlags();

    protected Icon getIcon(PsiElement element) {
        return element.getIcon(this.getIconFlags());
    }

    public Comparator<T> getComparator() {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return this.getText(o1).compareTo(this.getText(o2));
            }

            private String getText(T element) {
                String elementText = PsiElementListCellRenderer.this.getElementText(element);
                String containerText = PsiElementListCellRenderer.this.getContainerText(element, elementText);
                return containerText != null ? elementText + " " + containerText : elementText;
            }
        };
    }

    public void installSpeedSearch(PopupChooserBuilder builder) {
        builder.setFilteringEnabled((Function)new Function<Object, String>(){

            public String fun(Object o) {
                if (o instanceof PsiElement) {
                    return PsiElementListCellRenderer.this.getElementText((PsiElement)o);
                }
                return o.toString();
            }
        });
    }

    @Deprecated
    public void installSpeedSearch(JList list) {
        new ListSpeedSearch(list){

            @Override
            protected String getElementText(Object o) {
                if (o instanceof PsiElement) {
                    return PsiElementListCellRenderer.this.getElementText((PsiElement)o);
                }
                return o.toString();
            }
        };
    }

    private class LeftRenderer
    extends ColoredListCellRenderer {
        private final String myModuleName;

        public LeftRenderer(String moduleName) {
            this.myModuleName = moduleName;
        }

        protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            Color bgColor = UIUtil.getListBackground();
            if (value instanceof PsiElement) {
                SimpleTextAttributes nameAttributes;
                VirtualFile vFile;
                PsiElement element = (PsiElement)value;
                String name = PsiElementListCellRenderer.this.getElementText(element);
                Color color = list.getForeground();
                PsiFile psiFile = element.getContainingFile();
                boolean isProblemFile = false;
                if (psiFile != null && (vFile = psiFile.getVirtualFile()) != null) {
                    if (WolfTheProblemSolver.getInstance((Project)psiFile.getProject()).isProblemFile(vFile)) {
                        isProblemFile = true;
                    }
                    FileStatus status = FileStatusManager.getInstance((Project)psiFile.getProject()).getStatus(vFile);
                    color = status.getColor();
                    FileColorManager colorManager = FileColorManager.getInstance((Project)psiFile.getProject());
                    if (colorManager.isEnabled()) {
                        Color fileBgColor = colorManager.getRendererBackground(psiFile);
                        bgColor = fileBgColor == null ? bgColor : fileBgColor;
                    }
                }
                TextAttributes attributes = null;
                if (value instanceof NavigationItem) {
                    TextAttributesKey attributesKey = null;
                    ItemPresentation presentation = ((NavigationItem)value).getPresentation();
                    if (presentation != null) {
                        attributesKey = presentation.getTextAttributesKey();
                    }
                    if (attributesKey != null) {
                        attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(attributesKey);
                    }
                }
                if (isProblemFile) {
                    attributes = TextAttributes.merge((TextAttributes)new TextAttributes(color, null, Color.red, EffectType.WAVE_UNDERSCORE, 0), attributes);
                }
                SimpleTextAttributes simpleTextAttributes = nameAttributes = attributes != null ? SimpleTextAttributes.fromTextAttributes(attributes) : null;
                if (nameAttributes == null) {
                    nameAttributes = new SimpleTextAttributes(0, color);
                }
                assert (name != null) : "Null name for PSI element " + element;
                this.append(name, nameAttributes);
                this.setIcon(PsiElementListCellRenderer.this.getIcon(element));
                String containerText = PsiElementListCellRenderer.this.getContainerText(element, name + (this.myModuleName != null ? this.myModuleName + "        " : ""));
                if (containerText != null) {
                    this.append(" " + containerText, new SimpleTextAttributes(0, Color.GRAY));
                }
            } else {
                this.setIcon(IconUtil.getEmptyIcon((boolean)false));
                this.append(value == null ? "" : value.toString(), new SimpleTextAttributes(0, list.getForeground()));
            }
            this.setPaintFocusBorder(false);
            this.setBackground(selected ? UIUtil.getListSelectionBackground() : bgColor);
        }
    }
}

