/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.util.containers.HashMap;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PropertiesComponentImpl
extends PropertiesComponent
implements PersistentStateComponent<Element> {
    private final HashMap<String, String> myMap = new HashMap();
    @NonNls
    private static final String ELEMENT_PROPERTY = "property";
    @NonNls
    private static final String ATTRIBUTE_NAME = "name";
    @NonNls
    private static final String ATTRIBUTE_VALUE = "value";

    @NotNull
    public String getComponentName() {
        if ("PropertiesComponent" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/util/PropertiesComponentImpl.getComponentName must not return null");
        }
        return "PropertiesComponent";
    }

    PropertiesComponentImpl() {
    }

    public Element getState() {
        Element parentNode = new Element("state");
        for (String key : this.myMap.keySet()) {
            String value = (String)this.myMap.get((Object)key);
            if (value == null) continue;
            Element element = new Element(ELEMENT_PROPERTY);
            element.setAttribute(ATTRIBUTE_NAME, key);
            element.setAttribute(ATTRIBUTE_VALUE, value);
            parentNode.addContent(element);
        }
        return parentNode;
    }

    public void loadState(Element parentNode) {
        this.myMap.clear();
        for (Object o : parentNode.getChildren(ELEMENT_PROPERTY)) {
            Element e = (Element)o;
            String name = e.getAttributeValue(ATTRIBUTE_NAME);
            String value = e.getAttributeValue(ATTRIBUTE_VALUE);
            if (name == null) continue;
            this.myMap.put((Object)name, (Object)value);
        }
    }

    public String getValue(String name) {
        return (String)this.myMap.get((Object)name);
    }

    public void setValue(String name, String value) {
        this.myMap.put((Object)name, (Object)value);
    }

    public boolean isValueSet(String name) {
        return this.myMap.containsKey((Object)name);
    }
}

