/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nullable;

public class AppearanceConfigurable
extends BaseConfigurable
implements SearchableConfigurable {
    private MyComponent myComponent;

    public String getDisplayName() {
        return IdeBundle.message((String)"title.appearance", (Object[])new Object[0]);
    }

    public JComponent createComponent() {
        this.myComponent = new MyComponent();
        DefaultComboBoxModel<String> aModel = new DefaultComboBoxModel<String>(UIUtil.getValidFontNames((boolean)false));
        this.myComponent.myFontCombo.setModel(aModel);
        this.myComponent.myFontSizeCombo.setModel(new DefaultComboBoxModel<String>(UIUtil.getStandardFontSizes()));
        this.myComponent.myFontSizeCombo.setEditable(true);
        this.myComponent.myLafComboBox.setModel(new DefaultComboBoxModel<UIManager.LookAndFeelInfo>(LafManager.getInstance().getInstalledLookAndFeels()));
        this.myComponent.myLafComboBox.setRenderer(new MyLafComboBoxRenderer());
        this.myComponent.myEnableAlphaModeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean state = AppearanceConfigurable.this.myComponent.myEnableAlphaModeCheckBox.isSelected();
                AppearanceConfigurable.this.myComponent.myAlphaModeDelayTextField.setEnabled(state);
                AppearanceConfigurable.this.myComponent.myAlphaModeRatioSlider.setEnabled(state);
            }
        });
        this.myComponent.myAlphaModeRatioSlider.setSize(100, 50);
        Hashtable<Integer, JLabel> dictionary = new Hashtable<Integer, JLabel>();
        ((Dictionary)dictionary).put(new Integer(0), new JLabel("0%"));
        ((Dictionary)dictionary).put(new Integer(50), new JLabel("50%"));
        ((Dictionary)dictionary).put(new Integer(100), new JLabel("100%"));
        this.myComponent.myAlphaModeRatioSlider.setLabelTable(dictionary);
        UIUtil.setSliderIsFilled((JSlider)this.myComponent.myAlphaModeRatioSlider, (boolean)Boolean.TRUE);
        this.myComponent.myAlphaModeRatioSlider.setPaintLabels(true);
        this.myComponent.myAlphaModeRatioSlider.setPaintTicks(true);
        this.myComponent.myAlphaModeRatioSlider.setPaintTrack(true);
        this.myComponent.myAlphaModeRatioSlider.setMajorTickSpacing(50);
        this.myComponent.myAlphaModeRatioSlider.setMinorTickSpacing(10);
        this.myComponent.myAlphaModeRatioSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AppearanceConfigurable.this.myComponent.myAlphaModeRatioSlider.setToolTipText(AppearanceConfigurable.this.myComponent.myAlphaModeRatioSlider.getValue() + "%");
            }
        });
        this.myComponent.myTransparencyPanel.setVisible(WindowManagerEx.getInstanceEx().isAlphaModeSupported());
        return this.myComponent.myPanel;
    }

    public Icon getIcon() {
        return IconLoader.getIcon((String)"/general/configurableAppearance.png");
    }

    public void apply() {
        UISettings settings = UISettings.getInstance();
        String temp = (String)this.myComponent.myFontSizeCombo.getEditor().getItem();
        int _fontSize = -1;
        if (temp != null && temp.trim().length() > 0) {
            try {
                _fontSize = Integer.parseInt(temp);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            if (_fontSize <= 0) {
                _fontSize = settings.FONT_SIZE;
            }
        } else {
            _fontSize = settings.FONT_SIZE;
        }
        boolean shouldUpdateUI = false;
        String _fontFace = (String)this.myComponent.myFontCombo.getSelectedItem();
        LafManager lafManager = LafManager.getInstance();
        if (_fontSize != settings.FONT_SIZE || !settings.FONT_FACE.equals(_fontFace)) {
            settings.FONT_SIZE = _fontSize;
            settings.FONT_FACE = _fontFace;
            shouldUpdateUI = true;
        }
        settings.ANIMATE_WINDOWS = this.myComponent.myAnimateWindowsCheckBox.isSelected();
        boolean update = settings.SHOW_TOOL_WINDOW_NUMBERS != this.myComponent.myWindowShortcutsCheckBox.isSelected();
        settings.SHOW_TOOL_WINDOW_NUMBERS = this.myComponent.myWindowShortcutsCheckBox.isSelected();
        update |= settings.HIDE_TOOL_STRIPES != !this.myComponent.myShowToolStripesCheckBox.isSelected();
        settings.HIDE_TOOL_STRIPES = !this.myComponent.myShowToolStripesCheckBox.isSelected();
        update |= settings.SHOW_ICONS_IN_MENUS != this.myComponent.myCbDisplayIconsInMenu.isSelected();
        settings.SHOW_ICONS_IN_MENUS = this.myComponent.myCbDisplayIconsInMenu.isSelected();
        update |= settings.SHOW_MEMORY_INDICATOR != this.myComponent.myShowMemoryIndicatorCheckBox.isSelected();
        settings.SHOW_MEMORY_INDICATOR = this.myComponent.myShowMemoryIndicatorCheckBox.isSelected();
        update |= settings.CYCLE_SCROLLING != this.myComponent.myCycleScrollingCheckBox.isSelected();
        settings.CYCLE_SCROLLING = this.myComponent.myCycleScrollingCheckBox.isSelected();
        if (settings.OVERRIDE_NONIDEA_LAF_FONTS != this.myComponent.myOverrideLAFFonts.isSelected()) {
            shouldUpdateUI = true;
        }
        settings.OVERRIDE_NONIDEA_LAF_FONTS = this.myComponent.myOverrideLAFFonts.isSelected();
        settings.MOVE_MOUSE_ON_DEFAULT_BUTTON = this.myComponent.myMoveMouseOnDefaultButtonCheckBox.isSelected();
        update |= settings.DISABLE_MNEMONICS != this.myComponent.myDisableMnemonics.isSelected();
        settings.DISABLE_MNEMONICS = this.myComponent.myDisableMnemonics.isSelected();
        update |= settings.SHOW_ICONS_IN_QUICK_NAVIGATION != this.myComponent.myHideIconsInQuickNavigation.isSelected();
        settings.SHOW_ICONS_IN_QUICK_NAVIGATION = this.myComponent.myHideIconsInQuickNavigation.isSelected();
        if (!Comparing.equal((Object)this.myComponent.myLafComboBox.getSelectedItem(), (Object)lafManager.getCurrentLookAndFeel())) {
            shouldUpdateUI = true;
            update = true;
            lafManager.setCurrentLookAndFeel((UIManager.LookAndFeelInfo)this.myComponent.myLafComboBox.getSelectedItem());
        }
        if (shouldUpdateUI) {
            lafManager.updateUI();
        }
        if (WindowManagerEx.getInstanceEx().isAlphaModeSupported()) {
            int delay = -1;
            try {
                delay = Integer.parseInt(this.myComponent.myAlphaModeDelayTextField.getText());
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
            float ratio = (float)this.myComponent.myAlphaModeRatioSlider.getValue() / 100.0f;
            if (this.myComponent.myEnableAlphaModeCheckBox.isSelected() != settings.ENABLE_ALPHA_MODE || delay != -1 && delay != settings.ALPHA_MODE_DELAY || ratio != settings.ALPHA_MODE_RATIO) {
                update = true;
                settings.ENABLE_ALPHA_MODE = this.myComponent.myEnableAlphaModeCheckBox.isSelected();
                settings.ALPHA_MODE_DELAY = delay;
                settings.ALPHA_MODE_RATIO = ratio;
            }
        }
        if (update) {
            settings.fireUISettingsChanged();
        }
        this.myComponent.updateCombo();
    }

    public void reset() {
        UISettings settings = UISettings.getInstance();
        this.myComponent.myFontCombo.setSelectedItem(settings.FONT_FACE);
        this.myComponent.myFontSizeCombo.setSelectedItem(Integer.toString(settings.FONT_SIZE));
        this.myComponent.myAnimateWindowsCheckBox.setSelected(settings.ANIMATE_WINDOWS);
        this.myComponent.myWindowShortcutsCheckBox.setSelected(settings.SHOW_TOOL_WINDOW_NUMBERS);
        this.myComponent.myShowToolStripesCheckBox.setSelected(!settings.HIDE_TOOL_STRIPES);
        this.myComponent.myCbDisplayIconsInMenu.setSelected(settings.SHOW_ICONS_IN_MENUS);
        this.myComponent.myShowMemoryIndicatorCheckBox.setSelected(settings.SHOW_MEMORY_INDICATOR);
        this.myComponent.myCycleScrollingCheckBox.setSelected(settings.CYCLE_SCROLLING);
        this.myComponent.myHideIconsInQuickNavigation.setSelected(settings.SHOW_ICONS_IN_QUICK_NAVIGATION);
        this.myComponent.myMoveMouseOnDefaultButtonCheckBox.setSelected(settings.MOVE_MOUSE_ON_DEFAULT_BUTTON);
        this.myComponent.myLafComboBox.setSelectedItem(LafManager.getInstance().getCurrentLookAndFeel());
        this.myComponent.myOverrideLAFFonts.setSelected(settings.OVERRIDE_NONIDEA_LAF_FONTS);
        this.myComponent.myDisableMnemonics.setSelected(settings.DISABLE_MNEMONICS);
        boolean alphaModeEnabled = WindowManagerEx.getInstanceEx().isAlphaModeSupported();
        if (alphaModeEnabled) {
            this.myComponent.myEnableAlphaModeCheckBox.setSelected(settings.ENABLE_ALPHA_MODE);
        } else {
            this.myComponent.myEnableAlphaModeCheckBox.setSelected(false);
        }
        this.myComponent.myEnableAlphaModeCheckBox.setEnabled(alphaModeEnabled);
        this.myComponent.myAlphaModeDelayTextField.setText(Integer.toString(settings.ALPHA_MODE_DELAY));
        this.myComponent.myAlphaModeDelayTextField.setEnabled(alphaModeEnabled && settings.ENABLE_ALPHA_MODE);
        int ratio = (int)(settings.ALPHA_MODE_RATIO * 100.0f);
        this.myComponent.myAlphaModeRatioSlider.setValue(ratio);
        this.myComponent.myAlphaModeRatioSlider.setToolTipText(ratio + "%");
        this.myComponent.myAlphaModeRatioSlider.setEnabled(alphaModeEnabled && settings.ENABLE_ALPHA_MODE);
        this.myComponent.updateCombo();
    }

    public boolean isModified() {
        UISettings settings = UISettings.getInstance();
        boolean isModified = false;
        isModified |= !Comparing.equal((Object)this.myComponent.myFontCombo.getSelectedItem(), (Object)settings.FONT_FACE);
        isModified |= !Comparing.equal((Object)this.myComponent.myFontSizeCombo.getEditor().getItem(), (Object)Integer.toString(settings.FONT_SIZE));
        isModified |= this.myComponent.myAnimateWindowsCheckBox.isSelected() != settings.ANIMATE_WINDOWS;
        isModified |= this.myComponent.myWindowShortcutsCheckBox.isSelected() != settings.SHOW_TOOL_WINDOW_NUMBERS;
        isModified |= this.myComponent.myShowToolStripesCheckBox.isSelected() == settings.HIDE_TOOL_STRIPES;
        isModified |= this.myComponent.myCbDisplayIconsInMenu.isSelected() != settings.SHOW_ICONS_IN_MENUS;
        isModified |= this.myComponent.myShowMemoryIndicatorCheckBox.isSelected() != settings.SHOW_MEMORY_INDICATOR;
        isModified |= this.myComponent.myCycleScrollingCheckBox.isSelected() != settings.CYCLE_SCROLLING;
        isModified |= this.myComponent.myOverrideLAFFonts.isSelected() != settings.OVERRIDE_NONIDEA_LAF_FONTS;
        isModified |= this.myComponent.myDisableMnemonics.isSelected() != settings.DISABLE_MNEMONICS;
        isModified |= this.myComponent.myHideIconsInQuickNavigation.isSelected() != settings.SHOW_ICONS_IN_QUICK_NAVIGATION;
        isModified |= this.myComponent.myMoveMouseOnDefaultButtonCheckBox.isSelected() != settings.MOVE_MOUSE_ON_DEFAULT_BUTTON;
        isModified |= !Comparing.equal((Object)this.myComponent.myLafComboBox.getSelectedItem(), (Object)LafManager.getInstance().getCurrentLookAndFeel());
        if (WindowManagerEx.getInstanceEx().isAlphaModeSupported()) {
            float ratio;
            isModified |= this.myComponent.myEnableAlphaModeCheckBox.isSelected() != settings.ENABLE_ALPHA_MODE;
            int delay = -1;
            try {
                delay = Integer.parseInt(this.myComponent.myAlphaModeDelayTextField.getText());
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
            if (delay != -1) {
                isModified |= delay != settings.ALPHA_MODE_DELAY;
            }
            isModified |= (ratio = (float)this.myComponent.myAlphaModeRatioSlider.getValue() / 100.0f) != settings.ALPHA_MODE_RATIO;
        }
        return isModified;
    }

    private static boolean isModified(JTextField textField, int value) {
        try {
            int fieldValue = Integer.parseInt(textField.getText().trim());
            return fieldValue != value;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean isModified(JToggleButton checkBox, boolean value) {
        return checkBox.isSelected() != value;
    }

    public void disposeUIResources() {
        this.myComponent = null;
    }

    public String getHelpTopic() {
        return "preferences.lookFeel";
    }

    public String getId() {
        return this.getHelpTopic();
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    private static class MyComponent {
        JPanel myPanel;
        private JComboBox myFontCombo;
        private JComboBox myFontSizeCombo;
        private JCheckBox myAnimateWindowsCheckBox;
        private JCheckBox myWindowShortcutsCheckBox;
        private JCheckBox myShowToolStripesCheckBox;
        private JCheckBox myShowMemoryIndicatorCheckBox;
        private JComboBox myLafComboBox;
        private JCheckBox myCycleScrollingCheckBox;
        private JCheckBox myMoveMouseOnDefaultButtonCheckBox;
        private JCheckBox myEnableAlphaModeCheckBox;
        private JTextField myAlphaModeDelayTextField;
        private JSlider myAlphaModeRatioSlider;
        private JLabel myFontSizeLabel;
        private JLabel myFontNameLabel;
        private JPanel myTransparencyPanel;
        private JCheckBox myOverrideLAFFonts;
        private JLabel myIDEALafFont;
        private JCheckBox myHideIconsInQuickNavigation;
        private JCheckBox myCbDisplayIconsInMenu;
        private JCheckBox myDisableMnemonics;

        public MyComponent() {
            this.$$$setupUI$$$();
            ActionListener updater = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MyComponent.this.updateCombo();
                }
            };
            this.myLafComboBox.addActionListener(updater);
            this.myOverrideLAFFonts.addActionListener(updater);
            this.myIDEALafFont.setPreferredSize(new Dimension(this.myIDEALafFont.getPreferredSize().width, this.myOverrideLAFFonts.getPreferredSize().height));
            this.myCbDisplayIconsInMenu.setVisible(SystemInfo.isMac);
        }

        public void updateCombo() {
            UIManager.LookAndFeelInfo selectedLAF = (UIManager.LookAndFeelInfo)this.myLafComboBox.getSelectedItem();
            boolean isIdeaLAFSelected = selectedLAF != null && selectedLAF.getName().startsWith("IDEA");
            this.myIDEALafFont.setVisible(isIdeaLAFSelected);
            this.myOverrideLAFFonts.setVisible(!isIdeaLAFSelected);
            boolean enableChooser = isIdeaLAFSelected || this.myOverrideLAFFonts.isSelected();
            this.myFontCombo.setEnabled(enableChooser);
            this.myFontSizeCombo.setEnabled(enableChooser);
            this.myFontNameLabel.setEnabled(enableChooser);
            this.myFontSizeLabel.setEnabled(enableChooser);
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JCheckBox jCheckBox2;
            JCheckBox jCheckBox3;
            JCheckBox jCheckBox4;
            JCheckBox jCheckBox5;
            JCheckBox jCheckBox6;
            JTextField jTextField;
            JSlider jSlider;
            JCheckBox jCheckBox7;
            JPanel jPanel;
            JCheckBox jCheckBox8;
            JCheckBox jCheckBox9;
            JLabel jLabel;
            JLabel jLabel2;
            JLabel jLabel3;
            JComboBox jComboBox;
            JComboBox jComboBox2;
            JComboBox jComboBox3;
            JCheckBox jCheckBox10;
            JCheckBox jCheckBox11;
            JPanel jPanel2;
            this.myPanel = jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(5, 5, 5, 5), -1, -1, false, false));
            jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 1, 3, 0, 0, null, null, null));
            jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("messages/IdeBundle").getString("group.ui.options"), 0, 0, null, null));
            this.myMoveMouseOnDefaultButtonCheckBox = jCheckBox11 = new JCheckBox();
            jCheckBox11.setMargin(new Insets(2, 0, 2, 2));
            this.$$$loadButtonText$$$(jCheckBox11, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.position.cursor.on.default.button"));
            jPanel3.add((Component)jCheckBox11, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
            this.myCycleScrollingCheckBox = jCheckBox10 = new JCheckBox();
            jCheckBox10.setMargin(new Insets(2, 0, 2, 2));
            jCheckBox10.setSelected(true);
            this.$$$loadButtonText$$$(jCheckBox10, ResourceBundle.getBundle("messages/IdeBundle").getString("checkboox.cyclic.scrolling.in.lists"));
            jPanel3.add((Component)jCheckBox10, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel3.add((Component)jPanel4, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
            JLabel jLabel4 = new JLabel();
            jLabel4.setHorizontalAlignment(2);
            jLabel4.setHorizontalTextPosition(2);
            jLabel4.setVerifyInputWhenFocusTarget(false);
            this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/IdeBundle").getString("combobox.look.and.feel"));
            jPanel4.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myLafComboBox = jComboBox3 = new JComboBox();
            jPanel4.add(jComboBox3, new GridConstraints(0, 1, 1, 1, 8, 1, 3, 0, null, null, null));
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel3.add((Component)jPanel5, new GridConstraints(5, 0, 1, 2, 0, 3, 3, 3, null, null, null));
            this.myFontSizeCombo = jComboBox2 = new JComboBox();
            jComboBox2.setEditable(true);
            jPanel5.add(jComboBox2, new GridConstraints(1, 2, 1, 1, 8, 1, 2, 0, new Dimension(140, -1), new Dimension(140, -1), null));
            this.myFontCombo = jComboBox = new JComboBox();
            jComboBox.setPopupVisible(false);
            jComboBox.setEditable(false);
            jComboBox.setName("");
            jComboBox.setDoubleBuffered(false);
            ((Component)jComboBox).setEnabled(true);
            jComboBox.setAutoscrolls(true);
            jComboBox.setRequestFocusEnabled(true);
            jPanel5.add(jComboBox, new GridConstraints(0, 2, 1, 1, 8, 1, 2, 0, null, null, null));
            this.myFontSizeLabel = jLabel3 = new JLabel();
            jLabel3.setHorizontalAlignment(10);
            this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/IdeBundle").getString("label.font.size"));
            jPanel5.add((Component)jLabel3, new GridConstraints(1, 1, 1, 1, 8, 1, 0, 0, null, null, null));
            this.myFontNameLabel = jLabel2 = new JLabel();
            jLabel2.setHorizontalAlignment(10);
            this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/IdeBundle").getString("label.font.name"));
            jPanel5.add((Component)jLabel2, new GridConstraints(0, 1, 1, 1, 8, 1, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel5.add((Component)spacer, new GridConstraints(0, 0, 2, 1, 0, 1, 0, 1, new Dimension(20, -1), null, null));
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel3.add((Component)jPanel6, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null));
            this.myIDEALafFont = jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/IdeBundle").getString("label.override.laf.font"));
            jPanel6.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myOverrideLAFFonts = jCheckBox9 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox9, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.override.default.laf.fonts"));
            jPanel6.add((Component)jCheckBox9, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myHideIconsInQuickNavigation = jCheckBox8 = new JCheckBox();
            jCheckBox8.setMargin(new Insets(2, 0, 2, 2));
            this.$$$loadButtonText$$$(jCheckBox8, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.show.icons.in.quick.navigation"));
            jPanel3.add((Component)jCheckBox8, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
            this.myTransparencyPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(5, 5, 5, 5), -1, 5, false, false));
            jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 1, 3, 3, 0, null, null, null));
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("messages/IdeBundle").getString("group.transparency"), 0, 0, null, null));
            JLabel jLabel5 = new JLabel();
            this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("messages/IdeBundle").getString("label.transparency.delay.ms"));
            jPanel.add((Component)jLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            JLabel jLabel6 = new JLabel();
            this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("messages/IdeBundle").getString("label.transparency.ratio"));
            jPanel.add((Component)jLabel6, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myEnableAlphaModeCheckBox = jCheckBox7 = new JCheckBox();
            jCheckBox7.setMargin(new Insets(0, 0, 0, 0));
            this.$$$loadButtonText$$$(jCheckBox7, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.use.transparent.mode.for.floating.windows"));
            jPanel.add((Component)jCheckBox7, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
            this.myAlphaModeRatioSlider = jSlider = new JSlider();
            jPanel.add((Component)jSlider, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
            this.myAlphaModeDelayTextField = jTextField = new JTextField();
            jTextField.setHorizontalAlignment(2);
            jTextField.setMargin(new Insets(0, 0, 0, 0));
            jTextField.setText("1500");
            jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 0, 6, 0, null, new Dimension(50, -1), null));
            JPanel jPanel7 = new JPanel();
            jPanel7.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(5, 5, 0, 5), -1, -1, false, false));
            jPanel2.add((Component)jPanel7, new GridConstraints(2, 0, 1, 1, 1, 3, 0, 0, null, null, null));
            jPanel7.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("messages/IdeBundle").getString("group.window.options"), 0, 0, null, null));
            this.myShowToolStripesCheckBox = jCheckBox6 = new JCheckBox();
            jCheckBox6.setMargin(new Insets(2, 2, 2, 2));
            jCheckBox6.setSelected(true);
            this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.show.tool.window.bars"));
            jPanel7.add((Component)jCheckBox6, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myCbDisplayIconsInMenu = jCheckBox5 = new JCheckBox();
            jCheckBox5.setMargin(new Insets(2, 2, 2, 2));
            jCheckBox5.setSelected(true);
            this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.show.icons.in.menu.items"));
            jPanel7.add((Component)jCheckBox5, new GridConstraints(3, 0, 1, 2, 9, 0, 3, 0, null, null, null));
            this.myDisableMnemonics = jCheckBox4 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/KeyMapBundle").getString("disable.mnemonic.in.menu.check.box"));
            jPanel7.add((Component)jCheckBox4, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myWindowShortcutsCheckBox = jCheckBox3 = new JCheckBox();
            jCheckBox3.setMargin(new Insets(2, 2, 2, 2));
            jCheckBox3.setSelected(true);
            this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.show.tool.window.numbers"));
            jPanel7.add((Component)jCheckBox3, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myShowMemoryIndicatorCheckBox = jCheckBox2 = new JCheckBox();
            jCheckBox2.setMargin(new Insets(2, 2, 2, 2));
            jCheckBox2.setSelected(true);
            this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.show.memory.indicator"));
            jPanel7.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myAnimateWindowsCheckBox = jCheckBox = new JCheckBox();
            jCheckBox.setMargin(new Insets(2, 2, 2, 2));
            jCheckBox.setSelected(true);
            this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.animate.windows"));
            jPanel7.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            Spacer spacer2 = new Spacer();
            jPanel2.add((Component)spacer2, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            jLabel4.setLabelFor(jComboBox3);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }

    private static final class MyLafComboBoxRenderer
    extends DefaultListCellRenderer {
        private MyLafComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            UIManager.LookAndFeelInfo laf = (UIManager.LookAndFeelInfo)value;
            return super.getListCellRendererComponent((JList<?>)list, laf == null ? null : laf.getName(), index, isSelected, cellHasFocus);
        }
    }
}

