/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.PsiCopyPasteManager;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.projectView.BaseProjectTreeBuilder;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.GroupByTypeComparator;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.MoveDropTargetListener;
import com.intellij.ide.projectView.impl.ProjectViewImpl;
import com.intellij.ide.projectView.impl.PsiRetriever;
import com.intellij.ide.projectView.impl.nodes.AbstractModuleNode;
import com.intellij.ide.projectView.impl.nodes.AbstractProjectNode;
import com.intellij.ide.projectView.impl.nodes.ModuleGroupNode;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeStructureBase;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionCache;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.InvalidDnDOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractProjectViewPane
implements DataProvider,
Disposable {
    public static ExtensionPointName<AbstractProjectViewPane> EP_NAME;
    protected final Project myProject;
    private Runnable myTreeChangeListener;
    protected DnDAwareTree myTree;
    protected AbstractTreeStructure myTreeStructure;
    private AbstractTreeBuilder myTreeBuilder;
    private final Map<String, TreeState> myReadTreeState = new HashMap();
    private String mySubId;
    @NonNls
    private static final String ELEMENT_SUBPANE = "subPane";
    @NonNls
    private static final String ATTRIBUTE_SUBID = "subId";
    public static final DataFlavor[] FLAVORS;
    private static final Logger LOG;
    private final MyDragSourceListener myDragSourceListener = new MyDragSourceListener();

    protected AbstractProjectViewPane(Project project) {
        this.myProject = project;
    }

    protected final void fireTreeChangeListener() {
        if (this.myTreeChangeListener != null) {
            this.myTreeChangeListener.run();
        }
    }

    public final void setTreeChangeListener(Runnable listener) {
        this.myTreeChangeListener = listener;
    }

    public final void removeTreeChangeListener() {
        this.myTreeChangeListener = null;
    }

    public abstract String getTitle();

    public abstract Icon getIcon();

    @NotNull
    public abstract String getId();

    @Nullable
    public final String getSubId() {
        return this.mySubId;
    }

    public final void setSubId(@Nullable String subId) {
        this.saveExpandedPaths();
        this.mySubId = subId;
    }

    public boolean isInitiallyVisible() {
        return true;
    }

    @NotNull
    public String[] getSubIds() {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/projectView/impl/AbstractProjectViewPane.getSubIds must not return null");
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @NotNull
    public String getPresentableSubIdName(@NotNull String subId) {
        if (subId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/projectView/impl/AbstractProjectViewPane.getPresentableSubIdName must not be null");
        }
        throw new IllegalStateException("should not call");
    }

    public abstract JComponent createComponent();

    public JComponent getComponentToFocus() {
        return this.myTree;
    }

    public void expand(@Nullable Object[] path, boolean requestFocus) {
        if (this.getTreeBuilder() == null || path == null) {
            return;
        }
        this.getTreeBuilder().buildNodeForPath(path);
        DefaultMutableTreeNode node = this.getTreeBuilder().getNodeForPath(path);
        if (node == null) {
            return;
        }
        TreePath treePath = new TreePath(node.getPath());
        this.myTree.expandPath(treePath);
        if (requestFocus) {
            this.myTree.requestFocus();
        }
        TreeUtil.selectPath((JTree)((Object)this.myTree), (TreePath)treePath);
    }

    public void dispose() {
        this.setTreeBuilder(null);
        this.myTree = null;
        this.myTreeStructure = null;
    }

    public abstract ActionCallback updateFromRoot(boolean var1);

    public abstract void select(Object var1, VirtualFile var2, boolean var3);

    public void selectModule(Module module, boolean requestFocus) {
        this.doSelectModuleOrGroup(module, requestFocus);
    }

    private void doSelectModuleOrGroup(final Object toSelect, final boolean requestFocus) {
        ToolWindowManager windowManager = ToolWindowManager.getInstance((Project)this.myProject);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ProjectView projectView = ProjectView.getInstance(AbstractProjectViewPane.this.myProject);
                if (requestFocus) {
                    projectView.changeView(AbstractProjectViewPane.this.getId(), AbstractProjectViewPane.this.getSubId());
                }
                ((BaseProjectTreeBuilder)AbstractProjectViewPane.this.getTreeBuilder()).selectInWidth(toSelect, requestFocus, new Condition<AbstractTreeNode>(){

                    public boolean value(AbstractTreeNode node) {
                        return node instanceof AbstractModuleNode || node instanceof ModuleGroupNode || node instanceof AbstractProjectNode;
                    }
                });
            }
        };
        if (requestFocus) {
            windowManager.getToolWindow(ToolWindowId.PROJECT_VIEW).activate(runnable);
        } else {
            runnable.run();
        }
    }

    public void selectModuleGroup(ModuleGroup moduleGroup, boolean requestFocus) {
        this.doSelectModuleOrGroup(moduleGroup, requestFocus);
    }

    public TreePath[] getSelectionPaths() {
        return this.myTree == null ? null : this.myTree.getSelectionPaths();
    }

    public void addToolbarActions(DefaultActionGroup actionGroup) {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    protected <T extends NodeDescriptor> List<T> getSelectedNodes(Class<T> nodeClass) {
        List list;
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/ide/projectView/impl/AbstractProjectViewPane.getSelectedNodes must not return null");
            return list;
        }
        ArrayList result = new ArrayList();
        for (TreePath path : paths) {
            DefaultMutableTreeNode node;
            Object userObject;
            Object lastPathComponent = path.getLastPathComponent();
            if (!(lastPathComponent instanceof DefaultMutableTreeNode) || (userObject = (node = (DefaultMutableTreeNode)lastPathComponent).getUserObject()) == null || !ReflectionCache.isAssignable(nodeClass, userObject.getClass())) continue;
            result.add((NodeDescriptor)userObject);
        }
        list = result;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/ide/projectView/impl/AbstractProjectViewPane.getSelectedNodes must not return null");
    }

    public Object getData(String dataId) {
        if (PlatformDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            TreePath[] paths = this.getSelectionPaths();
            if (paths == null) {
                return null;
            }
            ArrayList<Navigatable> navigatables = new ArrayList<Navigatable>();
            for (TreePath path : paths) {
                Object lastPathComponent = path.getLastPathComponent();
                if (!(lastPathComponent instanceof DefaultMutableTreeNode)) continue;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)lastPathComponent;
                Object userObject = node.getUserObject();
                if (userObject instanceof Navigatable) {
                    navigatables.add((Navigatable)userObject);
                    continue;
                }
                if (!(node instanceof Navigatable)) continue;
                navigatables.add((Navigatable)node);
            }
            if (navigatables.isEmpty()) {
                return null;
            }
            return navigatables.toArray(new Navigatable[navigatables.size()]);
        }
        if (this.myTreeStructure instanceof AbstractTreeStructureBase) {
            return ((AbstractTreeStructureBase)this.myTreeStructure).getDataFromProviders(this.getSelectedNodes(AbstractTreeNode.class), dataId);
        }
        return null;
    }

    public abstract int getWeight();

    public abstract SelectInTarget createSelectInTarget();

    public final TreePath getSelectedPath() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths != null && paths.length == 1) {
            return paths[0];
        }
        return null;
    }

    public final NodeDescriptor getSelectedDescriptor() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node == null) {
            return null;
        }
        Object userObject = node.getUserObject();
        if (userObject instanceof NodeDescriptor) {
            return (NodeDescriptor)userObject;
        }
        return null;
    }

    public final DefaultMutableTreeNode getSelectedNode() {
        TreePath path = this.getSelectedPath();
        if (path == null) {
            return null;
        }
        Object lastPathComponent = path.getLastPathComponent();
        if (!(lastPathComponent instanceof DefaultMutableTreeNode)) {
            return null;
        }
        return (DefaultMutableTreeNode)lastPathComponent;
    }

    public final Object getSelectedElement() {
        Object[] elements = this.getSelectedElements();
        return elements.length == 1 ? elements[0] : null;
    }

    @NotNull
    public final PsiElement[] getSelectedPSIElements() {
        ArrayList<PsiElement> psiElements = new ArrayList<PsiElement>();
        for (Object element : this.getSelectedElements()) {
            PsiElement psiElement = this.getPSIElement(element);
            if (psiElement == null) continue;
            psiElements.add(psiElement);
        }
        PsiElement[] psiElementArray = psiElements.toArray(new PsiElement[psiElements.size()]);
        if (psiElementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/projectView/impl/AbstractProjectViewPane.getSelectedPSIElements must not return null");
        }
        return psiElementArray;
    }

    @Nullable
    protected PsiElement getPSIElement(@Nullable Object element) {
        PsiElement psiElement;
        if (element instanceof PsiElement && (psiElement = (PsiElement)element).isValid()) {
            return psiElement;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final Object[] getSelectedElements() {
        Object[] objectArray;
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            objectArray = PsiElement.EMPTY_ARRAY;
            if (PsiElement.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/ide/projectView/impl/AbstractProjectViewPane.getSelectedElements must not return null");
            return objectArray;
        }
        ArrayList<Object> list = new ArrayList<Object>(paths.length);
        for (TreePath path : paths) {
            Object element;
            Object lastPathComponent = path.getLastPathComponent();
            if (!(lastPathComponent instanceof TreeNode) || (element = this.getElement((TreeNode)lastPathComponent)) == null) continue;
            list.add(element);
        }
        objectArray = ArrayUtil.toObjectArray(list);
        if (objectArray != null) return objectArray;
        throw new IllegalStateException("@NotNull method com/intellij/ide/projectView/impl/AbstractProjectViewPane.getSelectedElements must not return null");
    }

    @Nullable
    private Object getElement(@Nullable TreeNode treeNode) {
        if (treeNode instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)treeNode;
            return this.exhumeElementFromNode(node);
        }
        return null;
    }

    private TreeNode[] getSelectedTreeNodes() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return null;
        }
        ArrayList<TreeNode> result = new ArrayList<TreeNode>();
        for (TreePath path : paths) {
            Object lastPathComponent = path.getLastPathComponent();
            if (!(lastPathComponent instanceof DefaultMutableTreeNode)) continue;
            result.add((TreeNode)lastPathComponent);
        }
        return result.toArray(new TreeNode[result.size()]);
    }

    protected Object exhumeElementFromNode(DefaultMutableTreeNode node) {
        return AbstractProjectViewPane.extractUserObject(node);
    }

    public static Object extractUserObject(DefaultMutableTreeNode node) {
        Object userObject = node.getUserObject();
        Object element = null;
        if (userObject instanceof AbstractTreeNode) {
            AbstractTreeNode descriptor = (AbstractTreeNode)userObject;
            element = descriptor.getValue();
        } else if (userObject instanceof NodeDescriptor) {
            NodeDescriptor descriptor = (NodeDescriptor)userObject;
            element = descriptor.getElement();
            if (element instanceof AbstractTreeNode) {
                element = ((AbstractTreeNode)element).getValue();
            }
        } else if (userObject != null) {
            element = userObject;
        }
        return element;
    }

    public AbstractTreeBuilder getTreeBuilder() {
        return this.myTreeBuilder;
    }

    public void readExternal(Element element) throws InvalidDataException {
        List subPanes = element.getChildren(ELEMENT_SUBPANE);
        for (Element subPane : subPanes) {
            String subId = subPane.getAttributeValue(ATTRIBUTE_SUBID);
            TreeState treeState = new TreeState();
            treeState.readExternal(subPane);
            this.myReadTreeState.put(subId, treeState);
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        this.saveExpandedPaths();
        for (String subId : this.myReadTreeState.keySet()) {
            TreeState treeState = this.myReadTreeState.get(subId);
            Element subPane = new Element(ELEMENT_SUBPANE);
            if (subId != null) {
                subPane.setAttribute(ATTRIBUTE_SUBID, subId);
            }
            treeState.writeExternal(subPane);
            element.addContent(subPane);
        }
    }

    void saveExpandedPaths() {
        if (this.myTree != null) {
            TreeState treeState = TreeState.createOn((JTree)((Object)this.myTree));
            this.myReadTreeState.put(this.getSubId(), treeState);
        }
    }

    public final void restoreExpandedPaths() {
        TreeState treeState = this.myReadTreeState.get(this.getSubId());
        if (treeState != null) {
            treeState.applyTo((JTree)((Object)this.myTree));
        }
    }

    public void installComparator() {
        ProjectView projectView = ProjectView.getInstance(this.myProject);
        this.getTreeBuilder().setNodeDescriptorComparator((Comparator)new GroupByTypeComparator(projectView, this.getId()));
    }

    public JTree getTree() {
        return this.myTree;
    }

    public PsiDirectory[] getSelectedDirectories() {
        PsiElement[] elements = this.getSelectedPSIElements();
        if (elements.length == 1) {
            PsiElement element = elements[0];
            if (element instanceof PsiDirectory) {
                return new PsiDirectory[]{(PsiDirectory)element};
            }
            if (element instanceof PsiDirectoryContainer) {
                return ((PsiDirectoryContainer)element).getDirectories();
            }
            PsiFile containingFile = element.getContainingFile();
            if (containingFile != null) {
                PsiDirectory[] psiDirectoryArray;
                PsiDirectory psiDirectory = containingFile.getContainingDirectory();
                if (psiDirectory != null) {
                    PsiDirectory[] psiDirectoryArray2 = new PsiDirectory[1];
                    psiDirectoryArray = psiDirectoryArray2;
                    psiDirectoryArray2[0] = psiDirectory;
                } else {
                    psiDirectoryArray = PsiDirectory.EMPTY_ARRAY;
                }
                return psiDirectoryArray;
            }
        } else {
            DefaultMutableTreeNode selectedNode = this.getSelectedNode();
            if (selectedNode != null) {
                return this.getSelectedDirectoriesInAmbiguousCase(selectedNode);
            }
        }
        return PsiDirectory.EMPTY_ARRAY;
    }

    protected PsiDirectory[] getSelectedDirectoriesInAmbiguousCase(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/projectView/impl/AbstractProjectViewPane.getSelectedDirectoriesInAmbiguousCase must not be null");
        }
        Object userObject = node.getUserObject();
        if (userObject instanceof AbstractModuleNode) {
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)((Module)((AbstractModuleNode)((Object)userObject)).getValue()));
            VirtualFile[] sourceRoots = moduleRootManager.getSourceRoots();
            ArrayList<PsiDirectory> dirs = new ArrayList<PsiDirectory>(sourceRoots.length);
            PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
            for (VirtualFile sourceRoot : sourceRoots) {
                PsiDirectory directory = psiManager.findDirectory(sourceRoot);
                if (directory == null) continue;
                dirs.add(directory);
            }
            return dirs.toArray(new PsiDirectory[dirs.size()]);
        }
        return PsiDirectory.EMPTY_ARRAY;
    }

    protected void enableDnD() {
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer((Component)((Object)this.myTree), 3, new MyDragGestureListener());
            new DropTarget((Component)((Object)this.myTree), new MoveDropTargetListener(new PsiRetriever(){

                @Override
                @Nullable
                public PsiElement getPsiElement(@Nullable TreeNode node) {
                    return AbstractProjectViewPane.this.getPSIElement(AbstractProjectViewPane.this.getElement(node));
                }
            }, (JTree)((Object)this.myTree), this.myProject, FLAVORS[0]));
            this.myTree.enableDnd(this);
        }
    }

    public void setTreeBuilder(AbstractTreeBuilder treeBuilder) {
        if (treeBuilder != null) {
            Disposer.register((Disposable)this, (Disposable)treeBuilder);
        }
        this.myTreeBuilder = treeBuilder;
    }

    static {
        DataFlavor[] flavors;
        EP_NAME = ExtensionPointName.create((String)"com.intellij.projectViewPane");
        LOG = Logger.getInstance((String)"com.intellij.ide.projectView.ProjectViewImpl");
        try {
            Class<MyTransferable> aClass = MyTransferable.class;
            flavors = new DataFlavor[]{new DataFlavor("application/x-java-jvm-local-objectref;class=" + aClass.getName(), "AbstractTransferable", aClass.getClassLoader())};
        }
        catch (ClassNotFoundException e) {
            LOG.error((Throwable)e);
            flavors = new DataFlavor[]{};
        }
        FLAVORS = flavors;
    }

    private static class MyDragSourceListener
    implements DragSourceListener {
        private MyDragSourceListener() {
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
            dsde.getDragSourceContext().setCursor(null);
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
            dsde.getDragSourceContext().setCursor(null);
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
        }
    }

    private class MyDragGestureListener
    implements DragGestureListener {
        private MyDragGestureListener() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            if ((dge.getDragAction() & 3) == 0) {
                return;
            }
            DataContext dataContext = DataManager.getInstance().getDataContext();
            ProjectView projectView = (ProjectView)ProjectViewImpl.DATA_KEY.getData(dataContext);
            if (projectView == null) {
                return;
            }
            AbstractProjectViewPane currentPane = projectView.getCurrentProjectViewPane();
            final TreeNode[] nodes = currentPane.getSelectedTreeNodes();
            if (nodes != null) {
                Object[] elements = currentPane.getSelectedElements();
                final PsiElement[] psiElements = currentPane.getSelectedPSIElements();
                try {
                    TransferableWrapper transferableWrapper = new TransferableWrapper(){

                        @Override
                        public TreeNode[] getTreeNodes() {
                            return nodes;
                        }

                        @Override
                        public PsiElement[] getPsiElements() {
                            return psiElements;
                        }
                    };
                    if (psiElements != null && psiElements.length > 0 || this.canDragElements(elements)) {
                        dge.startDrag(DragSource.DefaultMoveNoDrop, new MyTransferable(transferableWrapper), AbstractProjectViewPane.this.myDragSourceListener);
                    }
                }
                catch (InvalidDnDOperationException idoe) {
                    // empty catch block
                }
            }
        }

        private boolean canDragElements(Object[] elements) {
            for (Object element : elements) {
                if (!(element instanceof Module)) continue;
                return true;
            }
            return false;
        }
    }

    public static interface TransferableWrapper {
        public TreeNode[] getTreeNodes();

        @Nullable
        public PsiElement[] getPsiElements();
    }

    private static class MyTransferable
    implements Transferable {
        private final Object myTransferable;

        public MyTransferable(Object transferable) {
            this.myTransferable = transferable;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] flavors = new DataFlavor[]{FLAVORS[0], DataFlavor.javaFileListFlavor};
            return flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            Object[] flavors = this.getTransferDataFlavors();
            return ArrayUtil.find((Object[])flavors, (Object)flavor) != -1;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) {
            if (flavor == DataFlavor.javaFileListFlavor) {
                TransferableWrapper wrapper = (TransferableWrapper)this.myTransferable;
                return PsiCopyPasteManager.asFileList(wrapper.getPsiElements());
            }
            return this.myTransferable;
        }
    }
}

