/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView;

import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiModificationTracker;
import javax.swing.tree.DefaultMutableTreeNode;

public abstract class ProjectViewPsiTreeChangeListener
extends PsiTreeChangeAdapter {
    private final FileTypeManager myFileTypeManager = FileTypeManager.getInstance();
    private final PsiModificationTracker myModificationTracker;
    private long myOutOfCodeBlockModificationCount;

    protected ProjectViewPsiTreeChangeListener(Project project) {
        this.myModificationTracker = PsiManager.getInstance((Project)project).getModificationTracker();
        this.myOutOfCodeBlockModificationCount = this.myModificationTracker.getOutOfCodeBlockModificationCount();
    }

    protected abstract AbstractTreeUpdater getUpdater();

    protected abstract boolean isFlattenPackages();

    protected abstract DefaultMutableTreeNode getRootNode();

    public final void childRemoved(PsiTreeChangeEvent event) {
        PsiElement child = event.getOldChild();
        if (child instanceof PsiWhiteSpace) {
            return;
        }
        this.childrenChanged(event.getParent(), true);
    }

    public final void childAdded(PsiTreeChangeEvent event) {
        PsiElement child = event.getNewChild();
        if (child instanceof PsiWhiteSpace) {
            return;
        }
        this.childrenChanged(event.getParent(), true);
    }

    public final void childReplaced(PsiTreeChangeEvent event) {
        PsiElement oldChild = event.getOldChild();
        PsiElement newChild = event.getNewChild();
        if (oldChild instanceof PsiWhiteSpace && newChild instanceof PsiWhiteSpace) {
            return;
        }
        this.childrenChanged(event.getParent(), true);
    }

    public final void childMoved(PsiTreeChangeEvent event) {
        this.childrenChanged(event.getOldParent(), false);
        this.childrenChanged(event.getNewParent(), true);
    }

    public final void childrenChanged(PsiTreeChangeEvent event) {
        this.childrenChanged(event.getParent(), true);
    }

    protected void childrenChanged(PsiElement parent, boolean stopProcessingForThisModificationCount) {
        VirtualFile virtualFile;
        if (parent instanceof PsiDirectory && this.isFlattenPackages()) {
            this.getUpdater().addSubtreeToUpdate(this.getRootNode());
            return;
        }
        long newModificationCount = this.myModificationTracker.getOutOfCodeBlockModificationCount();
        if (newModificationCount == this.myOutOfCodeBlockModificationCount) {
            return;
        }
        if (stopProcessingForThisModificationCount) {
            this.myOutOfCodeBlockModificationCount = newModificationCount;
        }
        while (!(parent == null || parent instanceof PsiFile && (virtualFile = ((PsiFile)parent).getVirtualFile()) != null && this.myFileTypeManager.getFileTypeByFile(virtualFile) != FileTypes.PLAIN_TEXT && (parent = ((PsiFile)parent).getContainingDirectory()) == null || this.getUpdater().addSubtreeToUpdateByElement((Object)parent) || parent instanceof PsiFile || parent instanceof PsiDirectory)) {
            parent = parent.getParent();
        }
    }

    public void propertyChanged(PsiTreeChangeEvent event) {
        String propertyName = event.getPropertyName();
        PsiElement element = event.getElement();
        DefaultMutableTreeNode rootNode = this.getRootNode();
        AbstractTreeUpdater updater = this.getUpdater();
        if (propertyName.equals("roots")) {
            updater.addSubtreeToUpdate(rootNode);
        } else if (propertyName.equals("writable")) {
            if (!updater.addSubtreeToUpdateByElement((Object)element) && element instanceof PsiFile && ((PsiFile)element).getFileType() == StdFileTypes.JAVA) {
                updater.addSubtreeToUpdateByElement((Object)((PsiFile)element).getContainingDirectory());
            }
        } else if (propertyName.equals("fileName") || propertyName.equals("directoryName")) {
            if (element instanceof PsiDirectory && this.isFlattenPackages()) {
                updater.addSubtreeToUpdate(rootNode);
                return;
            }
            updater.addSubtreeToUpdateByElement((Object)element);
        } else if (propertyName.equals("propFileTypes")) {
            updater.addSubtreeToUpdate(rootNode);
        }
    }
}

