/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jdom.Element;

public class TableColumnsProportionData
implements JDOMExternalizable {
    public String myProportion;

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
    }

    public void restoreProportion(JTable table) {
        if (this.myProportion != null) {
            TableColumnModel model = table.getColumnModel();
            String[] widths = this.myProportion.split(":");
            for (int i = 0; i < widths.length; ++i) {
                TableColumn column = model.getColumn(i);
                int width = Integer.parseInt(widths[i]);
                column.setWidth(width);
                column.setPreferredWidth(width);
            }
        }
    }

    public void saveProportion(JTable table) {
        this.myProportion = "";
        TableColumnModel model = table.getColumnModel();
        for (int i = 0; i < model.getColumnCount(); ++i) {
            this.myProportion = this.myProportion + ":" + model.getColumn(i).getWidth();
        }
        if (this.myProportion.length() > 0) {
            this.myProportion = this.myProportion.substring(1);
        }
    }
}

