/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginManagerUISettings;
import com.intellij.ide.plugins.SortableProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import org.jetbrains.annotations.Nullable;

public class PluginManagerConfigurable
extends BaseConfigurable
implements SearchableConfigurable {
    public boolean EXPANDED = false;
    public String FIND = "";
    public boolean TREE_VIEW = false;
    private PluginManagerMain myPluginManagerMain;
    private final PluginManagerUISettings myUISettings;

    public static PluginManagerConfigurable getInstance() {
        return (PluginManagerConfigurable)ShowSettingsUtil.getInstance().findApplicationConfigurable(PluginManagerConfigurable.class);
    }

    public PluginManagerConfigurable(PluginManagerUISettings UISettings2) {
        this.myUISettings = UISettings2;
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"title.plugins", (Object[])new Object[0]);
    }

    public void reset() {
        this.myPluginManagerMain.reset();
        this.myUISettings.getSplitterProportionsData().restoreSplitterProportions((Component)this.myPluginManagerMain.getMainPanel());
        this.myUISettings.getAvailableTableProportions().restoreProportion((JTable)((Object)this.myPluginManagerMain.getAvailablePluginsTable()));
        this.myUISettings.getInstalledTableProportions().restoreProportion((JTable)((Object)this.myPluginManagerMain.getInstalledPluginTable()));
    }

    public String getHelpTopic() {
        return "preferences.pluginManager";
    }

    public void disposeUIResources() {
        if (this.myPluginManagerMain != null) {
            this.myUISettings.getSplitterProportionsData().saveSplitterProportions((Component)this.myPluginManagerMain.getMainPanel());
            this.myUISettings.getAvailableTableProportions().saveProportion((JTable)((Object)this.myPluginManagerMain.getAvailablePluginsTable()));
            this.myUISettings.getInstalledTableProportions().saveProportion((JTable)((Object)this.myPluginManagerMain.getInstalledPluginTable()));
            Disposer.dispose((Disposable)this.myPluginManagerMain);
            this.myPluginManagerMain = null;
        }
    }

    public JComponent createComponent() {
        if (this.myPluginManagerMain == null) {
            this.myPluginManagerMain = new PluginManagerMain(new MyInstalledProvider(), new MyAvailableProvider());
        }
        return this.myPluginManagerMain.getMainPanel();
    }

    public void apply() throws ConfigurationException {
        this.myPluginManagerMain.apply();
        if (this.myPluginManagerMain.isRequireShutdown()) {
            ApplicationEx app = ApplicationManagerEx.getApplicationEx();
            if (app.isRestartCapable()) {
                if (Messages.showYesNoDialog((String)IdeBundle.message((String)"message.idea.restart.required", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()}), (String)IdeBundle.message((String)"title.plugins", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) {
                    app.restart();
                } else {
                    this.myPluginManagerMain.ignoreChanges();
                }
            } else if (Messages.showYesNoDialog((String)IdeBundle.message((String)"message.idea.shutdown.required", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()}), (String)IdeBundle.message((String)"title.plugins", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) {
                app.exit(true);
            } else {
                this.myPluginManagerMain.ignoreChanges();
            }
        }
    }

    public boolean isModified() {
        return this.myPluginManagerMain != null && this.myPluginManagerMain.isModified();
    }

    public Icon getIcon() {
        return IconLoader.getIcon((String)"/general/pluginManager.png");
    }

    public String getId() {
        return this.getHelpTopic();
    }

    @Nullable
    public Runnable enableSearch(final String option) {
        return new Runnable(){

            @Override
            public void run() {
                PluginManagerConfigurable.this.myPluginManagerMain.filter(option);
            }
        };
    }

    public void select(IdeaPluginDescriptor ... descriptors) {
        this.myPluginManagerMain.select(descriptors);
    }

    private class MyAvailableProvider
    implements SortableProvider {
        private MyAvailableProvider() {
        }

        @Override
        public int getSortOrder() {
            return ((PluginManagerConfigurable)PluginManagerConfigurable.this).myUISettings.AVAILABLE_SORT_COLUMN_ORDER;
        }

        @Override
        public int getSortColumn() {
            return ((PluginManagerConfigurable)PluginManagerConfigurable.this).myUISettings.AVAILABLE_SORT_COLUMN;
        }

        @Override
        public void setSortOrder(int sortOrder) {
            ((PluginManagerConfigurable)PluginManagerConfigurable.this).myUISettings.AVAILABLE_SORT_COLUMN_ORDER = sortOrder;
        }

        @Override
        public void setSortColumn(int sortColumn) {
            ((PluginManagerConfigurable)PluginManagerConfigurable.this).myUISettings.AVAILABLE_SORT_COLUMN = sortColumn;
        }
    }

    private class MyInstalledProvider
    implements SortableProvider {
        private MyInstalledProvider() {
        }

        @Override
        public int getSortOrder() {
            return ((PluginManagerConfigurable)PluginManagerConfigurable.this).myUISettings.INSTALLED_SORT_COLUMN_ORDER;
        }

        @Override
        public int getSortColumn() {
            return ((PluginManagerConfigurable)PluginManagerConfigurable.this).myUISettings.INSTALLED_SORT_COLUMN;
        }

        @Override
        public void setSortOrder(int sortOrder) {
            ((PluginManagerConfigurable)PluginManagerConfigurable.this).myUISettings.INSTALLED_SORT_COLUMN_ORDER = sortOrder;
        }

        @Override
        public void setSortColumn(int sortColumn) {
            ((PluginManagerConfigurable)PluginManagerConfigurable.this).myUISettings.INSTALLED_SORT_COLUMN = sortColumn;
        }
    }
}

