/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.startup.StartupActionScriptManager;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.ui.GuiUtils;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public class PluginInstaller {
    private PluginInstaller() {
    }

    public static boolean prepareToInstall(List<PluginNode> plugins) {
        ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
        ArrayList<PluginId> pluginIds = new ArrayList<PluginId>();
        for (PluginNode pluginNode : plugins) {
            pluginIds.add(pluginNode.getPluginId());
        }
        boolean result = false;
        for (final PluginNode pluginNode : plugins) {
            if (pi != null) {
                pi.setText(pluginNode.getName());
            }
            try {
                result |= PluginInstaller.prepareToInstall(pluginNode, pluginIds);
            }
            catch (IOException e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Messages.showErrorDialog((String)(pluginNode.getName() + ": " + e.getMessage()), (String)CommonBundle.message((String)"title.error", (Object[])new Object[0]));
                    }
                });
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean prepareToInstall(PluginNode pluginNode, List<PluginId> pluginIds) throws IOException {
        if (pluginNode.getDepends() != null && pluginNode.getDepends().size() > 0) {
            Object[] optionalDependentPluginIds = pluginNode.getOptionalDependentPluginIds();
            final ArrayList<PluginNode> depends = new ArrayList<PluginNode>();
            final ArrayList<PluginNode> optionalDeps = new ArrayList<PluginNode>();
            for (int i = 0; i < pluginNode.getDepends().size(); ++i) {
                PluginId depPluginId = pluginNode.getDepends().get(i);
                if (PluginManager.isPluginInstalled((PluginId)depPluginId) || PluginManager.isModuleDependency((PluginId)depPluginId) || pluginIds != null && pluginIds.contains(depPluginId)) continue;
                PluginNode depPlugin = new PluginNode(depPluginId);
                depPlugin.setSize("-1");
                depPlugin.setName(depPluginId.getIdString());
                if (optionalDependentPluginIds != null && Arrays.binarySearch(optionalDependentPluginIds, depPluginId) != -1) {
                    optionalDeps.add(depPlugin);
                    continue;
                }
                depends.add(depPlugin);
            }
            if (depends.size() > 0) {
                final boolean[] proceed = new boolean[1];
                final StringBuffer buf = new StringBuffer();
                for (PluginNode depend : depends) {
                    buf.append(depend.getName()).append(",");
                }
                try {
                    GuiUtils.runOrInvokeAndWait((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            proceed[0] = Messages.showYesNoDialog((String)IdeBundle.message((String)"plugin.manager.dependencies.detected.message", (Object[])new Object[]{depends.size(), buf.substring(0, buf.length() - 1)}), (String)IdeBundle.message((String)"plugin.manager.dependencies.detected.title", (Object[])new Object[0]), (Icon)Messages.getWarningIcon()) == 0;
                        }
                    });
                }
                catch (Exception e) {
                    return false;
                }
                if (proceed[0]) {
                    if (!PluginInstaller.prepareToInstall(depends)) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            if (optionalDeps.size() > 0) {
                final StringBuffer buf = new StringBuffer();
                for (PluginNode depend : optionalDeps) {
                    buf.append(depend.getName()).append(",");
                }
                final boolean[] proceed = new boolean[1];
                try {
                    GuiUtils.runOrInvokeAndWait((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            proceed[0] = Messages.showYesNoDialog((String)IdeBundle.message((String)"plugin.manager.optional.dependencies.detected.message", (Object[])new Object[]{optionalDeps.size(), buf.substring(0, buf.length() - 1)}), (String)IdeBundle.message((String)"plugin.manager.dependencies.detected.title", (Object[])new Object[0]), (Icon)Messages.getWarningIcon()) == 0;
                        }
                    });
                }
                catch (Exception e) {
                    return false;
                }
                if (proceed[0] && !PluginInstaller.prepareToInstall(optionalDeps)) {
                    return false;
                }
            }
        }
        Object object = PluginManager.lock;
        synchronized (object) {
            BuildNumber buildNumber = ApplicationInfo.getInstance().getBuild();
            String url = RepositoryHelper.DOWNLOAD_URL + URLEncoder.encode(pluginNode.getPluginId().getIdString(), "UTF8") + "&build=" + buildNumber.asString();
            PluginDownloader downloader = new PluginDownloader(pluginNode.getPluginId().getIdString(), url, null, null, pluginNode.getName());
            if (downloader.prepareToInstall(ProgressManager.getInstance().getProgressIndicator())) {
                downloader.install();
                pluginNode.setStatus(5);
            }
        }
        return true;
    }

    public static boolean prepareToInstall(PluginNode pluginNode) throws IOException {
        return PluginInstaller.prepareToInstall(pluginNode, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prepareToUninstall(PluginId pluginId) throws IOException {
        Object object = PluginManager.lock;
        synchronized (object) {
            if (PluginManager.isPluginInstalled((PluginId)pluginId)) {
                IdeaPluginDescriptor pluginDescriptor = PluginManager.getPlugin((PluginId)pluginId);
                StartupActionScriptManager.DeleteCommand deleteOld = new StartupActionScriptManager.DeleteCommand(pluginDescriptor.getPath());
                StartupActionScriptManager.addActionCommand((StartupActionScriptManager.ActionCommand)deleteOld);
            }
        }
    }
}

