/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.ide.navigationToolbar.NavBarModelExtension;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nullable;

public class DefaultNavBarExtension
implements NavBarModelExtension {
    @Override
    @Nullable
    public String getPresentableText(Object object) {
        if (object instanceof Project) {
            return ((Project)object).getName();
        }
        if (object instanceof Module) {
            return ((Module)object).getName();
        }
        if (object instanceof PsiFile) {
            return ((PsiFile)object).getName();
        }
        if (object instanceof PsiDirectory) {
            return ((PsiDirectory)object).getVirtualFile().getName();
        }
        if (object instanceof JdkOrderEntry) {
            return ((JdkOrderEntry)object).getJdkName();
        }
        if (object instanceof LibraryOrderEntry) {
            String libraryName = ((LibraryOrderEntry)object).getLibraryName();
            return libraryName != null ? libraryName : AnalysisScopeBundle.message((String)"package.dependencies.library.node.text", (Object[])new Object[0]);
        }
        if (object instanceof ModuleOrderEntry) {
            ModuleOrderEntry moduleOrderEntry = (ModuleOrderEntry)object;
            return moduleOrderEntry.getModuleName();
        }
        return null;
    }

    @Override
    @Nullable
    public PsiElement getParent(PsiElement object) {
        return null;
    }

    @Override
    public PsiElement adjustElement(PsiElement psiElement) {
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile != null) {
            return containingFile;
        }
        return psiElement;
    }
}

