/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl.dataRules;

import com.intellij.ide.impl.dataRules.GetDataRule;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.rules.UsageInFile;
import com.intellij.usages.rules.UsageInFiles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class VirtualFileArrayRule
implements GetDataRule {
    @Override
    public Object getData(DataProvider dataProvider) {
        Project project = (Project)PlatformDataKeys.PROJECT_CONTEXT.getData(dataProvider);
        if (project != null && !project.isDisposed()) {
            return ProjectRootManager.getInstance((Project)project).getContentRoots();
        }
        Module[] selectedModules = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataProvider);
        if (selectedModules != null && selectedModules.length > 0) {
            return VirtualFileArrayRule.getFilesFromModules(selectedModules);
        }
        Module selectedModule = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataProvider);
        if (selectedModule != null && !selectedModule.isDisposed()) {
            return ModuleRootManager.getInstance((Module)selectedModule).getContentRoots();
        }
        PsiElement[] psiElements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataProvider);
        if (psiElements != null && psiElements.length != 0) {
            return VirtualFileArrayRule.getFilesFromPsiElements(psiElements);
        }
        VirtualFile vFile = (VirtualFile)PlatformDataKeys.VIRTUAL_FILE.getData(dataProvider);
        if (vFile != null) {
            return new VirtualFile[]{vFile};
        }
        PsiFile psiFile = (PsiFile)LangDataKeys.PSI_FILE.getData(dataProvider);
        if (psiFile != null && psiFile.getVirtualFile() != null) {
            return new VirtualFile[]{psiFile.getVirtualFile()};
        }
        PsiElement elem = (PsiElement)LangDataKeys.PSI_ELEMENT.getData(dataProvider);
        if (elem != null) {
            return VirtualFileArrayRule.getFilesFromPsiElement(elem);
        }
        Usage[] usages = (Usage[])UsageView.USAGES_KEY.getData(dataProvider);
        UsageTarget[] usageTargets = (UsageTarget[])UsageView.USAGE_TARGETS_KEY.getData(dataProvider);
        if (usages != null || usageTargets != null) {
            return VirtualFileArrayRule.getFilesFromUsages(usages, usageTargets);
        }
        return null;
    }

    private static VirtualFile[] getFilesFromUsages(Usage[] usages, UsageTarget[] usageTargets) {
        HashSet<VirtualFile> result = new HashSet<VirtualFile>();
        if (usages != null) {
            for (Usage usage : usages) {
                if (!usage.isValid()) continue;
                if (usage instanceof UsageInFile) {
                    UsageInFile usageInFile = (UsageInFile)usage;
                    result.add(usageInFile.getFile());
                }
                if (!(usage instanceof UsageInFiles)) continue;
                UsageInFiles usageInFiles = (UsageInFiles)usage;
                result.addAll(Arrays.asList(usageInFiles.getFiles()));
            }
        }
        if (usageTargets != null) {
            for (Usage usage : usageTargets) {
                VirtualFile[] files;
                if (!usage.isValid() || (files = usage.getFiles()) == null) continue;
                result.addAll(Arrays.asList(files));
            }
        }
        return VfsUtil.toVirtualFileArray(result);
    }

    private static Object getFilesFromPsiElement(PsiElement elem) {
        VirtualFile[] virtualFileArray;
        if (elem instanceof PsiFile) {
            VirtualFile[] virtualFileArray2;
            VirtualFile virtualFile = ((PsiFile)elem).getVirtualFile();
            if (virtualFile != null) {
                VirtualFile[] virtualFileArray3 = new VirtualFile[1];
                virtualFileArray2 = virtualFileArray3;
                virtualFileArray3[0] = virtualFile;
            } else {
                virtualFileArray2 = null;
            }
            return virtualFileArray2;
        }
        if (elem instanceof PsiDirectory) {
            return new VirtualFile[]{((PsiDirectory)elem).getVirtualFile()};
        }
        PsiFile file = elem.getContainingFile();
        if (file != null && file.getVirtualFile() != null) {
            VirtualFile[] virtualFileArray4 = new VirtualFile[1];
            virtualFileArray = virtualFileArray4;
            virtualFileArray4[0] = file.getVirtualFile();
        } else {
            virtualFileArray = null;
        }
        return virtualFileArray;
    }

    private static Object getFilesFromPsiElements(PsiElement[] psiElements) {
        HashSet<VirtualFile> files = new HashSet<VirtualFile>();
        for (PsiElement elem : psiElements) {
            VirtualFile virtualFile;
            if (elem instanceof PsiDirectory) {
                files.add(((PsiDirectory)elem).getVirtualFile());
                continue;
            }
            if (elem instanceof PsiFile) {
                VirtualFile virtualFile2 = ((PsiFile)elem).getVirtualFile();
                if (virtualFile2 == null) continue;
                files.add(virtualFile2);
                continue;
            }
            if (elem instanceof PsiDirectoryContainer) {
                PsiDirectory[] dirs;
                for (PsiDirectory dir : dirs = ((PsiDirectoryContainer)elem).getDirectories()) {
                    files.add(dir.getVirtualFile());
                }
                continue;
            }
            PsiFile file = elem.getContainingFile();
            if (file == null || (virtualFile = file.getVirtualFile()) == null) continue;
            files.add(virtualFile);
        }
        VirtualFile[] result = VfsUtil.toVirtualFileArray(files);
        files.clear();
        return result;
    }

    private static Object getFilesFromModules(Module[] selectedModules) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (Module selectedModule : selectedModules) {
            result.addAll(Arrays.asList(ModuleRootManager.getInstance((Module)selectedModule).getContentRoots()));
        }
        return VfsUtil.toVirtualFileArray(result);
    }
}

