/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter.custom.tokens;

import com.intellij.ide.highlighter.custom.tokens.BaseTokenParser;
import com.intellij.psi.CustomHighlighterTokenType;

public final class NumberParser
extends BaseTokenParser {
    private final String mySuffices;
    private final boolean myIgnoreCase;

    public NumberParser(String suffices, boolean ignoreCase) {
        this.myIgnoreCase = ignoreCase;
        this.mySuffices = !this.myIgnoreCase ? suffices : suffices.toLowerCase().concat(suffices.toUpperCase());
    }

    @Override
    public boolean hasToken(int position) {
        int start;
        char startChar;
        if (!NumberParser.isDigit(startChar = this.myBuffer.charAt(start = position++))) {
            return false;
        }
        while (position < this.myEndOffset && NumberParser.isDigit(this.myBuffer.charAt(position))) {
            ++position;
        }
        if (position < this.myEndOffset && this.myBuffer.charAt(position) == '.') {
            int dotPosition = position++;
            if (position < this.myEndOffset && !NumberParser.isDigit(this.myBuffer.charAt(position))) {
                position = dotPosition;
            } else {
                char finalChar;
                while (position < this.myEndOffset && NumberParser.isDigit(this.myBuffer.charAt(position))) {
                    ++position;
                }
                if (position < this.myEndOffset && !this.isNumberTail(finalChar = this.myBuffer.charAt(position)) && !this.isDelimiter(finalChar)) {
                    position = dotPosition;
                }
            }
        }
        while (position < this.myEndOffset && this.isNumberTail(this.myBuffer.charAt(position))) {
            ++position;
        }
        this.myTokenInfo.updateData(start, position, CustomHighlighterTokenType.NUMBER);
        return true;
    }

    @Override
    public int getSmartUpdateShift() {
        return 2;
    }

    static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private boolean isDelimiter(char c) {
        return !Character.isLetter(c);
    }

    private boolean isSuffix(char c) {
        return this.mySuffices != null && this.mySuffices.indexOf(c) >= 0;
    }

    private boolean isNumberTail(char c) {
        return this.isSuffix(c);
    }
}

