/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter.custom;

import com.intellij.ide.highlighter.custom.AbstractCustomLexer;
import com.intellij.ide.highlighter.custom.SyntaxTable;
import com.intellij.ide.highlighter.custom.tokens.BaseTokenParser;
import com.intellij.ide.highlighter.custom.tokens.BraceTokenParser;
import com.intellij.ide.highlighter.custom.tokens.HexNumberParser;
import com.intellij.ide.highlighter.custom.tokens.IdentifierParser;
import com.intellij.ide.highlighter.custom.tokens.KeywordParser;
import com.intellij.ide.highlighter.custom.tokens.LineCommentParser;
import com.intellij.ide.highlighter.custom.tokens.MultilineCommentParser;
import com.intellij.ide.highlighter.custom.tokens.NumberParser;
import com.intellij.ide.highlighter.custom.tokens.QuotedStringParser;
import com.intellij.ide.highlighter.custom.tokens.TokenParser;
import com.intellij.ide.highlighter.custom.tokens.WhitespaceParser;
import com.intellij.psi.CustomHighlighterTokenType;
import java.util.ArrayList;
import java.util.Set;

public final class CustomFileTypeLexer
extends AbstractCustomLexer {
    public CustomFileTypeLexer(SyntaxTable table, boolean forHighlighting) {
        super(CustomFileTypeLexer.buildTokenParsers(table, forHighlighting));
    }

    public CustomFileTypeLexer(SyntaxTable table) {
        this(table, false);
    }

    private static TokenParser[] buildTokenParsers(SyntaxTable table, boolean forHighlighting) {
        WhitespaceParser whitespaceParser = new WhitespaceParser();
        LineCommentParser lineCommentParser = LineCommentParser.create(table.getLineComment());
        MultilineCommentParser multilineCommentParser = MultilineCommentParser.create(table.getStartComment(), table.getEndComment());
        NumberParser numberParser = new NumberParser(table.getNumPostfixChars(), table.isIgnoreCase());
        HexNumberParser hexNumberParser = HexNumberParser.create(table.getHexPrefix());
        KeywordParser keywordParser = new KeywordParser(new Set[]{table.getKeywords1(), table.getKeywords2(), table.getKeywords3(), table.getKeywords4()}, table.isIgnoreCase());
        IdentifierParser identifierParser = new IdentifierParser();
        QuotedStringParser quotedStringParser = new QuotedStringParser("\"", CustomHighlighterTokenType.STRING, table.isHasStringEscapes());
        QuotedStringParser quotedStringParser2 = new QuotedStringParser("'", forHighlighting ? CustomHighlighterTokenType.SINGLE_QUOTED_STRING : CustomHighlighterTokenType.STRING, table.isHasStringEscapes());
        ArrayList<BaseTokenParser> tokenParsers = new ArrayList<BaseTokenParser>();
        tokenParsers.add(whitespaceParser);
        tokenParsers.add(quotedStringParser);
        tokenParsers.add(quotedStringParser2);
        if (lineCommentParser != null) {
            tokenParsers.add(lineCommentParser);
        }
        if (multilineCommentParser != null) {
            tokenParsers.add(multilineCommentParser);
        }
        tokenParsers.add(numberParser);
        if (hexNumberParser != null) {
            tokenParsers.add(hexNumberParser);
        }
        tokenParsers.add(keywordParser);
        tokenParsers.add(identifierParser);
        if (table.isHasBraces()) {
            tokenParsers.add(new BraceTokenParser("{", CustomHighlighterTokenType.L_BRACE));
            tokenParsers.add(new BraceTokenParser("}", CustomHighlighterTokenType.R_BRACE));
        }
        if (table.isHasParens()) {
            tokenParsers.add(new BraceTokenParser("(", CustomHighlighterTokenType.L_PARENTH));
            tokenParsers.add(new BraceTokenParser(")", CustomHighlighterTokenType.R_PARENTH));
        }
        if (table.isHasBrackets()) {
            tokenParsers.add(new BraceTokenParser("[", CustomHighlighterTokenType.L_BRACKET));
            tokenParsers.add(new BraceTokenParser("]", CustomHighlighterTokenType.R_BRACKET));
        }
        return tokenParsers.toArray(new TokenParser[tokenParsers.size()]);
    }
}

