/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.method;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.JavaHierarchyUtil;
import com.intellij.ide.hierarchy.method.MethodHierarchyTreeStructure;
import com.intellij.ide.hierarchy.method.MethodHierarchyUtil;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RowIcon;
import javax.swing.Icon;

public final class MethodHierarchyNodeDescriptor
extends HierarchyNodeDescriptor {
    private static final Icon METHOD_DEFINED_ICON = IconLoader.getIcon((String)"/hierarchy/methodDefined.png");
    private static final Icon METHOD_NOT_DEFINED_ICON = IconLoader.getIcon((String)"/hierarchy/methodNotDefined.png");
    private static final Icon SHOULD_DEFINE_METHOD_ICON = IconLoader.getIcon((String)"/hierarchy/shouldDefineMethod.png");
    private Icon myRawIcon;
    private Icon myStateIcon;
    private MethodHierarchyTreeStructure myTreeStructure;

    public MethodHierarchyNodeDescriptor(Project project, HierarchyNodeDescriptor parentDescriptor, PsiClass aClass, boolean isBase, MethodHierarchyTreeStructure treeStructure) {
        super(project, parentDescriptor, (PsiElement)aClass, isBase);
        this.myTreeStructure = treeStructure;
    }

    public final void setTreeStructure(MethodHierarchyTreeStructure treeStructure) {
        this.myTreeStructure = treeStructure;
    }

    private PsiMethod getMethod(PsiClass aClass, boolean checkBases) {
        return MethodHierarchyUtil.findBaseMethodInClass(this.myTreeStructure.getBaseMethod(), aClass, checkBases);
    }

    public final PsiClass getPsiClass() {
        return (PsiClass)this.myElement;
    }

    public final PsiElement getTargetElement() {
        PsiClass aClass = this.getPsiClass();
        if (aClass == null || !aClass.isValid()) {
            return null;
        }
        PsiMethod method = this.getMethod(aClass, false);
        if (method != null) {
            return method;
        }
        return aClass;
    }

    @Override
    public final boolean isValid() {
        PsiClass aClass = this.getPsiClass();
        return aClass != null && aClass.isValid();
    }

    @Override
    public final boolean update() {
        int flags = 1;
        if (this.isMarkReadOnly()) {
            flags |= 2;
        }
        boolean changes = super.update();
        PsiClass psiClass = this.getPsiClass();
        if (psiClass == null) {
            String invalidPrefix = IdeBundle.message((String)"node.hierarchy.invalid", (Object[])new Object[0]);
            if (!this.myHighlightedText.getText().startsWith(invalidPrefix)) {
                this.myHighlightedText.getBeginning().addText(invalidPrefix, HierarchyNodeDescriptor.getInvalidPrefixAttributes());
            }
            return true;
        }
        Icon newRawIcon = psiClass.getIcon(flags);
        Icon newStateIcon = this.calculateState(psiClass);
        if (newRawIcon != this.myRawIcon || newStateIcon != this.myStateIcon) {
            LayeredIcon icon;
            changes = true;
            this.myRawIcon = newRawIcon;
            this.myStateIcon = newStateIcon;
            this.myOpenIcon = this.myRawIcon;
            if (this.myIsBase) {
                icon = new LayeredIcon(2);
                icon.setIcon(this.myOpenIcon, 0);
                icon.setIcon(BASE_POINTER_ICON, 1, -BASE_POINTER_ICON.getIconWidth() / 2, 0);
                this.myOpenIcon = icon;
            }
            if (this.myStateIcon != null) {
                icon = new RowIcon(2);
                icon.setIcon(this.myStateIcon, 0);
                icon.setIcon(this.myOpenIcon, 1);
                this.myOpenIcon = icon;
            }
            this.myClosedIcon = this.myOpenIcon;
        }
        CompositeAppearance oldText = this.myHighlightedText;
        this.myHighlightedText = new CompositeAppearance();
        TextAttributes classNameAttributes = null;
        if (this.myColor != null) {
            classNameAttributes = new TextAttributes(this.myColor, null, null, null, 0);
        }
        this.myHighlightedText.getEnding().addText(ClassPresentationUtil.getNameForClass(psiClass, false), classNameAttributes);
        this.myHighlightedText.getEnding().addText("  (" + JavaHierarchyUtil.getPackageName(psiClass) + ")", HierarchyNodeDescriptor.getPackageNameAttributes());
        this.myName = this.myHighlightedText.getText();
        if (!Comparing.equal((Object)this.myHighlightedText, (Object)oldText)) {
            changes = true;
        }
        return changes;
    }

    private Icon calculateState(PsiClass psiClass) {
        boolean hasBaseImplementation;
        PsiMethod method = this.getMethod(psiClass, false);
        if (method != null) {
            if (method.hasModifierProperty("abstract")) {
                return null;
            }
            return METHOD_DEFINED_ICON;
        }
        if (this.myTreeStructure.isSuperClassForBaseClass(psiClass)) {
            return METHOD_NOT_DEFINED_ICON;
        }
        boolean isAbstractClass = psiClass.hasModifierProperty("abstract");
        PsiMethod baseClassMethod = this.getMethod(psiClass, true);
        boolean bl = hasBaseImplementation = baseClassMethod != null && !baseClassMethod.hasModifierProperty("abstract");
        if (hasBaseImplementation || isAbstractClass) {
            return METHOD_NOT_DEFINED_ICON;
        }
        return SHOULD_DEFINE_METHOD_ICON;
    }
}

