/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateDefaultExtension;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateGroupDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateGroupDescriptorFactory;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.InternalTemplateBean;
import com.intellij.ide.fileTemplates.impl.FileTemplateConfigurable;
import com.intellij.ide.fileTemplates.impl.FileTemplateImpl;
import com.intellij.ide.fileTemplates.impl.FileTemplateManagerImpl;
import com.intellij.ide.fileTemplates.impl.FileTemplateTab;
import com.intellij.ide.fileTemplates.impl.FileTemplateTabAsList;
import com.intellij.ide.fileTemplates.impl.FileTemplateTabAsTree;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AllFileTemplatesConfigurable
implements SearchableConfigurable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.fileTemplates.impl.AllFileTemplatesConfigurable");
    private JPanel myMainPanel;
    private FileTemplateTab myCurrentTab;
    private FileTemplateTab myTemplatesList;
    private FileTemplateTab myIncludesList;
    private FileTemplateTab myCodeTemplatesList;
    private FileTemplateTab myJ2eeTemplatesList;
    private JComponent myToolBar;
    private TabbedPaneWrapper myTabbedPane;
    private FileTemplateConfigurable myEditor;
    private boolean myModified = false;
    private JComponent myEditorComponent;
    private static final int TEMPLATE_ID = 0;
    private static final int PATTERN_ID = 1;
    private static final int CODE_ID = 2;
    private static final int J2EE_ID = 3;
    private static final Icon ourIcon = IconLoader.getIcon((String)"/general/fileTemplates.png");
    private FileTemplateTab[] myTabs;
    private static final String TEMPLATES_TITLE = IdeBundle.message((String)"tab.filetemplates.templates", (Object[])new Object[0]);
    private static final String INCLUDES_TITLE = IdeBundle.message((String)"tab.filetemplates.includes", (Object[])new Object[0]);
    private static final String CODE_TITLE = IdeBundle.message((String)"tab.filetemplates.code", (Object[])new Object[0]);
    private static final String J2EE_TITLE = IdeBundle.message((String)"tab.filetemplates.j2ee", (Object[])new Object[0]);
    private Disposable myUIDisposable;
    @NonNls
    private static final String CURRENT_TAB = "FileTemplates.CurrentTab";
    @NonNls
    private static final String SELECTED_TEMPLATE = "FileTemplates.SelectedTemplate";

    public Icon getIcon() {
        return ourIcon;
    }

    private void onRemove() {
        this.myCurrentTab.removeSelected();
        this.myModified = true;
    }

    private void onAdd() {
        String ext = "java";
        FileTemplateDefaultExtension[] defaultExtensions = (FileTemplateDefaultExtension[])Extensions.getExtensions(FileTemplateDefaultExtension.EP_NAME);
        if (defaultExtensions.length > 0) {
            ext = defaultExtensions[0].value;
        }
        this.createTemplate(IdeBundle.message((String)"template.unnamed", (Object[])new Object[0]), ext, "");
    }

    private FileTemplate createTemplate(@NotNull String prefName, @NotNull @NonNls String extension, @NotNull String content) {
        if (prefName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/AllFileTemplatesConfigurable.createTemplate must not be null");
        }
        if (extension == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/AllFileTemplatesConfigurable.createTemplate must not be null");
        }
        if (content == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/AllFileTemplatesConfigurable.createTemplate must not be null");
        }
        FileTemplate[] templates = this.myCurrentTab.getTemplates();
        ArrayList<String> names = new ArrayList<String>(templates.length);
        for (FileTemplate template : templates) {
            names.add(template.getName());
        }
        String name = prefName;
        int i = 0;
        while (names.contains(name)) {
            name = prefName + " (" + ++i + ")";
        }
        FileTemplateImpl newTemplate = new FileTemplateImpl(content, name, extension);
        this.myCurrentTab.addTemplate(newTemplate);
        this.myModified = true;
        this.myCurrentTab.selectTemplate(newTemplate);
        this.fireListChanged();
        this.myEditor.focusToNameField();
        return newTemplate;
    }

    private void onClone() {
        FileTemplate selected = this.myCurrentTab.getSelectedTemplate();
        if (selected == null) {
            return;
        }
        FileTemplate[] templates = this.myCurrentTab.getTemplates();
        ArrayList<String> names = new ArrayList<String>(templates.length);
        for (FileTemplate template : templates) {
            names.add(template.getName());
        }
        String nameTemplate = IdeBundle.message((String)"template.copy.N.of.T", (Object[])new Object[0]);
        String name = MessageFormat.format(nameTemplate, "", selected.getName());
        int i = 0;
        while (names.contains(name)) {
            name = MessageFormat.format(nameTemplate, ++i + " ", selected.getName());
        }
        FileTemplateImpl newTemplate = new FileTemplateImpl(selected.getText(), name, selected.getExtension());
        this.myCurrentTab.addTemplate(newTemplate);
        this.myModified = true;
        this.myCurrentTab.selectTemplate(newTemplate);
        this.fireListChanged();
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"title.file.templates", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        int index = this.myTabbedPane.getSelectedIndex();
        switch (index) {
            case 0: {
                return "fileTemplates.templates";
            }
            case 1: {
                return "fileTemplates.includes";
            }
            case 2: {
                return "fileTemplates.code";
            }
            case 3: {
                return "fileTemplates.j2ee";
            }
        }
        throw new IllegalStateException("wrong index: " + index);
    }

    public JComponent createComponent() {
        this.myUIDisposable = Disposer.newDisposable();
        this.myTemplatesList = new FileTemplateTabAsList(TEMPLATES_TITLE){

            @Override
            public void onTemplateSelected() {
                AllFileTemplatesConfigurable.this.onListSelectionChanged();
            }
        };
        this.myIncludesList = new FileTemplateTabAsList(INCLUDES_TITLE){

            @Override
            public void onTemplateSelected() {
                AllFileTemplatesConfigurable.this.onListSelectionChanged();
            }
        };
        this.myCodeTemplatesList = new FileTemplateTabAsList(CODE_TITLE){

            @Override
            public void onTemplateSelected() {
                AllFileTemplatesConfigurable.this.onListSelectionChanged();
            }
        };
        this.myCurrentTab = this.myTemplatesList;
        ArrayList<FileTemplateTab> allTabs = new ArrayList<FileTemplateTab>(Arrays.asList(this.myTemplatesList, this.myIncludesList, this.myCodeTemplatesList));
        THashSet factories = new THashSet();
        factories.addAll(Arrays.asList(ApplicationManager.getApplication().getComponents(FileTemplateGroupDescriptorFactory.class)));
        factories.addAll(Arrays.asList(Extensions.getExtensions((ExtensionPointName)FileTemplateGroupDescriptorFactory.EXTENSION_POINT_NAME)));
        if (!factories.isEmpty()) {
            this.myJ2eeTemplatesList = new FileTemplateTabAsTree(J2EE_TITLE, (Set)factories){
                final /* synthetic */ Set val$factories;
                {
                    this.val$factories = set;
                    super(x0);
                }

                @Override
                public void onTemplateSelected() {
                    AllFileTemplatesConfigurable.this.onListSelectionChanged();
                }

                @Override
                protected FileTemplateTabAsTree.FileTemplateNode initModel() {
                    TreeSet<FileTemplateGroupDescriptor> categories = new TreeSet<FileTemplateGroupDescriptor>(new Comparator<FileTemplateGroupDescriptor>(){

                        @Override
                        public int compare(FileTemplateGroupDescriptor o1, FileTemplateGroupDescriptor o2) {
                            return o1.getTitle().compareTo(o2.getTitle());
                        }
                    });
                    for (FileTemplateGroupDescriptorFactory templateGroupFactory : this.val$factories) {
                        ContainerUtil.addIfNotNull((Object)templateGroupFactory.getFileTemplatesDescriptor(), categories);
                    }
                    return new FileTemplateTabAsTree.FileTemplateNode("ROOT", null, ContainerUtil.map2List(categories, (Function)new Function<FileTemplateGroupDescriptor, FileTemplateTabAsTree.FileTemplateNode>(){

                        public FileTemplateTabAsTree.FileTemplateNode fun(FileTemplateGroupDescriptor s) {
                            return new FileTemplateTabAsTree.FileTemplateNode((FileTemplateDescriptor)s);
                        }
                    }));
                }
            };
            allTabs.add(this.myJ2eeTemplatesList);
        }
        this.myTabs = allTabs.toArray(new FileTemplateTab[allTabs.size()]);
        this.myTabbedPane = new TabbedPaneWrapper(this.myUIDisposable);
        this.myTabbedPane.setTabLayoutPolicy(1);
        for (FileTemplateTab tab : this.myTabs) {
            this.myTabbedPane.addTab(tab.getTitle(), new JScrollPane(tab.getComponent()));
        }
        this.myTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AllFileTemplatesConfigurable.this.onTabChanged();
            }
        });
        DefaultActionGroup group = new DefaultActionGroup();
        AnAction removeAction = new AnAction(IdeBundle.message((String)"action.remove.template", (Object[])new Object[0]), null, IconLoader.getIcon((String)"/general/remove.png")){

            public void actionPerformed(AnActionEvent e) {
                AllFileTemplatesConfigurable.this.onRemove();
            }

            public void update(AnActionEvent e) {
                super.update(e);
                FileTemplate selectedItem = AllFileTemplatesConfigurable.this.myCurrentTab.getSelectedTemplate();
                e.getPresentation().setEnabled(selectedItem != null && !AllFileTemplatesConfigurable.isInternalTemplate(selectedItem.getName(), AllFileTemplatesConfigurable.this.myCurrentTab.getTitle()));
            }
        };
        AnAction addAction = new AnAction(IdeBundle.message((String)"action.create.template", (Object[])new Object[0]), null, IconLoader.getIcon((String)"/general/add.png")){

            public void actionPerformed(AnActionEvent e) {
                AllFileTemplatesConfigurable.this.onAdd();
            }

            public void update(AnActionEvent e) {
                super.update(e);
                e.getPresentation().setEnabled(AllFileTemplatesConfigurable.this.myCurrentTab != AllFileTemplatesConfigurable.this.myCodeTemplatesList && AllFileTemplatesConfigurable.this.myCurrentTab != AllFileTemplatesConfigurable.this.myJ2eeTemplatesList);
            }
        };
        AnAction cloneAction = new AnAction(IdeBundle.message((String)"action.copy.template", (Object[])new Object[0]), null, IconLoader.getIcon((String)"/actions/copy.png")){

            public void actionPerformed(AnActionEvent e) {
                AllFileTemplatesConfigurable.this.onClone();
            }

            public void update(AnActionEvent e) {
                super.update(e);
                e.getPresentation().setEnabled(AllFileTemplatesConfigurable.this.myCurrentTab != AllFileTemplatesConfigurable.this.myCodeTemplatesList && AllFileTemplatesConfigurable.this.myCurrentTab != AllFileTemplatesConfigurable.this.myJ2eeTemplatesList && AllFileTemplatesConfigurable.this.myCurrentTab.getSelectedTemplate() != null);
            }
        };
        AnAction resetAction = new AnAction(IdeBundle.message((String)"action.reset.to.default", (Object[])new Object[0]), null, IconLoader.getIcon((String)"/actions/reset.png")){

            public void actionPerformed(AnActionEvent e) {
                AllFileTemplatesConfigurable.this.onReset();
            }

            public void update(AnActionEvent e) {
                super.update(e);
                FileTemplate selectedItem = AllFileTemplatesConfigurable.this.myCurrentTab.getSelectedTemplate();
                FileTemplateManagerImpl manager = FileTemplateManagerImpl.getInstanceImpl();
                e.getPresentation().setEnabled(selectedItem != null && !selectedItem.isDefault() && manager.getDefaultTemplate(selectedItem.getName(), selectedItem.getExtension()) != null);
            }
        };
        group.add(addAction);
        group.add(removeAction);
        group.add(cloneAction);
        group.add(resetAction);
        addAction.registerCustomShortcutSet(CommonShortcuts.INSERT, this.myCurrentTab.getComponent());
        removeAction.registerCustomShortcutSet(CommonShortcuts.DELETE, this.myCurrentTab.getComponent());
        this.myToolBar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true).getComponent();
        this.myEditor = new FileTemplateConfigurable();
        this.myEditor.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AllFileTemplatesConfigurable.this.onEditorChanged();
            }
        });
        this.myMainPanel = new JPanel(new GridBagLayout()){

            @Override
            public void doLayout() {
                AllFileTemplatesConfigurable.this.doMainPanelLayout();
            }
        };
        this.myMainPanel.add((Component)this.myToolBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.myMainPanel.add((Component)this.myTabbedPane.getComponent(), new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.myEditorComponent = this.myEditor.createComponent();
        this.myMainPanel.add((Component)this.myEditorComponent, new GridBagConstraints(1, 0, 1, 2, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.myMainPanel.setMinimumSize(new Dimension(400, 300));
        this.myMainPanel.setPreferredSize(new Dimension(700, 500));
        return this.myMainPanel;
    }

    private void onReset() {
        FileTemplate selected = this.myCurrentTab.getSelectedTemplate();
        if (selected != null) {
            if (Messages.showOkCancelDialog((String)IdeBundle.message((String)"prompt.reset.to.original.template", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.reset.template", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) != 0) {
                return;
            }
            FileTemplateImpl template = (FileTemplateImpl)selected;
            template.resetToDefault();
            this.myEditor.reset();
            this.myModified = true;
        }
    }

    private void onEditorChanged() {
        this.fireListChanged();
    }

    private void onTabChanged() {
        int selectedIndex = this.myTabbedPane.getSelectedIndex();
        if (0 <= selectedIndex && selectedIndex < this.myTabs.length) {
            this.myCurrentTab = this.myTabs[selectedIndex];
        }
        this.onListSelectionChanged();
    }

    private void onListSelectionChanged() {
        FileTemplate prevTemplate;
        FileTemplate selectedValue = this.myCurrentTab.getSelectedTemplate();
        FileTemplate fileTemplate = prevTemplate = this.myEditor == null ? null : this.myEditor.getTemplate();
        if (prevTemplate != selectedValue) {
            LOG.assertTrue(this.myEditor != null, (Object)("selected:" + selectedValue + "; prev:" + prevTemplate));
            if (this.myEditor.isModified()) {
                try {
                    this.myModified = true;
                    this.myEditor.apply();
                    this.fireListChanged();
                }
                catch (ConfigurationException e) {
                    this.myCurrentTab.selectTemplate(prevTemplate);
                    Messages.showErrorDialog((Component)this.myMainPanel, (String)e.getMessage(), (String)IdeBundle.message((String)"title.cannot.save.current.template", (Object[])new Object[0]));
                    return;
                }
            }
            if (selectedValue == null) {
                this.myEditor.setTemplate(null, FileTemplateManagerImpl.getInstanceImpl().getDefaultTemplateDescription());
                this.myEditorComponent.repaint();
            } else {
                this.selectTemplate(selectedValue);
            }
        }
    }

    private void selectTemplate(FileTemplate template) {
        VirtualFile defDesc = null;
        if (this.myCurrentTab == this.myTemplatesList) {
            defDesc = FileTemplateManagerImpl.getInstanceImpl().getDefaultTemplateDescription();
        } else if (this.myCurrentTab == this.myIncludesList) {
            defDesc = FileTemplateManagerImpl.getInstanceImpl().getDefaultIncludeDescription();
        }
        if (this.myEditor.getTemplate() != template) {
            this.myEditor.setTemplate(template, defDesc);
            boolean isInternal = AllFileTemplatesConfigurable.isInternalTemplate(template.getName(), this.myCurrentTab.getTitle());
            this.myEditor.setShowInternalMessage(isInternal ? " " : null);
            this.myEditor.setShowAdjustCheckBox(this.myTemplatesList == this.myCurrentTab);
        }
    }

    public static boolean isInternalTemplate(String templateName, String templateTabTitle) {
        if (templateName == null) {
            return false;
        }
        if (Comparing.strEqual((String)templateTabTitle, (String)TEMPLATES_TITLE)) {
            return AllFileTemplatesConfigurable.isInternalTemplateName(templateName);
        }
        if (Comparing.strEqual((String)templateTabTitle, (String)CODE_TITLE)) {
            return true;
        }
        if (Comparing.strEqual((String)templateTabTitle, (String)J2EE_TITLE)) {
            return true;
        }
        if (Comparing.strEqual((String)templateTabTitle, (String)INCLUDES_TITLE)) {
            return Comparing.strEqual((String)templateName, (String)"File Header");
        }
        return false;
    }

    private static boolean isInternalTemplateName(String templateName) {
        for (InternalTemplateBean bean : (InternalTemplateBean[])Extensions.getExtensions(InternalTemplateBean.EP_NAME)) {
            if (!Comparing.strEqual((String)templateName, (String)bean.name)) continue;
            return true;
        }
        return false;
    }

    private void doMainPanelLayout() {
        Dimension toolbarPreferredSize = this.myToolBar.getPreferredSize();
        Dimension mainPanelSize = this.myMainPanel.getSize();
        Dimension scrollPanePreferedSize = this.myTabbedPane.getComponent().getPreferredSize();
        if (mainPanelSize.width < 1 || mainPanelSize.height < 1) {
            return;
        }
        int leftWidth = scrollPanePreferedSize.width;
        leftWidth = Math.min(leftWidth, mainPanelSize.width / 5);
        leftWidth = Math.max(leftWidth, 300);
        leftWidth = Math.max(leftWidth, toolbarPreferredSize.width);
        int x = 2;
        int y = 2;
        int width = toolbarPreferredSize.width;
        int height = toolbarPreferredSize.height;
        this.myToolBar.setBounds(x, y, width, height);
        y += height + 2;
        width = leftWidth + 2;
        height = Math.max(1, mainPanelSize.height - 2 - y);
        this.myTabbedPane.getComponent().setBounds(x, y, width, height);
        x += width + 4;
        y = 2;
        width = Math.max(1, mainPanelSize.width - 2 - x);
        height = Math.max(1, mainPanelSize.height - 2 - y);
        this.myEditorComponent.setBounds(x, y, width, height);
        this.myEditorComponent.revalidate();
    }

    private void initLists() {
        FileTemplateManager templateManager = FileTemplateManager.getInstance();
        Object[] templates = templateManager.getAllTemplates();
        Object[] internals = templateManager.getInternalTemplates();
        FileTemplate[] templatesAndInternals = (FileTemplate[])ArrayUtil.mergeArrays((Object[])internals, (Object[])templates, FileTemplate.class);
        this.myTemplatesList.init(templatesAndInternals);
        this.myIncludesList.init(templateManager.getAllPatterns());
        this.myCodeTemplatesList.init(templateManager.getAllCodeTemplates());
        if (this.myJ2eeTemplatesList != null) {
            this.myJ2eeTemplatesList.init(templateManager.getAllJ2eeTemplates());
        }
    }

    public boolean isModified() {
        return this.myModified || this.myEditor != null && this.myEditor.isModified();
    }

    private boolean canApply(boolean showErrorDialog, String[] errorString) {
        for (FileTemplateTab list : this.myTabs) {
            if (this.canApply(showErrorDialog, errorString, list)) continue;
            return false;
        }
        return true;
    }

    private boolean canApply(final boolean showErrorDialog, String[] errorString, FileTemplateTab list) {
        FileTemplate[] templates = this.myCurrentTab.getTemplates();
        ArrayList<String> allNames = new ArrayList<String>();
        FileTemplate itemWithError = null;
        String errorMessage = null;
        String errorTitle = null;
        boolean errorInName = true;
        for (FileTemplate template : templates) {
            if (AllFileTemplatesConfigurable.isInternalTemplateName(template.getName())) continue;
            String currName = template.getName();
            String currExt = template.getExtension();
            if (currName.length() == 0) {
                itemWithError = template;
                errorMessage = IdeBundle.message((String)"error.please.specify.a.name.for.this.template", (Object[])new Object[0]);
                errorTitle = IdeBundle.message((String)"title.template.name.not.specified", (Object[])new Object[0]);
                errorString[0] = IdeBundle.message((String)"error.please.specify.template.name", (Object[])new Object[0]);
                break;
            }
            if (allNames.contains(currName)) {
                itemWithError = template;
                errorMessage = IdeBundle.message((String)"error.please.specify.a.different.name.for.this.template", (Object[])new Object[0]);
                errorTitle = IdeBundle.message((String)"title.template.already.exists", (Object[])new Object[0]);
                errorString[0] = IdeBundle.message((String)"error.template.with.such.name.already.exists", (Object[])new Object[0]);
                break;
            }
            if (currExt.length() == 0) {
                itemWithError = template;
                errorMessage = IdeBundle.message((String)"error.please.specify.extension", (Object[])new Object[0]);
                errorTitle = IdeBundle.message((String)"title.template.extension.not.specified", (Object[])new Object[0]);
                errorString[0] = IdeBundle.message((String)"error.please.specify.template.extension", (Object[])new Object[0]);
                errorInName = false;
                break;
            }
            allNames.add(currName);
        }
        if (itemWithError == null) {
            return true;
        }
        final String _errorString = errorMessage;
        final String _errorTitle = errorTitle;
        final boolean _errorInName = errorInName;
        this.myTabbedPane.setSelectedIndex(Arrays.asList(this.myTabs).indexOf(list));
        this.selectTemplate(itemWithError);
        list.selectTemplate(itemWithError);
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (showErrorDialog) {
                    Messages.showMessageDialog((Component)AllFileTemplatesConfigurable.this.myMainPanel, (String)_errorString, (String)_errorTitle, (Icon)Messages.getErrorIcon());
                }
                if (_errorInName) {
                    AllFileTemplatesConfigurable.this.myEditor.focusToNameField();
                } else {
                    AllFileTemplatesConfigurable.this.myEditor.focusToExtensionField();
                }
            }
        });
        return false;
    }

    private void fireListChanged() {
        if (this.myCurrentTab != null) {
            this.myCurrentTab.fireDataChanged();
        }
        if (this.myMainPanel != null) {
            this.myMainPanel.revalidate();
        }
    }

    public void apply() throws ConfigurationException {
        String[] errorString;
        if (this.myEditor != null && this.myEditor.isModified()) {
            this.myModified = true;
            this.myEditor.apply();
        }
        if (!this.canApply(false, errorString = new String[1])) {
            throw new ConfigurationException(errorString[0]);
        }
        ArrayList<FileTemplate> newModifiedItems = new ArrayList<FileTemplate>();
        FileTemplate[] templates = this.myTemplatesList.getTemplates();
        newModifiedItems.addAll(Arrays.asList(templates));
        FileTemplateManager templatesManager = FileTemplateManager.getInstance();
        AllFileTemplatesConfigurable.apply(newModifiedItems, this.myTemplatesList.savedTemplates, 0, templatesManager.getAllTemplates());
        newModifiedItems = new ArrayList();
        templates = this.myIncludesList.getTemplates();
        newModifiedItems.addAll(Arrays.asList(templates));
        AllFileTemplatesConfigurable.apply(newModifiedItems, this.myIncludesList.savedTemplates, 1, templatesManager.getAllPatterns());
        newModifiedItems = new ArrayList();
        templates = this.myCodeTemplatesList.getTemplates();
        newModifiedItems.addAll(Arrays.asList(templates));
        AllFileTemplatesConfigurable.apply(newModifiedItems, this.myCodeTemplatesList.savedTemplates, 2, templatesManager.getAllCodeTemplates());
        if (this.myJ2eeTemplatesList != null) {
            newModifiedItems = new ArrayList();
            templates = this.myJ2eeTemplatesList.getTemplates();
            newModifiedItems.addAll(Arrays.asList(templates));
            AllFileTemplatesConfigurable.apply(newModifiedItems, this.myJ2eeTemplatesList.savedTemplates, 3, templatesManager.getAllJ2eeTemplates());
        }
        FileTemplateManager.getInstance().saveAll();
        if (this.myEditor != null) {
            this.myModified = false;
            this.fireListChanged();
            this.reset();
        }
    }

    private static void removeTemplate(FileTemplate aTemplate, int listId, boolean fromDiskOnly) {
        FileTemplateManager manager = FileTemplateManager.getInstance();
        if (listId == 0) {
            if (!aTemplate.isInternal()) {
                manager.removeTemplate(aTemplate, fromDiskOnly);
            } else {
                manager.removeInternal(aTemplate);
            }
        } else if (listId == 1) {
            manager.removePattern(aTemplate, fromDiskOnly);
        } else if (listId == 2) {
            manager.removeCodeTemplate(aTemplate, fromDiskOnly);
        } else if (listId == 3) {
            manager.removeJ2eeTemplate(aTemplate, fromDiskOnly);
        }
    }

    private static void apply(ArrayList<FileTemplate> newModifiedItems, Map<FileTemplate, FileTemplate> savedTemplate2ModifiedTemplate, int listId, FileTemplate[] templates) {
        FileTemplateManager templatesManager = FileTemplateManager.getInstance();
        if (listId == 0) {
            Object[] internals = templatesManager.getInternalTemplates();
            templates = (FileTemplate[])ArrayUtil.mergeArrays((Object[])internals, (Object[])templates, FileTemplate.class);
        }
        ArrayList<FileTemplate> savedTemplates = new ArrayList<FileTemplate>();
        for (FileTemplate aTemplate : templates) {
            FileTemplate aModifiedTemplate = savedTemplate2ModifiedTemplate.get(aTemplate);
            if (newModifiedItems.contains(aModifiedTemplate)) {
                savedTemplates.add(aTemplate);
                continue;
            }
            AllFileTemplatesConfigurable.removeTemplate(aTemplate, listId, false);
            savedTemplate2ModifiedTemplate.remove(aTemplate);
        }
        for (FileTemplate aTemplate : savedTemplates) {
            FileTemplate aModifiedTemplate = savedTemplate2ModifiedTemplate.get(aTemplate);
            LOG.assertTrue(aModifiedTemplate != null);
            aTemplate.setAdjust(aModifiedTemplate.isAdjust());
            if (!aModifiedTemplate.isDefault()) {
                FileTemplateUtil.copyTemplate(aModifiedTemplate, aTemplate);
                continue;
            }
            if (aTemplate.isDefault()) continue;
            AllFileTemplatesConfigurable.removeTemplate(aTemplate, listId, true);
        }
        for (FileTemplate aModifiedTemplate : newModifiedItems) {
            LOG.assertTrue(aModifiedTemplate != null);
            if (savedTemplate2ModifiedTemplate.containsValue(aModifiedTemplate)) continue;
            if (listId == 0) {
                templatesManager.addTemplate(aModifiedTemplate.getName(), aModifiedTemplate.getExtension()).setText(aModifiedTemplate.getText());
                continue;
            }
            if (listId == 1) {
                templatesManager.addPattern(aModifiedTemplate.getName(), aModifiedTemplate.getExtension()).setText(aModifiedTemplate.getText());
                continue;
            }
            if (listId == 2) {
                templatesManager.addCodeTemplate(aModifiedTemplate.getName(), aModifiedTemplate.getExtension()).setText(aModifiedTemplate.getText());
                continue;
            }
            if (listId != 3) continue;
            templatesManager.addJ2eeTemplate(aModifiedTemplate.getName(), aModifiedTemplate.getExtension()).setText(aModifiedTemplate.getText());
        }
    }

    public void reset() {
        this.myEditor.reset();
        this.initLists();
        PropertiesComponent component = PropertiesComponent.getInstance();
        String tabName = component.getValue(CURRENT_TAB);
        int idx = 0;
        block0: for (FileTemplateTab tab : this.myTabs) {
            if (Comparing.strEqual((String)tab.getTitle(), (String)tabName)) {
                FileTemplate[] templates;
                this.myCurrentTab = tab;
                this.myTabbedPane.setSelectedIndex(idx);
                String selectedTemplate = component.getValue(SELECTED_TEMPLATE);
                for (FileTemplate template : templates = this.myCurrentTab.getTemplates()) {
                    if (!Comparing.strEqual((String)template.getName(), (String)selectedTemplate)) continue;
                    tab.selectTemplate(template);
                    break block0;
                }
                break;
            }
            ++idx;
        }
        this.myModified = false;
    }

    public void disposeUIResources() {
        if (this.myCurrentTab != null) {
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
            propertiesComponent.setValue(CURRENT_TAB, this.myCurrentTab.getTitle());
            FileTemplate template = this.myCurrentTab.getSelectedTemplate();
            if (template != null) {
                propertiesComponent.setValue(SELECTED_TEMPLATE, template.getName());
            }
        }
        if (this.myEditor != null) {
            this.myEditor.disposeUIResources();
            this.myEditor = null;
            this.myEditorComponent = null;
        }
        this.myMainPanel = null;
        if (this.myUIDisposable != null) {
            Disposer.dispose((Disposable)this.myUIDisposable);
            this.myUIDisposable = null;
        }
        this.myTabbedPane = null;
        this.myToolBar = null;
        this.myTabs = null;
        this.myCurrentTab = null;
        this.myTemplatesList = null;
        this.myCodeTemplatesList = null;
        this.myIncludesList = null;
        this.myJ2eeTemplatesList = null;
    }

    public void createNewTemplate(@NotNull String preferredName, @NotNull String extension, @NotNull String text) {
        if (preferredName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/AllFileTemplatesConfigurable.createNewTemplate must not be null");
        }
        if (extension == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/AllFileTemplatesConfigurable.createNewTemplate must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/AllFileTemplatesConfigurable.createNewTemplate must not be null");
        }
        this.createTemplate(preferredName, extension, text);
    }

    public String getId() {
        return "fileTemplates";
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }
}

