/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.errorTreeView;

import com.intellij.ide.errorTreeView.CallingBackColoredTreeCellRenderer;
import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.ErrorTreeNodeDescriptor;
import com.intellij.ide.errorTreeView.GroupingElement;
import com.intellij.ide.errorTreeView.NavigatableMessageElement;
import com.intellij.ide.errorTreeView.SimpleMessageElement;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vcs.changes.issueLinks.ClickableTreeCellRenderer;
import com.intellij.openapi.vcs.changes.issueLinks.TreeNodePartListener;
import com.intellij.ui.CustomizeColoredTreeCellRenderer;
import com.intellij.ui.MultilineTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import org.jetbrains.annotations.Nullable;

public class NewErrorTreeRenderer
extends MultilineTreeCellRenderer {
    private static final Icon ourFileIcon = IconLoader.getIcon((String)"/fileTypes/java.png");
    private static final Icon ourErrorIcon = IconLoader.getIcon((String)"/compiler/error.png");
    private static final Icon ourWarningIcon = IconLoader.getIcon((String)"/compiler/warning.png");
    private static final Icon ourInfoIcon = IconLoader.getIcon((String)"/compiler/information.png");
    private final MyWrapperRenderer myWrapperRenderer;
    private final CallingBackColoredTreeCellRenderer myColoredTreeCellRenderer = new CallingBackColoredTreeCellRenderer();
    private final MyNotSelectedColoredTreeCellRenderer myRightCellRenderer = new MyNotSelectedColoredTreeCellRenderer();

    private NewErrorTreeRenderer() {
        this.myWrapperRenderer = new MyWrapperRenderer((TreeCellRenderer)((Object)this.myColoredTreeCellRenderer), this.myRightCellRenderer);
    }

    public static JScrollPane install(JTree tree) {
        NewErrorTreeRenderer renderer = new NewErrorTreeRenderer();
        new TreeNodePartListener(renderer.myRightCellRenderer).install(tree);
        return MultilineTreeCellRenderer.installRenderer(tree, renderer);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        ErrorTreeElement element = NewErrorTreeRenderer.getElement(value);
        if (element != null) {
            CustomizeColoredTreeCellRenderer leftSelfRenderer = element.getLeftSelfRenderer();
            CustomizeColoredTreeCellRenderer rightSelfRenderer = element.getRightSelfRenderer();
            if (leftSelfRenderer != null || rightSelfRenderer != null) {
                this.myColoredTreeCellRenderer.setCurrentCallback(leftSelfRenderer);
                this.myRightCellRenderer.setCurrentCallback(rightSelfRenderer);
                return this.myWrapperRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            }
        }
        return super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
    }

    @Override
    protected void initComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        ErrorTreeElement element = NewErrorTreeRenderer.getElement(value);
        if (element instanceof GroupingElement) {
            this.setFont(this.getFont().deriveFont(1));
        }
        if (element instanceof SimpleMessageElement || element instanceof NavigatableMessageElement) {
            String prefix = element.getKind().getPresentableText();
            if (element instanceof NavigatableMessageElement) {
                prefix = prefix + ((NavigatableMessageElement)element).getRendererTextPrefix() + " ";
            }
            this.setText(element.getText(), prefix);
        } else if (element != null) {
            String[] text = element.getText();
            if (text == null) {
                text = ArrayUtil.EMPTY_STRING_ARRAY;
            }
            if (text.length > 0 && text[0] == null) {
                text[0] = "";
            }
            this.setText(text, null);
        }
        Icon icon = null;
        if (element instanceof GroupingElement) {
            GroupingElement groupingElement = (GroupingElement)element;
            icon = groupingElement.getFile() != null ? groupingElement.getFile().getFileType().getIcon() : ourFileIcon;
        } else if (element instanceof SimpleMessageElement || element instanceof NavigatableMessageElement) {
            ErrorTreeElementKind kind = element.getKind();
            if (ErrorTreeElementKind.ERROR.equals((Object)kind)) {
                icon = ourErrorIcon;
            } else if (ErrorTreeElementKind.WARNING.equals((Object)kind)) {
                icon = ourWarningIcon;
            } else if (ErrorTreeElementKind.INFO.equals((Object)kind)) {
                icon = ourInfoIcon;
            }
        }
        this.setIcon(icon);
    }

    private static ErrorTreeElement getElement(Object value) {
        if (!(value instanceof DefaultMutableTreeNode)) {
            return null;
        }
        Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
        if (!(userObject instanceof ErrorTreeNodeDescriptor)) {
            return null;
        }
        return ((ErrorTreeNodeDescriptor)((Object)userObject)).getElement();
    }

    private static class MyWrapperRenderer
    implements TreeCellRenderer {
        private final TreeCellRenderer myLeft;
        private final TreeCellRenderer myRight;
        private final JPanel myPanel;

        public TreeCellRenderer getLeft() {
            return this.myLeft;
        }

        public TreeCellRenderer getRight() {
            return this.myRight;
        }

        public MyWrapperRenderer(TreeCellRenderer left, TreeCellRenderer right) {
            this.myLeft = left;
            this.myRight = right;
            this.myPanel = new JPanel(new BorderLayout());
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.myPanel.setBackground(tree.getBackground());
            this.myPanel.add(this.myLeft.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus), "West");
            this.myPanel.add(this.myRight.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus), "East");
            return this.myPanel;
        }
    }

    private static class MyNotSelectedColoredTreeCellRenderer
    extends SimpleColoredComponent
    implements ClickableTreeCellRenderer {
        private CustomizeColoredTreeCellRenderer myCurrentCallback;

        private MyNotSelectedColoredTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.clear();
            this.setBackground(UIUtil.getBgFillColor((JComponent)tree));
            if (this.myCurrentCallback != null) {
                this.myCurrentCallback.customizeCellRenderer((SimpleColoredComponent)this, tree, value, selected, expanded, leaf, row, hasFocus);
            }
            if (this.getFont() == null) {
                this.setFont(tree.getFont());
            }
            return this;
        }

        @Override
        @Nullable
        public Object getTag() {
            return this.myCurrentCallback == null ? null : this.myCurrentCallback.getTag();
        }

        public void setCurrentCallback(CustomizeColoredTreeCellRenderer currentCallback) {
            this.myCurrentCallback = currentCallback;
        }
    }
}

