/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.dnd;

import com.intellij.ide.dnd.DnDAware;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.AwtVisitor;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DnDEnabler
implements Activatable,
Disposable {
    @NonNls
    public static final String KEY = "DragAndDropMultipleSelectionEnabler";
    private final AWTEventListener myAwtListener;
    private List<EventListener> myMouseListeners;
    private final DnDAware myDnDSource;
    private MouseListener myOriginalDragGestureRecognizer;
    private LafManagerListener myLafManagerListener;
    private MouseListener myTooltipListener1;
    private MouseListener myTooltipListener2;

    public DnDEnabler(@NotNull DnDAware source, Disposable parent) {
        if (source == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/dnd/DnDEnabler.<init> must not be null");
        }
        this.myAwtListener = new MyAwtListener();
        this.myLafManagerListener = new LafManagerListener(){

            public void lookAndFeelChanged(LafManager source) {
                DnDEnabler.this.onSetUI();
            }
        };
        this.myDnDSource = source;
        JComponent component = source.getComponent();
        LafManager.getInstance().addLafManagerListener(this.myLafManagerListener);
        UiNotifyConnector connector = new UiNotifyConnector((Component)component, (Activatable)this);
        Disposer.register((Disposable)this, (Disposable)connector);
        Disposer.register((Disposable)parent, (Disposable)this);
        this.onSetUI();
    }

    public void dispose() {
        LafManager.getInstance().removeLafManagerListener(this.myLafManagerListener);
        this.myOriginalDragGestureRecognizer = null;
    }

    public void showNotify() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.myAwtListener);
        Toolkit.getDefaultToolkit().addAWTEventListener(this.myAwtListener, 16L);
    }

    public void hideNotify() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.myAwtListener);
    }

    public void onSetUI() {
        this.myMouseListeners = new ArrayList<EventListener>();
        new AwtVisitor(this.myDnDSource.getComponent()){

            public boolean visit(Component component) {
                EventListener[] mouseListeners = component.getListeners(MouseListener.class);
                if (mouseListeners.length > 0) {
                    DnDEnabler.this.myMouseListeners.addAll(Arrays.asList(mouseListeners));
                    for (EventListener each : mouseListeners) {
                        if (each instanceof MouseDragGestureRecognizer) {
                            DnDEnabler.this.myOriginalDragGestureRecognizer = (MouseListener)each;
                            DnDEnabler.this.myMouseListeners.remove(each);
                        }
                        component.removeMouseListener((MouseListener)each);
                    }
                }
                return false;
            }
        };
        this.readTooltipListeners();
    }

    private void readTooltipListeners() {
        ToolTipManager manager = ToolTipManager.sharedInstance();
        this.myTooltipListener1 = manager;
        try {
            Field moveBefore = manager.getClass().getDeclaredField("moveBeforeEnterListener");
            if (!MouseListener.class.isAssignableFrom(moveBefore.getType())) {
                return;
            }
            moveBefore.setAccessible(true);
            this.myTooltipListener2 = (MouseListener)moveBefore.get(manager);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void dispatchMouseEvent(MouseListener listener, MouseEvent e) {
        if (listener != null) {
            int id = e.getID();
            switch (id) {
                case 501: {
                    listener.mousePressed(e);
                    break;
                }
                case 502: {
                    listener.mouseReleased(e);
                    break;
                }
                case 500: {
                    listener.mouseClicked(e);
                    break;
                }
                case 505: {
                    listener.mouseExited(e);
                    break;
                }
                case 504: {
                    listener.mouseEntered(e);
                }
            }
        }
    }

    public boolean isPressedToSelection(MouseEvent e) {
        if (501 != e.getID()) {
            return false;
        }
        return this.isToSelection(e);
    }

    private boolean isToSelection(MouseEvent e) {
        if (!DnDEnabler.isPureButton1Event(e)) {
            return false;
        }
        return e.getClickCount() == 1 && this.myDnDSource.isOverSelection(e.getPoint());
    }

    public boolean isPopupToSelection(MouseEvent e) {
        return e.isPopupTrigger() && this.myDnDSource.isOverSelection(e.getPoint());
    }

    private static boolean isPureButton1Event(MouseEvent event) {
        int button1 = 1040;
        return (event.getModifiersEx() | button1) == button1;
    }

    private static boolean shouldIgnore(MouseEvent event, Component c) {
        return c == null || !c.isEnabled() || !SwingUtilities.isLeftMouseButton(event);
    }

    private class MyAwtListener
    implements AWTEventListener {
        private MyAwtListener() {
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            if (event instanceof MouseEvent) {
                MouseEvent e = (MouseEvent)event;
                JComponent comp = DnDEnabler.this.myDnDSource.getComponent();
                if (e.getComponent() != comp) {
                    return;
                }
                if (e.getComponent() == comp) {
                    JComponent c;
                    boolean shouldProcessTooltipManager = true;
                    if (e.getComponent() instanceof JComponent && (c = (JComponent)e.getComponent()).getToolTipText() == null) {
                        shouldProcessTooltipManager = false;
                    }
                    if (DnDEnabler.this.isPressedToSelection(e)) {
                        if (DnDEnabler.this.myDnDSource.getComponent().isFocusable()) {
                            DnDEnabler.this.myDnDSource.getComponent().requestFocus();
                        }
                    } else {
                        boolean popupToSelection = DnDEnabler.this.isPopupToSelection(e);
                        if (!e.isConsumed()) {
                            EventListener[] eventListeners;
                            assert (e.getComponent() != null) : "component is null! IDEADEV-6339";
                            for (EventListener each : eventListeners = DnDEnabler.this.myMouseListeners.toArray(new EventListener[DnDEnabler.this.myMouseListeners.size()])) {
                                if (!shouldProcessTooltipManager && (each == DnDEnabler.this.myTooltipListener1 || each == DnDEnabler.this.myTooltipListener2) || popupToSelection && each != null && each.getClass().getName().indexOf("BasicTreeUI$DragFixHandler") >= 0) continue;
                                if (DnDEnabler.this.isToSelection(e) && e.getID() == 502) {
                                    DnDEnabler.this.myDnDSource.dropSelectionButUnderPoint(e.getPoint());
                                }
                                DnDEnabler.dispatchMouseEvent((MouseListener)each, e);
                                if (e.isConsumed()) break;
                            }
                            if (shouldProcessTooltipManager) {
                                ((JComponent)e.getComponent()).setToolTipText(null);
                            }
                        }
                    }
                    if (DnDEnabler.this.myOriginalDragGestureRecognizer != null && !DnDEnabler.shouldIgnore(e, comp)) {
                        DnDEnabler.dispatchMouseEvent(DnDEnabler.this.myOriginalDragGestureRecognizer, e);
                    }
                }
            }
        }
    }
}

