/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks;

import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.bookmarks.BookmarksListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorMouseAdapter;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.ex.EditorEventMulticasterEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.messages.MessageBus;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

@State(name="BookmarkManager", storages={@Storage(id="default", file="$WORKSPACE_FILE$")})
public class BookmarkManager
implements PersistentStateComponent<Element> {
    private static final int MAX_AUTO_DESCRIPTION_SIZE = 50;
    private final List<Bookmark> myBookmarks = new ArrayList<Bookmark>();
    private final MyEditorMouseListener myEditorMouseListener = new MyEditorMouseListener();
    private final Project myProject;
    private final MessageBus myBus;

    public static BookmarkManager getInstance(Project project) {
        return (BookmarkManager)ServiceManager.getService((Project)project, BookmarkManager.class);
    }

    public BookmarkManager(Project project, MessageBus bus) {
        this.myProject = project;
        this.myBus = bus;
    }

    public void projectOpened() {
        EditorEventMulticasterEx eventMulticaster = (EditorEventMulticasterEx)EditorFactory.getInstance().getEventMulticaster();
        eventMulticaster.addEditorMouseListener((EditorMouseListener)this.myEditorMouseListener, (Disposable)this.myProject);
    }

    public Project getProject() {
        return this.myProject;
    }

    public void addEditorBookmark(Editor editor, int lineIndex) {
        Document document = editor.getDocument();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        if (psiFile == null) {
            return;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        this.addTextBookmark(virtualFile, lineIndex, BookmarkManager.getAutoDescription(editor, lineIndex));
    }

    public Bookmark addTextBookmark(VirtualFile file, int lineIndex, String description) {
        Bookmark b = new Bookmark(this.myProject, file, lineIndex, description);
        ((BookmarksListener)this.myBus.syncPublisher(BookmarksListener.TOPIC)).bookmarkAdded(b);
        this.myBookmarks.add(0, b);
        return b;
    }

    public static String getAutoDescription(Editor editor, int lineIndex) {
        String autoDescription = editor.getSelectionModel().getSelectedText();
        if (autoDescription == null) {
            Document document = editor.getDocument();
            autoDescription = ((Object)document.getCharsSequence().subSequence(document.getLineStartOffset(lineIndex), document.getLineEndOffset(lineIndex))).toString().trim();
        }
        if (autoDescription.length() > 50) {
            return autoDescription.substring(0, 50) + "...";
        }
        return autoDescription;
    }

    @Nullable
    public Bookmark addFileBookmark(VirtualFile file, String description) {
        if (file == null) {
            return null;
        }
        if (this.findFileBookmark(file) != null) {
            return null;
        }
        Bookmark b = new Bookmark(this.myProject, file, description);
        this.myBookmarks.add(0, b);
        ((BookmarksListener)this.myBus.syncPublisher(BookmarksListener.TOPIC)).bookmarkAdded(b);
        return b;
    }

    public List<Bookmark> getValidBookmarks() {
        ArrayList<Bookmark> answer = new ArrayList<Bookmark>();
        for (Bookmark bookmark : this.myBookmarks) {
            if (!bookmark.isValid()) continue;
            answer.add(bookmark);
        }
        return answer;
    }

    @Nullable
    public Bookmark findEditorBookmark(Document document, int lineIndex) {
        for (Bookmark bookmark : this.myBookmarks) {
            if (bookmark.getDocument() != document || bookmark.getLine() != lineIndex) continue;
            return bookmark;
        }
        return null;
    }

    @Nullable
    public Bookmark findFileBookmark(VirtualFile file) {
        for (Bookmark bookmark : this.myBookmarks) {
            if (bookmark.getFile() != file || bookmark.getLine() != -1) continue;
            return bookmark;
        }
        return null;
    }

    @Nullable
    public Bookmark findBookmarkForMnemonic(char m) {
        char mm = Character.toUpperCase(m);
        for (Bookmark bookmark : this.myBookmarks) {
            if (mm != bookmark.getMnemonic()) continue;
            return bookmark;
        }
        return null;
    }

    public boolean hasBookmarksWithMnemonics() {
        for (Bookmark bookmark : this.myBookmarks) {
            if (bookmark.getMnemonic() == '\u0000') continue;
            return true;
        }
        return false;
    }

    public void removeBookmark(Bookmark bookmark) {
        this.myBookmarks.remove(bookmark);
        bookmark.release();
        ((BookmarksListener)this.myBus.syncPublisher(BookmarksListener.TOPIC)).bookmarkRemoved(bookmark);
    }

    public Element getState() {
        Element container = new Element("BookmarkManager");
        this.writeExternal(container);
        return container;
    }

    public void loadState(Element state) {
        BookmarksListener publisher = (BookmarksListener)this.myBus.syncPublisher(BookmarksListener.TOPIC);
        for (Bookmark bookmark : this.myBookmarks) {
            bookmark.release();
            publisher.bookmarkRemoved(bookmark);
        }
        this.myBookmarks.clear();
        this.readExternal(state);
    }

    private void readExternal(Element element) {
        for (Object o : element.getChildren()) {
            Element bookmarkElement = (Element)o;
            if (!"bookmark".equals(bookmarkElement.getName())) continue;
            String url = bookmarkElement.getAttributeValue("url");
            String line = bookmarkElement.getAttributeValue("line");
            String description = bookmarkElement.getAttributeValue("description");
            String mnemonic = bookmarkElement.getAttributeValue("mnemonic");
            Bookmark b = null;
            VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
            if (file != null) {
                if (line != null) {
                    try {
                        int lineIndex = Integer.parseInt(line);
                        b = this.addTextBookmark(file, lineIndex, description);
                    }
                    catch (NumberFormatException e) {}
                } else {
                    b = this.addFileBookmark(file, description);
                }
            }
            if (b == null || mnemonic == null || mnemonic.length() != 1) continue;
            this.setMnemonic(b, mnemonic.charAt(0));
        }
    }

    private void writeExternal(Element element) {
        ArrayList<Bookmark> reversed = new ArrayList<Bookmark>(this.myBookmarks);
        Collections.reverse(reversed);
        for (Bookmark bookmark : reversed) {
            char mnemonic;
            int line;
            Element bookmarkElement = new Element("bookmark");
            bookmarkElement.setAttribute("url", bookmark.getFile().getUrl());
            String description = bookmark.getNotEmptyDescription();
            if (description != null) {
                bookmarkElement.setAttribute("description", description);
            }
            if ((line = bookmark.getLine()) >= 0) {
                bookmarkElement.setAttribute("line", String.valueOf(line));
            }
            if ((mnemonic = bookmark.getMnemonic()) != '\u0000') {
                bookmarkElement.setAttribute("mnemonic", String.valueOf(mnemonic));
            }
            element.addContent(bookmarkElement);
        }
    }

    public List<Bookmark> moveBookmarkUp(Bookmark bookmark) {
        int index = this.myBookmarks.indexOf(bookmark);
        if (index > 0) {
            Collections.swap(this.myBookmarks, index, index - 1);
        }
        return this.myBookmarks;
    }

    public List<Bookmark> moveBookmarkDown(Bookmark bookmark) {
        int index = this.myBookmarks.indexOf(bookmark);
        if (index < this.myBookmarks.size() - 1) {
            Collections.swap(this.myBookmarks, index, index + 1);
        }
        return this.myBookmarks;
    }

    @Nullable
    public Bookmark getNextBookmark(Editor editor, boolean isWrapped) {
        Bookmark[] bookmarksForDocument = this.getBookmarksForDocument(editor.getDocument());
        int lineNumber = editor.getCaretModel().getLogicalPosition().line;
        for (Bookmark bookmark : bookmarksForDocument) {
            if (bookmark.getLine() <= lineNumber) continue;
            return bookmark;
        }
        if (isWrapped && bookmarksForDocument.length > 0) {
            return bookmarksForDocument[0];
        }
        return null;
    }

    @Nullable
    public Bookmark getPreviousBookmark(Editor editor, boolean isWrapped) {
        Bookmark[] bookmarksForDocument = this.getBookmarksForDocument(editor.getDocument());
        int lineNumber = editor.getCaretModel().getLogicalPosition().line;
        for (int i = bookmarksForDocument.length - 1; i >= 0; --i) {
            Bookmark bookmark = bookmarksForDocument[i];
            if (bookmark.getLine() >= lineNumber) continue;
            return bookmark;
        }
        if (isWrapped && bookmarksForDocument.length > 0) {
            return bookmarksForDocument[bookmarksForDocument.length - 1];
        }
        return null;
    }

    private Bookmark[] getBookmarksForDocument(Document document) {
        ArrayList<Bookmark> answer = new ArrayList<Bookmark>();
        for (Bookmark bookmark : this.getValidBookmarks()) {
            if (!document.equals(bookmark.getDocument())) continue;
            answer.add(bookmark);
        }
        Bookmark[] bookmarks = answer.toArray(new Bookmark[answer.size()]);
        Arrays.sort(bookmarks, new Comparator<Bookmark>(){

            @Override
            public int compare(Bookmark o1, Bookmark o2) {
                return o1.getLine() - o2.getLine();
            }
        });
        return bookmarks;
    }

    public void setMnemonic(Bookmark bookmark, char c) {
        Bookmark old = this.findBookmarkForMnemonic(c);
        if (old != null) {
            this.removeBookmark(old);
        }
        bookmark.setMnemonic(c);
        ((BookmarksListener)this.myBus.syncPublisher(BookmarksListener.TOPIC)).bookmarkChanged(bookmark);
    }

    public void setDescription(Bookmark bookmark, String description) {
        bookmark.setDescription(description);
        ((BookmarksListener)this.myBus.syncPublisher(BookmarksListener.TOPIC)).bookmarkChanged(bookmark);
    }

    private class MyEditorMouseListener
    extends EditorMouseAdapter {
        private MyEditorMouseListener() {
        }

        public void mouseClicked(EditorMouseEvent e) {
            if (e.getArea() != EditorMouseEventArea.LINE_MARKERS_AREA) {
                return;
            }
            if (e.getMouseEvent().isPopupTrigger()) {
                return;
            }
            if ((e.getMouseEvent().getModifiers() & 2) == 0) {
                return;
            }
            Editor editor = e.getEditor();
            int line = editor.xyToLogicalPosition((Point)new Point((int)e.getMouseEvent().getX(), (int)e.getMouseEvent().getY())).line;
            if (line < 0) {
                return;
            }
            Document document = editor.getDocument();
            Bookmark bookmark = BookmarkManager.this.findEditorBookmark(document, line);
            if (bookmark == null) {
                BookmarkManager.this.addEditorBookmark(editor, line);
            } else {
                BookmarkManager.this.removeBookmark(bookmark);
            }
            e.consume();
        }
    }
}

