/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.StartUseVcsDialog;
import com.intellij.ide.actions.VcsDataWrapper;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import java.util.Arrays;

public class StartUseVcsAction
extends AnAction
implements DumbAware {
    public void update(AnActionEvent e) {
        VcsDataWrapper data = new VcsDataWrapper(e);
        boolean enabled = data.enabled();
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(enabled);
        presentation.setVisible(enabled);
        if (enabled) {
            presentation.setText(VcsBundle.message((String)"action.enable.version.control.integration.text", (Object[])new Object[0]));
        }
    }

    public void actionPerformed(AnActionEvent e) {
        String vcsName;
        VcsDataWrapper data = new VcsDataWrapper(e);
        boolean enabled = data.enabled();
        if (!enabled) {
            return;
        }
        StartUseVcsDialog dialog = new StartUseVcsDialog(data);
        dialog.show();
        if (dialog.getExitCode() == 0 && (vcsName = dialog.getVcs()).length() > 0) {
            ProjectLevelVcsManager manager = data.getManager();
            manager.findVcsByName(vcsName).generalPreConfigurationStep();
            manager.setDirectoryMappings(Arrays.asList(new VcsDirectoryMapping("", vcsName)));
        }
    }
}

