/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;

public class RevealFileAction
extends AnAction {
    public void update(AnActionEvent e) {
        VirtualFile file = (VirtualFile)PlatformDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
        if (file != null && file.isInLocalFileSystem()) {
            if (SystemInfo.isMac) {
                e.getPresentation().setText("Reveal In Finder");
            } else {
                e.getPresentation().setText("Show In Explorer");
            }
        } else {
            e.getPresentation().setEnabled(false);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        VirtualFile file = (VirtualFile)PlatformDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
        File ioFile = new File(file.getPresentableUrl());
        if (!ioFile.isDirectory()) {
            ioFile = ioFile.getParentFile();
        }
        ShowFilePathAction.open(ioFile, ioFile);
    }
}

