/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectOpenProcessor;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class OpenProjectFileChooserDescriptor
extends FileChooserDescriptor {
    private final Icon myProjectIcon = IconLoader.getIcon((String)ApplicationInfoImpl.getInstanceEx().getSmallIconUrl());

    public OpenProjectFileChooserDescriptor(boolean chooseFiles) {
        super(chooseFiles, true, false, false, false, false);
    }

    public boolean isFileSelectable(VirtualFile file) {
        return OpenProjectFileChooserDescriptor.isProjectDirectory(file) || OpenProjectFileChooserDescriptor.isProjectFile(file);
    }

    public Icon getOpenIcon(VirtualFile virtualFile) {
        if (OpenProjectFileChooserDescriptor.isProjectDirectory(virtualFile)) {
            return this.myProjectIcon;
        }
        Icon icon = OpenProjectFileChooserDescriptor.getImporterIcon(virtualFile, true);
        if (icon != null) {
            return icon;
        }
        return super.getOpenIcon(virtualFile);
    }

    public Icon getClosedIcon(VirtualFile virtualFile) {
        if (OpenProjectFileChooserDescriptor.isProjectDirectory(virtualFile)) {
            return this.myProjectIcon;
        }
        Icon icon = OpenProjectFileChooserDescriptor.getImporterIcon(virtualFile, false);
        if (icon != null) {
            return icon;
        }
        return super.getClosedIcon(virtualFile);
    }

    @Nullable
    public static Icon getImporterIcon(VirtualFile virtualFile, boolean open) {
        ProjectOpenProcessor provider = ProjectOpenProcessor.getImportProvider((VirtualFile)virtualFile);
        if (provider != null) {
            return provider.getIcon();
        }
        return null;
    }

    public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
        if (!showHiddenFiles && FileElement.isFileHidden((VirtualFile)file)) {
            return false;
        }
        return OpenProjectFileChooserDescriptor.isProjectFile(file) || super.isFileVisible(file, showHiddenFiles) && file.isDirectory();
    }

    private static boolean isProjectFile(VirtualFile file) {
        return !file.isDirectory() && file.getName().toLowerCase().endsWith(".ipr") || ProjectOpenProcessor.getImportProvider((VirtualFile)file) != null;
    }

    private static boolean isProjectDirectory(VirtualFile virtualFile) {
        if (virtualFile.getParent() == null) {
            return false;
        }
        return virtualFile.isDirectory() && virtualFile.isValid() && virtualFile.findChild(".idea") != null;
    }
}

