/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.WindowEvent;

public class CloseWindowAction
extends AnAction
implements DumbAware {
    public CloseWindowAction() {
        this.setEnabledInModalContext(true);
    }

    private static Window getWindow() {
        Window focusedWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        if (!(focusedWindow instanceof Dialog) && !(focusedWindow instanceof Frame)) {
            return null;
        }
        if (focusedWindow instanceof Dialog) {
            Dialog dialog = (Dialog)focusedWindow;
            if (!dialog.isUndecorated()) {
                return focusedWindow;
            }
            return null;
        }
        if (!(focusedWindow instanceof IdeFrameImpl)) {
            Frame frame = (Frame)focusedWindow;
            if (!frame.isUndecorated()) {
                return focusedWindow;
            }
            return null;
        }
        return null;
    }

    public void actionPerformed(AnActionEvent e) {
        Window window = CloseWindowAction.getWindow();
        WindowEvent event = new WindowEvent(window, 201);
        window.dispatchEvent(event);
    }

    public void update(AnActionEvent e) {
        super.update(e);
        e.getPresentation().setEnabled(CloseWindowAction.getWindow() != null);
    }
}

