/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CloseEditorsActionBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;

public class CloseAllUnpinnedEditorsAction
extends CloseEditorsActionBase {
    @Override
    protected boolean isFileToClose(EditorComposite editor, EditorWindow window) {
        return !window.isFilePinned(editor.getFile());
    }

    @Override
    protected String getPresentationText(boolean inSplitter) {
        if (inSplitter) {
            return IdeBundle.message((String)"action.close.all.unpinned.editors.in.tab.group", (Object[])new Object[0]);
        }
        return IdeBundle.message((String)"action.close.all.unpinned.editors", (Object[])new Object[0]);
    }

    @Override
    protected boolean isActionEnabled(Project project, AnActionEvent event) {
        ArrayList<Pair<EditorComposite, EditorWindow>> filesToClose = this.getFilesToClose(event);
        if (filesToClose.isEmpty()) {
            return false;
        }
        HashSet checked = new HashSet();
        for (Pair<EditorComposite, EditorWindow> pair : filesToClose) {
            EditorWindow window = (EditorWindow)pair.second;
            if (checked.contains(window)) continue;
            checked.add(window);
            if (!CloseAllUnpinnedEditorsAction.hasPinned(window)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasPinned(EditorWindow window) {
        for (EditorWithProviderComposite e : window.getEditors()) {
            if (!e.isPinned()) continue;
            return true;
        }
        return false;
    }
}

