/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.Patches;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.LicenseeInfoProvider;
import com.intellij.util.ImageLoader;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;

public class AboutAction
extends AnAction
implements DumbAware {
    @NonNls
    private static final String COMPANY_URL = "http://www.jetbrains.com/";

    public void update(AnActionEvent e) {
        e.getPresentation().setVisible(!SystemInfo.isMacSystemMenu);
        e.getPresentation().setDescription("Show information about " + ApplicationNamesInfo.getInstance().getFullProductName());
    }

    public void actionPerformed(AnActionEvent e) {
        Window window = WindowManager.getInstance().suggestParentWindow((Project)e.getData(PlatformDataKeys.PROJECT));
        AboutAction.showAboutDialog(window);
    }

    public static void showAbout() {
        Window window = WindowManager.getInstance().suggestParentWindow((Project)PlatformDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext()));
        AboutAction.showAboutDialog(window);
    }

    private static void showAboutDialog(Window window) {
        JPanel closeListenerOwner;
        ApplicationInfoEx appInfo = (ApplicationInfoEx)ApplicationInfo.getInstance();
        JPanel mainPanel = new JPanel(new BorderLayout());
        if (appInfo.showLicenseeInfo()) {
            Image image = ImageLoader.loadFromResource((String)appInfo.getAboutLogoUrl());
            InfoSurface infoSurface = new InfoSurface(image);
            infoSurface.setPreferredSize(new Dimension(image.getWidth(null), image.getHeight(null)));
            mainPanel.add((Component)infoSurface, "North");
            closeListenerOwner = infoSurface;
        } else {
            mainPanel.add((Component)new JLabel(IconLoader.getIcon((String)appInfo.getAboutLogoUrl())), "North");
            closeListenerOwner = mainPanel;
        }
        final JDialog dialog = window instanceof Dialog ? new JDialog((Dialog)window) : new JDialog((Frame)window);
        dialog.setUndecorated(true);
        dialog.setContentPane(mainPanel);
        dialog.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27 && e.getModifiers() == 0) {
                    dialog.dispose();
                }
            }
        });
        final long showTime = System.currentTimeMillis();
        final long delta = Patches.APPLE_BUG_ID_3716865 ? 100L : 0L;
        dialog.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                long eventTime = System.currentTimeMillis();
                if (eventTime - showTime > delta && e.getOppositeWindow() != e.getWindow()) {
                    dialog.dispose();
                }
            }
        });
        closeListenerOwner.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!e.isConsumed()) {
                    dialog.dispose();
                    e.consume();
                }
            }
        });
        dialog.pack();
        dialog.setLocationRelativeTo(window);
        dialog.setVisible(true);
    }

    private static class InfoSurface
    extends JPanel {
        final Color col;
        final Color linkCol;
        private final Image myImage;
        private Font myFont;
        private Font myBoldFont;
        private final List<AboutBoxLine> myLines = new ArrayList<AboutBoxLine>();
        private int linkX;
        private int linkY;
        private int linkWidth;
        private boolean inLink = false;

        public InfoSurface(Image image) {
            this.myImage = image;
            this.setOpaque(false);
            this.col = Color.white;
            this.linkCol = Color.blue;
            this.setBackground(this.col);
            ApplicationInfoEx ideInfo = (ApplicationInfoEx)ApplicationInfo.getInstance();
            Calendar cal = ideInfo.getBuildDate();
            this.myLines.add(new AboutBoxLine(ideInfo.getFullApplicationName(), true, false));
            this.myLines.add(new AboutBoxLine(IdeBundle.message((String)"aboutbox.build.number", (Object[])new Object[]{ideInfo.getBuild().asString()})));
            this.myLines.add(new AboutBoxLine(IdeBundle.message((String)"aboutbox.build.date", (Object[])new Object[]{DateFormat.getDateInstance(1).format(cal.getTime())})));
            this.myLines.add(new AboutBoxLine(""));
            LicenseeInfoProvider provider = LicenseeInfoProvider.getInstance();
            if (provider != null) {
                this.myLines.add(new AboutBoxLine(provider.getLicensedToMessage(), true, false));
                this.myLines.add(new AboutBoxLine(provider.getLicenseRestrictionsMessage()));
                Date mdd = provider.getMaintenanceDueDate();
                if (mdd != null) {
                    this.myLines.add(new AboutBoxLine(IdeBundle.message((String)"aboutbox.maintenance.due", (Object[])new Object[]{mdd})));
                }
            }
            this.myLines.add(new AboutBoxLine(""));
            Properties properties = System.getProperties();
            this.myLines.add(new AboutBoxLine(IdeBundle.message((String)"aboutbox.jdk", (Object[])new Object[]{properties.getProperty("java.version", "unknown")}), true, false));
            this.myLines.add(new AboutBoxLine(IdeBundle.message((String)"aboutbox.vm", (Object[])new Object[]{properties.getProperty("java.vm.name", "unknown")})));
            this.myLines.add(new AboutBoxLine(IdeBundle.message((String)"aboutbox.vendor", (Object[])new Object[]{properties.getProperty("java.vendor", "unknown")})));
            this.myLines.add(new AboutBoxLine(""));
            this.myLines.add(new AboutBoxLine("JetBrains s.r.o.", true, false));
            this.myLines.add(new AboutBoxLine(AboutAction.COMPANY_URL, true, true));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent event) {
                    if (InfoSurface.this.inLink) {
                        event.consume();
                        BrowserUtil.launchBrowser((String)AboutAction.COMPANY_URL);
                    }
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent event) {
                    if (event.getPoint().x > InfoSurface.this.linkX && event.getPoint().y >= InfoSurface.this.linkY && event.getPoint().x < InfoSurface.this.linkX + InfoSurface.this.linkWidth && event.getPoint().y < InfoSurface.this.linkY + 10) {
                        if (!InfoSurface.this.inLink) {
                            InfoSurface.this.setCursor(Cursor.getPredefinedCursor(12));
                            InfoSurface.this.inLink = true;
                        }
                    } else if (InfoSurface.this.inLink) {
                        InfoSurface.this.setCursor(Cursor.getDefaultCursor());
                        InfoSurface.this.inLink = false;
                    }
                }
            });
        }

        @Override
        protected void paintChildren(Graphics g) {
            super.paintChildren(g);
            Graphics2D g2 = (Graphics2D)g;
            Font labelFont = UIUtil.getLabelFont();
            for (int labelSize = 10; labelSize != 6; --labelSize) {
                g2.setPaint(this.col);
                g2.drawImage(this.myImage, 0, 0, this);
                g2.setColor(this.col);
                TextRenderer renderer = new TextRenderer(0, 145, 398, 120, g2);
                g2.setComposite(AlphaComposite.Src);
                this.myFont = labelFont.deriveFont(0, labelSize);
                this.myBoldFont = labelFont.deriveFont(1, labelSize + 1);
                try {
                    renderer.render(75, 0, this.myLines);
                    break;
                }
                catch (TextRenderer.OverflowException _) {
                    continue;
                }
            }
        }

        public class TextRenderer {
            private final int xBase;
            private final int yBase;
            private final int w;
            private final int h;
            private final Graphics2D g2;
            private int x = 0;
            private int y = 0;
            private FontMetrics fontmetrics;
            private int fontAscent;
            private int fontHeight;
            private Font font;

            public TextRenderer(int xBase, int yBase, int w, int h, Graphics2D g2) {
                this.xBase = xBase;
                this.yBase = yBase;
                this.w = w;
                this.h = h;
                this.g2 = g2;
                if (SystemInfo.isWindows) {
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                }
            }

            public void render(int indentX, int indentY, List<AboutBoxLine> lines) throws OverflowException {
                this.x = indentX;
                this.y = indentY;
                this.g2.setColor(Color.black);
                for (int i = 0; i < lines.size(); ++i) {
                    AboutBoxLine line = lines.get(i);
                    String s = line.getText();
                    this.setFont(line.isBold() ? InfoSurface.this.myBoldFont : InfoSurface.this.myFont);
                    if (line.isLink()) {
                        this.g2.setColor(InfoSurface.this.linkCol);
                        InfoSurface.this.linkX = this.x;
                        InfoSurface.this.linkY = this.yBase + this.y - this.fontAscent;
                        FontMetrics metrics = this.g2.getFontMetrics(this.font);
                        InfoSurface.this.linkWidth = metrics.stringWidth(s);
                    }
                    this.renderString(s, indentX);
                    if (i == lines.size() - 2) {
                        this.x += 50;
                        continue;
                    }
                    if (i >= lines.size() - 1) continue;
                    this.lineFeed(indentX, s);
                }
            }

            private void renderString(String s, int indentX) throws OverflowException {
                List words = StringUtil.split((String)s, (String)" ");
                for (String word : words) {
                    int wordWidth = this.fontmetrics.stringWidth(word);
                    if (this.x + wordWidth >= this.w) {
                        this.lineFeed(indentX, word);
                    } else {
                        char c = ' ';
                        int cW = this.fontmetrics.charWidth(c);
                        if (this.x + cW < this.w) {
                            this.g2.drawChars(new char[]{c}, 0, 1, this.xBase + this.x, this.yBase + this.y);
                            this.x += cW;
                        }
                    }
                    this.renderWord(word, indentX);
                }
            }

            private void renderWord(String s, int indentX) throws OverflowException {
                for (int j = 0; j != s.length(); ++j) {
                    char c = s.charAt(j);
                    int cW = this.fontmetrics.charWidth(c);
                    if (this.x + cW >= this.w) {
                        this.lineFeed(indentX, s);
                    }
                    this.g2.drawChars(new char[]{c}, 0, 1, this.xBase + this.x, this.yBase + this.y);
                    this.x += cW;
                }
            }

            private void lineFeed(int indent, String s) throws OverflowException {
                this.x = indent;
                this.y = s.length() == 0 ? (this.y += this.fontHeight / 3) : (this.y += this.fontHeight);
                if (this.y >= this.h) {
                    throw new OverflowException();
                }
            }

            private void setFont(Font font) {
                this.font = font;
                this.fontmetrics = this.g2.getFontMetrics(font);
                this.g2.setFont(font);
                this.fontAscent = this.fontmetrics.getAscent();
                this.fontHeight = this.fontmetrics.getHeight();
            }

            public class OverflowException
            extends Exception {
            }
        }
    }

    private static class AboutBoxLine {
        private final String myText;
        private final boolean myBold;
        private final boolean myLink;

        public AboutBoxLine(String text, boolean bold, boolean link) {
            this.myLink = link;
            this.myText = text;
            this.myBold = bold;
        }

        public AboutBoxLine(String text) {
            this.myText = text;
            this.myBold = false;
            this.myLink = false;
        }

        public String getText() {
            return this.myText;
        }

        public boolean isBold() {
            return this.myBold;
        }

        public boolean isLink() {
            return this.myLink;
        }
    }
}

